/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.vermessungsunterlagen.tasks;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.utils.alkis.AlkisPointReportBean;
import de.cismet.cids.custom.utils.alkis.AlkisProducts;
import de.cismet.cids.custom.utils.alkis.ServerAlkisProducts;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenUtils;
import de.cismet.cids.custom.utils.vermessungsunterlagen.exceptions.VermessungsunterlagenTaskException;
import de.cismet.cids.custom.utils.vermessungsunterlagen.tasks.VermUntTaskAP;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class VermUntTaskAPMap
extends VermUntTaskAP {
    public static final String TYPE = "AP_Karten";

    public VermUntTaskAPMap(String jobkey, Collection<CidsBean> alkisPoints) {
        super(TYPE, jobkey, alkisPoints);
    }

    @Override
    public void performTask() throws VermessungsunterlagenTaskException {
        try {
            String filename = this.getPath() + "/" + ServerAlkisProducts.getInstance().get(AlkisProducts.Type.PUNKTLISTE_PDF) + ".pdf";
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("SUBREPORT_DIR", DomainServerImpl.getServerProperties().getServerResourcesBasePath() + "/");
            try (FileOutputStream out = new FileOutputStream(filename);){
                VermessungsunterlagenUtils.jasperReportDownload(ServerResourcesLoader.getInstance().loadJasperReport(WundaBlauServerResources.APMAPS_JASPER.getValue()), parameters, (JRDataSource)new JRBeanCollectionDataSource(Arrays.asList(new AlkisPointReportBean(this.getAlkisPoints()))), out);
            }
        }
        catch (Exception ex) {
            String message = "Beim Erstellen des Punktlisten-Berichtes kam es zu einem unerwarteten Fehler.";
            throw new VermessungsunterlagenTaskException(this.getType(), "Beim Erstellen des Punktlisten-Berichtes kam es zu einem unerwarteten Fehler.", ex);
        }
    }
}

