/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.formsolutions.FormSolutionsFtpClient;
import de.cismet.cids.custom.utils.formsolutions.FormSolutionsProperties;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionHelper;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class FormSolutionDownloadBestellungAction
implements ServerAction,
UserAwareServerAction,
ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(FormSolutionDownloadBestellungAction.class);
    public static final String TASK_NAME = "formSolutionDownloadBestellung";
    private User user;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        if (body == null) {
            throw new RuntimeException("The body is missing.");
        }
        if (!(body instanceof MetaObjectNode)) {
            throw new RuntimeException("Wrong type for body, have to be an MetaObjectNode.");
        }
        try {
            Type type = Type.PRODUCT;
            if (params != null) {
                for (ServerActionParameter sap : params) {
                    if (!sap.getKey().equals(Parameter.TYPE.toString())) continue;
                    type = (Type)((Object)sap.getValue());
                }
            }
            boolean rechung = Type.RECHNUNG.equals((Object)type);
            MetaObjectNode mon = (MetaObjectNode)body;
            CidsBean bestellungBean = DomainServerImpl.getServerInstance().getMetaObject(this.getUser(), mon.getObjectId(), mon.getClassId(), this.getConnectionContext()).getBean();
            String fileName = rechung ? (String)bestellungBean.getProperty("rechnung_dateipfad") : (String)bestellungBean.getProperty("produkt_dateipfad");
            String ftpSubDir = rechung ? FormSolutionsProperties.getInstance().getRechnungBasepath() : FormSolutionsProperties.getInstance().getProduktBasepath();
            String ftpFilePath = (ftpSubDir.endsWith("/") ? ftpSubDir : ftpSubDir + "/") + fileName;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (FormSolutionsProperties.getInstance().isFtpEnabled()) {
                FormSolutionsFtpClient.getInstance().download(ftpFilePath, out);
            } else {
                String mntFile = FormSolutionsProperties.getInstance().getFtpMountAbsPath() + "/" + ftpFilePath;
                try (FileInputStream in = new FileInputStream(mntFile);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
            }
            return ServerActionHelper.asyncByteArrayHelper((Object)out.toByteArray(), (String)"fs.pdf");
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return ex;
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum Type {
        PRODUCT,
        RECHNUNG;

    }

    public static enum Parameter {
        TYPE;

    }
}

