/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.formsolutions.FormSolutionsProperties;
import de.cismet.cids.custom.wunda_blau.search.server.FormSolutionsBestellungSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.commons.security.AccessHandler;
import de.cismet.commons.security.handler.SimpleHttpAccessHandler;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class Redirect2FormsolutionsAction
implements UserAwareServerAction,
MetaServiceStore,
ConnectionContextStore {
    public static final String TASK_NAME = "redirect2Formsolutions";
    private static final transient Logger LOG = Logger.getLogger(Redirect2FormsolutionsAction.class);
    private User user;
    private MetaService metaService;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    private static String urlEncodeUTF8(Map<String, Object> map) throws Exception {
        ArrayList<String> keyValues = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null) continue;
            keyValues.add(String.format("%s=%s", URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(value != null ? value.toString() : "", "UTF-8")));
        }
        return String.join((CharSequence)"&", keyValues);
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        String transidHash = null;
        if (params != null) {
            for (ServerActionParameter sap : params) {
                if (!sap.getKey().equals(PARAMETER_TYPE.TRANSID_HASH.toString())) continue;
                transidHash = (String)sap.getValue();
            }
        }
        if (transidHash != null) {
            try {
                FormSolutionsBestellungSearch search = new FormSolutionsBestellungSearch();
                HashMap<String, MetaService> localServers = new HashMap<String, MetaService>();
                localServers.put("WUNDA_BLAU", this.getMetaService());
                search.setActiveLocalServers(localServers);
                search.setUser(this.getUser());
                search.setTransidHash(transidHash);
                Collection<MetaObjectNode> mons = search.performServerSearch();
                if (mons != null && mons.size() == 1) {
                    MetaObjectNode mon = mons.iterator().next();
                    MetaObject mo = this.getMetaService().getMetaObject(this.getUser(), mon.getObjectId(), mon.getClassId(), this.getConnectionContext());
                    CidsBean bestellungBean = mo.getBean();
                    String transid = (String)bestellungBean.getProperty("transid");
                    Double gebuehrDownload = (Double)bestellungBean.getProperty("gebuehr");
                    Double gebuehrPostweg = (Double)bestellungBean.getProperty("gebuehr_postweg");
                    String email = (String)bestellungBean.getProperty("email");
                    HashMap<String, Object> form = new HashMap<String, Object>();
                    form.put("Antragsteller.Daten.Vorgang", transid);
                    form.put("Antragsteller.Daten.Flurstueckskennzeichen", (String)bestellungBean.getProperty("landparcelcode"));
                    form.put("Antragsteller.Daten.Flurst\u00fcckskennzeichen", (String)bestellungBean.getProperty("landparcelcode"));
                    if (transid.startsWith("KFAS_KF600204")) {
                        form.put("Antragsteller.Daten.Buchungsblattkennzeichen", (String)bestellungBean.getProperty("buchungsblattcode"));
                    }
                    form.put("Antragsteller.Daten.betragDL", gebuehrDownload);
                    form.put("Antragsteller.Daten.betragPost", gebuehrPostweg);
                    form.put("Antragsteller.Daten.Email bei Postversand.E-Mailadresse.E-Mailadresse", email);
                    form.put("Antragsteller.Daten.Email bei Download.E-Mailadresse", email);
                    boolean rechnungsanschriftistLieferanschrift = Objects.equals(bestellungBean.getProperty("fk_adresse_rechnung"), bestellungBean.getProperty("fk_adresse_versand"));
                    form.put("Antragsteller.Daten.RechnungsanschriftistLieferanschrift", rechnungsanschriftistLieferanschrift);
                    String rechnungFirma = (String)bestellungBean.getProperty("fk_adresse_rechnung.firma");
                    String rechnungVorname = (String)bestellungBean.getProperty("fk_adresse_rechnung.vorname");
                    String rechnungName = (String)bestellungBean.getProperty("fk_adresse_rechnung.name");
                    String rechnungStrasse = (String)bestellungBean.getProperty("fk_adresse_rechnung.strasse");
                    String rechnungHausnummer = (String)bestellungBean.getProperty("fk_adresse_rechnung.hausnummer");
                    Integer rechnungPlz = (Integer)bestellungBean.getProperty("fk_adresse_rechnung.plz");
                    String rechnungOrt = (String)bestellungBean.getProperty("fk_adresse_rechnung.ort");
                    String rechnungStaat = (String)bestellungBean.getProperty("fk_adresse_rechnung.staat");
                    String rechnungAlternativ = (String)bestellungBean.getProperty("fk_adresse_rechnung.alternativ");
                    form.put("Antragsteller.Daten.Firma", rechnungFirma);
                    form.put("Antragsteller.Daten.AS_Name1.AS_Name1.AS_Vorname", rechnungVorname);
                    form.put("Antragsteller.Daten.AS_Name1.AS_Name1.AS_Name", rechnungName);
                    form.put("Antragsteller.Daten.AS_Adresse.AS_Adresse.Adresse.AS_Strasse", rechnungStrasse);
                    form.put("Antragsteller.Daten.AS_Adresse.AS_Adresse.Adresse.AS_Hausnummer", rechnungHausnummer);
                    form.put("Antragsteller.Daten.AS_Adresse.AS_Adresse.Adresse.AS_PLZ", rechnungPlz != null ? Integer.toString(rechnungPlz) : null);
                    form.put("Antragsteller.Daten.AS_Adresse.AS_Adresse.Adresse.AS_Ort", rechnungOrt);
                    form.put("Antragsteller.Daten.AS_Adresse.AS_Adresse.Adresse.staat.staat", rechnungStaat);
                    form.put("Antragsteller.Daten.Alt_Adresse", rechnungAlternativ);
                    form.put("Street", rechnungStrasse);
                    form.put("StreetNumber", rechnungHausnummer);
                    form.put("City", rechnungOrt);
                    form.put("ZipCode", rechnungPlz != null ? Integer.toString(rechnungPlz) : null);
                    String lieferFirma = (String)bestellungBean.getProperty("fk_adresse_versand.firma");
                    String lieferVorname = (String)bestellungBean.getProperty("fk_adresse_versand.vorname");
                    String lieferName = (String)bestellungBean.getProperty("fk_adresse_versand.name");
                    String lieferStrasse = (String)bestellungBean.getProperty("fk_adresse_versand.strasse");
                    String lieferHausnummer = (String)bestellungBean.getProperty("fk_adresse_versand.hausnummer");
                    Integer lieferPlz = (Integer)bestellungBean.getProperty("fk_adresse_versand.plz");
                    String lieferOrt = (String)bestellungBean.getProperty("fk_adresse_versand.ort");
                    String lieferStaat = (String)bestellungBean.getProperty("fk_adresse_versand.staat");
                    String lieferAlternativ = (String)bestellungBean.getProperty("fk_adresse_versand.alternativ");
                    form.put("Antragsteller.Daten.Firma_Abweichende_Lieferanschrift", lieferFirma);
                    form.put("Antragsteller.Daten.AS_Name1_Abweichende_Lieferanschrift.AS_Name1.AS_Vorname", lieferVorname);
                    form.put("Antragsteller.Daten.AS_Name1_Abweichende_Lieferanschrift.AS_Name1.AS_Name", lieferName);
                    form.put("Antragsteller.Daten.AS_Adresse_Abweichende_Lieferanschrift.AS_Adresse.Adresse.AS_Strasse", lieferStrasse);
                    form.put("Antragsteller.Daten.AS_Adresse_Abweichende_Lieferanschrift.AS_Adresse.Adresse.AS_Hausnummer", lieferHausnummer);
                    form.put("Antragsteller.Daten.AS_Adresse_Abweichende_Lieferanschrift.AS_Adresse.Adresse.AS_PLZ", lieferPlz);
                    form.put("Antragsteller.Daten.AS_Adresse_Abweichende_Lieferanschrift.AS_Adresse.Adresse.AS_Ort", lieferOrt);
                    form.put("Antragsteller.Daten.AS_Adresse_Abweichende_Lieferanschrift.AS_Adresse.Adresse.staat.staat", lieferStaat);
                    form.put("Antragsteller.Daten.Alt_Adresse_Abweichende_Lieferanschrift", lieferAlternativ);
                    HashMap<String, String> headerMap = new HashMap<String, String>();
                    headerMap.put("Content-Type", "application/x-www-form-urlencoded");
                    String urlParams = Redirect2FormsolutionsAction.urlEncodeUTF8(form);
                    LOG.info((Object)(FormSolutionsProperties.getInstance().getUrlCreateCacheid() + " | " + urlParams));
                    InputStream in = new SimpleHttpAccessHandler().doRequest(new URL(FormSolutionsProperties.getInstance().getUrlCreateCacheid()), (Reader)new StringReader(urlParams), AccessHandler.ACCESS_METHODS.POST_REQUEST, headerMap);
                    String cacheID = IOUtils.toString((InputStream)in, (String)"UTF-8");
                    String redirectionLink = String.format(FormSolutionsProperties.getInstance().getRedirectionFormat(), cacheID);
                    if (transid.startsWith("KFAS_KF600204")) {
                        redirectionLink = String.format(FormSolutionsProperties.getInstance().getRedirectionFormatLB(), cacheID);
                    }
                    CidsBean cacheIdBean = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)"fs_bestellung_cacheid", (ConnectionContext)this.getConnectionContext());
                    cacheIdBean.setProperty("cache_id", (Object)cacheID);
                    bestellungBean.getBeanCollectionProperty("n_cacheids").add(cacheIdBean);
                    this.getMetaService().updateMetaObject(this.getUser(), bestellungBean.getMetaObject(), this.getConnectionContext());
                    return redirectionLink;
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                return null;
            }
        }
        return null;
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum PARAMETER_TYPE {
        TRANSID_HASH;

    }
}

