/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.cids.utils.serverresources.JsonServerResource;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.commons.security.WebDavClient;
import de.cismet.commons.security.WebDavHelper;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.PasswordEncrypter;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class UploadTzbAction
implements ServerAction,
UserAwareServerAction {
    private static final Logger LOG = Logger.getLogger(UploadTzbAction.class);
    private static final String DOMAIN = "WUNDA_BLAU";
    private static final ConnectionContext CC = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.ACTION, (String)"UploadTzbAction");
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final String ACTION_QUERY = "select %1s, a.id from tzb_action a where key = '%2s'";
    private static final String TREE_QUERY = "select %1s, t.id from tzb_tree t where id = %2s";
    protected final Map<String, Object> paramsHashMap = new HashMap<String, Object>();
    private User usr = null;

    public User getUser() {
        return this.usr;
    }

    public void setUser(User user) {
        this.usr = user;
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        this.paramsHashMap.clear();
        for (ServerActionParameter param : params) {
            String key = param.getKey().toLowerCase();
            Object value = param.getValue();
            if (value instanceof String || value == null) {
                String singleValue = (String)value;
                this.paramsHashMap.put(key, singleValue);
                continue;
            }
            if (!(value instanceof Object)) continue;
            this.paramsHashMap.put(key, value);
        }
        try {
            CidsBean actionBean = CidsBean.createNewCidsBeanFromTableName((String)DOMAIN, (String)"tzb_tree_action", (ConnectionContext)CC);
            Object actionTimeAsObject = this.paramsHashMap.get(ParameterType.action_time.toString());
            Object createdTimeAsObject = this.paramsHashMap.get(ParameterType.created_at.toString());
            Object actionAsObject = this.paramsHashMap.get(ParameterType.key.toString());
            Object treeAsObject = this.paramsHashMap.get(ParameterType.fk_tree.toString());
            Timestamp actionTime = null;
            Timestamp createdTime = null;
            if (createdTimeAsObject instanceof String) {
                createdTime = new Timestamp(sdf.parse((String)createdTimeAsObject).getTime());
            }
            if (actionTimeAsObject instanceof String) {
                actionTime = new Timestamp(sdf.parse((String)actionTimeAsObject).getTime());
            }
            CidsBean fkActionBean = null;
            CidsBean fkTreeBean = null;
            if (actionAsObject instanceof String) {
                MetaClass mcTzbAction = DomainServerImpl.getServerInstance().getClassByTableName(this.getUser(), "tzb_action", CC);
                MetaObject[] actions = DomainServerImpl.getServerInstance().getMetaObject(this.getUser(), String.format(ACTION_QUERY, mcTzbAction.getID(), actionAsObject), CC);
                if (actions != null && actions.length == 1) {
                    fkActionBean = actions[0].getBean();
                } else {
                    LOG.error((Object)("Cannot find action '" + actionAsObject + "'"));
                }
            }
            if (treeAsObject instanceof String) {
                MetaClass mcTzbTree = DomainServerImpl.getServerInstance().getClassByTableName(this.getUser(), "tzb_tree", CC);
                MetaObject[] trees = DomainServerImpl.getServerInstance().getMetaObject(this.getUser(), String.format(TREE_QUERY, mcTzbTree.getID(), treeAsObject), CC);
                if (trees != null && trees.length == 1) {
                    fkTreeBean = trees[0].getBean();
                } else {
                    LOG.error((Object)("Cannot find action '" + treeAsObject + "'"));
                }
            }
            actionBean.setProperty(ParameterType.action_time.toString(), (Object)actionTime);
            actionBean.setProperty(ParameterType.created_at.toString(), (Object)createdTime);
            actionBean.setProperty(ParameterType.status.toString(), this.paramsHashMap.get(ParameterType.status.toString()));
            actionBean.setProperty(ParameterType.status_reason.toString(), this.paramsHashMap.get(ParameterType.status_reason.toString()));
            actionBean.setProperty(ParameterType.fk_tree.toString(), fkTreeBean);
            actionBean.setProperty("fk_action", (Object)fkActionBean);
            Map payload = (Map)this.paramsHashMap.get(ParameterType.payload.toString());
            Object picture = payload.get("pic");
            if (picture instanceof String) {
                String imageData = (String)picture;
                if (imageData != null) {
                    try {
                        String documentUrl = UploadTzbAction.writeImage(imageData);
                        payload.put("pic", documentUrl);
                    }
                    catch (Exception ex) {
                        LOG.fatal((Object)ex, (Throwable)ex);
                    }
                }
                actionBean.setProperty(ParameterType.payload.toString(), (Object)new ObjectMapper().writeValueAsString((Object)payload));
            }
            MetaObject mo = DomainServerImpl.getServerInstance().insertMetaObject(this.getUser(), actionBean.getMetaObject(), CC);
            return mo.getBean().toJSONString(true);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot create tzb_tree_action cids bean", (Throwable)e);
            return "{\"error\":, \"" + e.getMessage() + "\"}";
        }
    }

    protected void addParam(String key, Object value) {
        this.paramsHashMap.put(key, value);
    }

    protected Object getParam(String key, Class clazz) {
        Collection values = this.getListParam(key, clazz);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.iterator().next();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Collection getListParam(String key, Class clazz) {
        ArrayList<java.util.Date> objects = new ArrayList<java.util.Date>();
        if (!this.paramsHashMap.containsKey(key.toLowerCase())) return objects;
        for (Object val : (List)this.paramsHashMap.get(key.toLowerCase())) {
            Object object = null;
            if (val instanceof String) {
                long timestamp;
                String value = (String)val;
                if (java.util.Date.class.equals((Object)clazz)) {
                    timestamp = Long.parseLong(value);
                    object = new java.util.Date(timestamp);
                } else if (Date.class.equals((Object)clazz)) {
                    timestamp = Long.parseLong(value);
                    object = new Date(timestamp);
                } else if (Timestamp.class.equals((Object)clazz)) {
                    timestamp = Long.parseLong(value);
                    object = new Timestamp(timestamp);
                } else if (Integer.class.equals((Object)clazz)) {
                    object = Integer.parseInt(value);
                } else if (Float.class.equals((Object)clazz)) {
                    object = Float.valueOf(Float.parseFloat(value));
                } else if (Long.class.equals((Object)clazz)) {
                    object = Long.parseLong(value);
                } else if (Double.class.equals((Object)clazz)) {
                    object = Double.parseDouble(value);
                } else if (Boolean.class.equals((Object)clazz)) {
                    if ("ja".equals(value.toLowerCase())) {
                        object = true;
                    } else {
                        if (!"nein".equals(value.toLowerCase())) throw new UnsupportedOperationException("wrong boolean value");
                        object = false;
                    }
                } else {
                    if (!String.class.equals((Object)clazz)) throw new UnsupportedOperationException("this class is not supported");
                    object = value;
                }
            } else if (val == null) {
                object = null;
            } else if (ArrayList.class.equals((Object)clazz)) {
                object = val;
            }
            objects.add((java.util.Date)object);
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeImage(String imageData) throws Exception {
        FileOutputStream fos = null;
        try {
            String ending = "jpg";
            UploadConfig config = (UploadConfig)ServerResourcesLoader.getInstance().loadJson((JsonServerResource)WundaBlauServerResources.TZB_WEBDAV.getValue(), UploadConfig.class);
            String webDavRoot = config.getUrl();
            String webDavPath = config.getPath().endsWith("/") ? config.getPath() : config.getPath() + "/";
            String webFileName = UploadTzbAction.createFileName("jpg");
            File tempFile = UploadTzbAction.uploadToWebDav(webDavRoot, config.getUser(), config.getPasswd(), imageData, null, webDavPath + webFileName, "jpg");
            if ("jpg".equals("jpg") || "jpg".equals("png")) {
                byte[] bytes = UploadTzbAction.createThumbnail(tempFile, "jpg");
                UploadTzbAction.uploadToWebDav(webDavRoot, config.getUser(), config.getPasswd(), imageData, bytes, webDavPath + webFileName + ".thumbnail." + "jpg", "jpg");
            }
            String string = webDavRoot + webDavPath + webFileName;
            return string;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                LOG.fatal((Object)ex, (Throwable)ex);
            }
        }
    }

    private static String createFileName(String ending) {
        Random rand = new Random();
        return "IMG-" + rand.nextInt() + "_" + System.currentTimeMillis() + "." + ending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File uploadToWebDav(String webDavRoot, String user, String passwd, String imageData, byte[] imageAsBytes, String webFileName, String ending) throws Exception {
        File tempFile = File.createTempFile("file", "." + ending);
        FileOutputStream fos = null;
        WebDavClient webDavClient = null;
        byte[] imageDataAsByteA = imageAsBytes;
        if (imageDataAsByteA == null) {
            imageDataAsByteA = UploadTzbAction.convertFileDataToBytes(imageData);
        }
        try {
            int httpStatusCode;
            fos = new FileOutputStream(tempFile);
            fos.write(imageDataAsByteA);
            fos.close();
            if (webDavClient == null) {
                String pass = passwd;
                if (pass != null && pass.startsWith(PasswordEncrypter.CRYPT_PREFIX)) {
                    pass = PasswordEncrypter.decryptString((String)passwd);
                }
                webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), user, pass);
            }
            if ((httpStatusCode = WebDavHelper.uploadFileToWebDAV((String)webFileName, (File)tempFile, (String)webDavRoot, webDavClient, null)) / 100 != 2) {
                throw new Exception("Cannot upload image. Status code = " + httpStatusCode);
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        return tempFile;
    }

    private static byte[] createThumbnail(File tempFile, String ending) throws Exception {
        BufferedImage img = ImageIO.read(tempFile);
        int height = ((Image)img).getHeight(null);
        int width = ((Image)img).getWidth(null);
        int longestSide = Math.max(width, height);
        double scale = 1.0;
        if (longestSide > 600) {
            scale = 600.0 / (double)longestSide;
        }
        BufferedImage imgThumb = new BufferedImage((int)((double)width * scale), (int)((double)height * scale), 1);
        imgThumb.createGraphics().drawImage(img.getScaledInstance((int)((double)width * scale), (int)((double)height * scale), 4), 0, 0, null);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)imgThumb, ending, os);
        return os.toByteArray();
    }

    private static byte[] convertFileDataToBytes(String imageData) {
        String base64String = imageData.indexOf("base64,") != -1 ? imageData.substring(imageData.indexOf("base64,") + "base64,".length()) : imageData;
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(base64String);
    }

    public String getTaskName() {
        return "uploadTzbTreeAction";
    }

    private static class UploadConfig {
        String url;
        String path;
        String user;
        String passwd;

        public String getUrl() {
            return this.url;
        }

        public String getPath() {
            return this.path;
        }

        public String getUser() {
            return this.user;
        }

        public String getPasswd() {
            return this.passwd;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPasswd(String passwd) {
            this.passwd = passwd;
        }
    }

    public static enum ParameterType {
        key,
        status,
        payload,
        created_at,
        action_time,
        description,
        status_reason,
        fk_tree,
        url;

    }
}

