/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class AlboFlaecheErhebungsnummerSearch
extends AbstractCidsServerSearch
implements ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(AlboFlaecheErhebungsnummerSearch.class);
    private static final String ERH_NR_QUERY = "SELECT cs_albo_create_erhebungsnummer(%1$s::geometry, %2$s, %3$s)";
    private static final String ERH_NR_QUERY_WITH_ID = "SELECT cs_albo_create_erhebungsnummer(%1$s::geometry, %2$s, %3$s, %4$s)";
    private final String geometryAsText;
    private final String flaechentyp;
    private final String prop;
    private int id = -1;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public AlboFlaecheErhebungsnummerSearch(String geometryAsText, String flaechentyp, String prop) {
        this.geometryAsText = geometryAsText;
        this.flaechentyp = flaechentyp;
        this.prop = prop;
    }

    public AlboFlaecheErhebungsnummerSearch(String geometryAsText, String flaechentyp, String prop, int id) {
        this.geometryAsText = geometryAsText;
        this.flaechentyp = flaechentyp;
        this.prop = prop;
        this.id = id;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (ms != null) {
            if (this.id < 0) {
                try {
                    ArrayList erhNr = ms.performCustomSearch(String.format(ERH_NR_QUERY, this.geometryAsText == null ? "null" : "'" + this.geometryAsText + "'", this.flaechentyp == null ? "null" : "'" + this.flaechentyp + "'", this.prop == null ? "null" : "'" + this.prop + "'"), this.getConnectionContext());
                    return erhNr;
                }
                catch (RemoteException ex) {
                    LOG.error((Object)"Error while creating erhebungsnummer", (Throwable)ex);
                }
            } else {
                try {
                    ArrayList erhNr = ms.performCustomSearch(String.format(ERH_NR_QUERY_WITH_ID, this.geometryAsText == null ? "null" : "'" + this.geometryAsText + "'", this.flaechentyp == null ? "null" : "'" + this.flaechentyp + "'", this.prop == null ? "null" : "'" + this.prop + "'", this.id), this.getConnectionContext());
                    return erhNr;
                }
                catch (RemoteException ex) {
                    LOG.error((Object)"Error while creating erhebungsnummer", (Throwable)ex);
                }
            }
        }
        return null;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

