/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wunda_blau.search.server.AlboFlaecheLightweightSearch;
import de.cismet.cids.custom.wunda_blau.search.server.RestApiMonGeometrySearch;
import de.cismet.cids.custom.wunda_blau.search.server.SearchProperties;
import de.cismet.cids.custom.wunda_blau.search.server.StorableSearch;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class AlboFlaecheSearch
extends RestApiMonGeometrySearch
implements StorableSearch<Configuration> {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final transient Logger LOG;
    private static final String QUERY_TEMPLATE = "SELECT DISTINCT ON (flaeche.erhebungsnummer) (SELECT c.id FROM cs_class c WHERE table_name ILIKE 'albo_flaeche') AS class_id, flaeche.id AS object_id, flaeche.erhebungsnummer || ' [' || art.schluessel || ']' AS name FROM albo_flaeche AS flaeche LEFT JOIN albo_flaechenart AS art ON flaeche.fk_art = art.id LEFT JOIN geom AS geom ON flaeche.fk_geom = geom.id %s WHERE %s ORDER BY flaeche.erhebungsnummer";
    private static final String QUERY_VORGANG_TEMPLATE = "SELECT DISTINCT (SELECT c.id FROM cs_class c WHERE table_name ILIKE 'albo_vorgang') AS class_id, vorgang.id AS object_id, vorgang.schluessel AS name FROM albo_vorgang AS vorgang join albo_vorgang_flaeche AS arr ON (vorgang.arr_flaechen = arr.vorgang_reference) WHERE arr.fk_flaeche in (%s) ORDER BY name";
    private static final String QUERY_VORGANG_TEMPLATE_WITH_NR = "SELECT DISTINCT (SELECT c.id FROM cs_class c WHERE table_name ILIKE 'albo_vorgang') AS class_id, vorgang.id AS object_id, vorgang.schluessel AS name FROM albo_vorgang AS vorgang left join albo_vorgang_flaeche AS arr ON (vorgang.arr_flaechen = arr.vorgang_reference) WHERE arr.fk_flaeche in (%s) or vorgang.schluessel LIKE '%%%s%%'ORDER BY name";
    private static final String QUERY_VORGANG_TEMPLATE_WITHOUT_FL_WITH_NR = "SELECT DISTINCT (SELECT c.id FROM cs_class c WHERE table_name ILIKE 'albo_vorgang') AS class_id, vorgang.id AS object_id, vorgang.schluessel AS name FROM albo_vorgang AS vorgang WHERE vorgang.schluessel LIKE '%%%s%%'ORDER BY name";
    private static final String QUERY_BETRIEB = "(SELECT count(*) from albo_standort where albo_standort.fk_flaeche = flaeche.id)";
    private static final String QUERY_WZ = "(SELECT count(*) from albo_standort join albo_standort_wirtschaftszweig  on (albo_standort_wirtschaftszweig.standort_reference = albo_standort.arr_wirtschaftszweige) join albo_wirtschaftszweig on (albo_wirtschaftszweig.id = albo_standort_wirtschaftszweig.fk_wirtschaftszweig) where albo_standort.fk_flaeche = flaeche.id)";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private Configuration configuration;
    private Geometry geometry;
    private boolean withAlboVorgang = false;

    public AlboFlaecheSearch() {
        this(new Configuration());
    }

    public AlboFlaecheSearch(Configuration searchInfo) {
        this.configuration = searchInfo;
    }

    protected AlboFlaecheSearch(boolean withAlboVorgang) {
        this(new Configuration());
        this.withAlboVorgang = withAlboVorgang;
    }

    @Override
    public void setConfiguration(String configurationJson) throws Exception {
        this.setConfiguration((Configuration)this.getConfigurationMapper().readValue(configurationJson, Configuration.class));
    }

    @Override
    public String getName() {
        return "albo_flaeche";
    }

    @Override
    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    @Override
    public ObjectMapper getConfigurationMapper() {
        return OBJECT_MAPPER;
    }

    public AlboFlaecheLightweightSearch getLightweightSearch() {
        return new AlboFlaecheLightweightSearch(this);
    }

    @Override
    public void setConfiguration(Configuration searchConfiguration) {
        this.configuration = searchConfiguration;
    }

    @Override
    public void setConfiguration(Object searchConfiguration) {
        this.configuration = searchConfiguration instanceof Configuration ? (Configuration)searchConfiguration : null;
    }

    @Override
    public String createQuery() {
        Configuration configuration = this.getConfiguration();
        if (configuration != null) {
            String buffer = SearchProperties.getInstance().getIntersectsBuffer();
            ArrayList<String> leftJoins = new ArrayList<String>();
            ArrayList<String> wheres = new ArrayList<String>();
            ArrayList<String> wheresMain = new ArrayList<String>();
            ArrayList<String> wheresArt = new ArrayList<String>();
            leftJoins.add("albo_vorgang_flaeche AS arr ON flaeche.id = arr.fk_flaeche");
            if (configuration.getErhebungsNummer() != null && !configuration.getErhebungsNummer().isEmpty()) {
                wheresMain.add(String.format("flaeche.erhebungsnummer ILIKE '%%%s%%'", configuration.getErhebungsNummer()));
            }
            if (configuration.getFisAlboNr() != null && !configuration.getFisAlboNr().isEmpty()) {
                wheresMain.add(String.format("flaeche.geodaten_id LIKE '%%%s%%'", configuration.getFisAlboNr()));
            }
            if (configuration.getVorgangSchluessel() != null && !configuration.getVorgangSchluessel().isEmpty()) {
                leftJoins.add("albo_vorgang AS vorgang ON vorgang.arr_flaechen = arr.vorgang_reference");
                wheresMain.add(String.format("vorgang.schluessel LIKE '%%%s%%'", configuration.getVorgangSchluessel()));
            }
            if (configuration.getStatusSchluessel() != null && !configuration.getStatusSchluessel().isEmpty()) {
                leftJoins.add("albo_flaechenstatus AS status ON status.id = flaeche.fk_status");
                wheresMain.add(String.format("status.schluessel LIKE '%s'", configuration.getStatusSchluessel()));
            }
            if (configuration.getTypSchluessel() != null && !configuration.getTypSchluessel().isEmpty()) {
                leftJoins.add("albo_flaechentyp AS typ ON typ.id = flaeche.fk_typ");
                wheresMain.add(String.format("typ.schluessel LIKE '%s'", configuration.getTypSchluessel()));
            }
            if (configuration.getZuordnungSchluessel() != null && !configuration.getZuordnungSchluessel().isEmpty()) {
                leftJoins.add("albo_flaechenzuordnung AS zuordnung ON zuordnung.id = flaeche.fk_zuordnung");
                wheresMain.add(String.format("zuordnung.schluessel LIKE '%s'", configuration.getZuordnungSchluessel()));
            }
            if (configuration.getUnterdrueckt() != null) {
                wheresMain.add(String.format("flaeche.loeschen = %s", configuration.getUnterdrueckt() != false ? "TRUE" : "FALSE"));
            }
            if (configuration.getSmaller() != null && configuration.getSmaller() > 0.0) {
                wheresMain.add(String.format("st_area(geom.geo_field) < %s", configuration.getSmaller()));
            }
            if (configuration.getGreater() != null && configuration.getGreater() > 0.0) {
                wheresMain.add(String.format("st_area(geom.geo_field) > %s", configuration.getGreater()));
            }
            if (configuration.getBetriebe() != null && configuration.getBetriebe() > 0) {
                if (configuration.getBetriebeModus() != null && configuration.getBetriebeModus() == 1) {
                    wheresMain.add(String.format("(SELECT count(*) from albo_standort where albo_standort.fk_flaeche = flaeche.id) > %s", configuration.getBetriebe()));
                } else if (configuration.getBetriebeModus() != null && configuration.getBetriebeModus() == 2) {
                    wheresMain.add(String.format("(SELECT count(*) from albo_standort where albo_standort.fk_flaeche = flaeche.id) < %s", configuration.getBetriebe()));
                } else {
                    wheresMain.add(String.format("(SELECT count(*) from albo_standort where albo_standort.fk_flaeche = flaeche.id) = %s", configuration.getBetriebe()));
                }
            }
            if (configuration.getArtInfos() != null) {
                int artCount = 0;
                for (ArtInfo artInfo : configuration.getArtInfos()) {
                    String artSchluessel = artInfo != null ? artInfo.getFlaechenartSchluessel() : null;
                    ArrayList<String> subAndWheres = new ArrayList<String>();
                    if (artSchluessel != null) {
                        String art;
                        ArrayList<String> subLeftJoins;
                        String alias = String.format("%03d", artCount++);
                        leftJoins.add(String.format("albo_flaechenart AS art%1$s ON art%1$s.id = flaeche.fk_art", alias));
                        subAndWheres.add(String.format("art%s.schluessel LIKE '%s'", alias, artSchluessel));
                        if (artInfo instanceof StandortInfo) {
                            subLeftJoins = new ArrayList<String>();
                            String wirtschaftszweig = ((StandortInfo)artInfo).getWzSchluessel();
                            Integer jahr = ((StandortInfo)artInfo).getJahr();
                            Boolean jahrModus = ((StandortInfo)artInfo).getJahrModus();
                            Integer dauer = ((StandortInfo)artInfo).getDauer();
                            Boolean dauerModus = ((StandortInfo)artInfo).getDauerModus();
                            Integer betriebe = ((StandortInfo)artInfo).getBetriebe();
                            Integer betriebeModus = ((StandortInfo)artInfo).getBetriebeModus();
                            Integer wz = ((StandortInfo)artInfo).getWz();
                            Integer wzModus = ((StandortInfo)artInfo).getWzModus();
                            if (wirtschaftszweig != null) {
                                subLeftJoins.add(String.format("albo_standort_wirtschaftszweig AS stwz%1$s ON stwz%1$s.standort_reference = standort%1$s.id", alias));
                                subLeftJoins.add(String.format("albo_wirtschaftszweig AS wz%1$s ON stwz%1$s.fk_wirtschaftszweig = wz%1$s.id", alias));
                                subAndWheres.add(String.format("wz%s.schluessel LIKE '%s'", alias, wirtschaftszweig));
                            }
                            if (jahr != null) {
                                if (jahrModus == null) {
                                    subAndWheres.add(String.format("CASE WHEN standort%1$s.jahr_von IS NOT NULL THEN standort%1$s.jahr_von <= %2$d ELSE TRUE END AND CASE WHEN standort%1$s.jahr_bis IS NOT NULL THEN standort%1$s.jahr_bis >= %2$d ELSE TRUE END", alias, jahr));
                                } else if (Boolean.TRUE.equals(jahrModus)) {
                                    subAndWheres.add(String.format("CASE WHEN standort%1$s.jahr_bis IS NOT NULL THEN standort%1$s.jahr_bis > %2$d ELSE TRUE END", alias, jahr));
                                } else {
                                    subAndWheres.add(String.format("CASE WHEN standort%1$s.jahr_von IS NOT NULL THEN standort%1$s.jahr_von < %2$d ELSE TRUE END", alias, jahr));
                                }
                            }
                            if (dauer != null) {
                                if (dauerModus == null) {
                                    subAndWheres.add(String.format("CASE WHEN standort%1$s.jahr_von IS NOT NULL AND standort%1$s.jahr_bis IS NOT NULL THEN standort%1$s.jahr_bis - standort%1$s.jahr_von = %2$d ELSE FALSE END", alias, dauer));
                                } else if (Boolean.TRUE.equals(dauerModus)) {
                                    subAndWheres.add(String.format("CASE WHEN standort%1$s.jahr_von IS NOT NULL AND standort%1$s.jahr_bis IS NOT NULL THEN standort%1$s.jahr_bis - standort%1$s.jahr_von >= %2$d ELSE FALSE END", alias, dauer));
                                } else {
                                    subAndWheres.add(String.format("CASE WHEN standort%1$s.jahr_von IS NOT NULL AND standort%1$s.jahr_bis IS NOT NULL THEN standort%1$s.jahr_bis - standort%1$s.jahr_von < %2$d ELSE FALSE END", alias, dauer));
                                }
                            }
                            if (betriebe != null && betriebe > 0 && betriebeModus != null) {
                                if (betriebeModus == 1) {
                                    subAndWheres.add(String.format("(SELECT count(*) from albo_standort where albo_standort.fk_flaeche = flaeche.id) > %s", betriebe));
                                } else if (betriebeModus == 2) {
                                    subAndWheres.add(String.format("(SELECT count(*) from albo_standort where albo_standort.fk_flaeche = flaeche.id) < %s", betriebe));
                                } else {
                                    subAndWheres.add(String.format("(SELECT count(*) from albo_standort where albo_standort.fk_flaeche = flaeche.id) = %s", betriebe));
                                }
                            }
                            if (wz != null && wz > 0 && wzModus != null) {
                                if (wzModus == 1) {
                                    subAndWheres.add(String.format("(SELECT count(*) from albo_standort join albo_standort_wirtschaftszweig  on (albo_standort_wirtschaftszweig.standort_reference = albo_standort.arr_wirtschaftszweige) join albo_wirtschaftszweig on (albo_wirtschaftszweig.id = albo_standort_wirtschaftszweig.fk_wirtschaftszweig) where albo_standort.fk_flaeche = flaeche.id) > %s", wz));
                                } else if (wzModus == 2) {
                                    subAndWheres.add(String.format("(SELECT count(*) from albo_standort join albo_standort_wirtschaftszweig  on (albo_standort_wirtschaftszweig.standort_reference = albo_standort.arr_wirtschaftszweige) join albo_wirtschaftszweig on (albo_wirtschaftszweig.id = albo_standort_wirtschaftszweig.fk_wirtschaftszweig) where albo_standort.fk_flaeche = flaeche.id) < %s", wz));
                                } else {
                                    subAndWheres.add(String.format("(SELECT count(*) from albo_standort join albo_standort_wirtschaftszweig  on (albo_standort_wirtschaftszweig.standort_reference = albo_standort.arr_wirtschaftszweige) join albo_wirtschaftszweig on (albo_wirtschaftszweig.id = albo_standort_wirtschaftszweig.fk_wirtschaftszweig) where albo_standort.fk_flaeche = flaeche.id) = %s", wz));
                                }
                            }
                            if (!subAndWheres.isEmpty()) {
                                leftJoins.add(String.format("albo_standort AS standort%1$s ON standort%1$s.fk_flaeche = flaeche.id", alias));
                                leftJoins.addAll(subLeftJoins);
                            }
                        } else if (artInfo instanceof AltablagerungInfo) {
                            subLeftJoins = new ArrayList();
                            String stilllegung = ((AltablagerungInfo)artInfo).getStilllegungSchluessel();
                            String erhebungsklasse = ((AltablagerungInfo)artInfo).getErhebungsklasseSchluessel();
                            String verfuellkategorie = ((AltablagerungInfo)artInfo).getVerfuellkategorieSchluessel();
                            if (stilllegung != null) {
                                subLeftJoins.add(String.format("albo_stilllegung AS stilllegung%1$s ON altablagerung%1$s.fk_stilllegung = stilllegung%1$s.id", alias));
                                subAndWheres.add(String.format("stilllegung%s.schluessel LIKE '%s'", alias, stilllegung));
                            }
                            if (erhebungsklasse != null) {
                                subLeftJoins.add(String.format("albo_erhebungsklasse AS erhebungsklasse%1$s ON altablagerung%1$s.fk_erhebungsklasse = erhebungsklasse%1$s.id", alias));
                                subAndWheres.add(String.format("erhebungsklasse%s.schluessel LIKE '%s'", alias, erhebungsklasse));
                            }
                            if (verfuellkategorie != null) {
                                subLeftJoins.add(String.format("albo_verfuellkategorie AS verfuellkategorie%1$s ON altablagerung%1$s.fk_verfuellkategorie = verfuellkategorie%1$s.id", alias));
                                subAndWheres.add(String.format("verfuellkategorie%s.schluessel LIKE '%s'", alias, verfuellkategorie));
                            }
                            if (!subAndWheres.isEmpty()) {
                                leftJoins.add(String.format("albo_altablagerung AS altablagerung%1$s ON flaeche.fk_altablagerung = altablagerung%1$s.id", alias));
                                leftJoins.addAll(subLeftJoins);
                            }
                        } else if (artInfo instanceof RclInfo) {
                            subLeftJoins = new ArrayList();
                            art = ((RclInfo)artInfo).getArtSchluessel();
                            if (art != null) {
                                subLeftJoins.add(String.format("albo_rclart AS rclart%1$s ON rcl%1$s.fk_art = rclart%1$s.id", alias));
                                subAndWheres.add(String.format("rclart%s.schluessel LIKE '%s'", alias, art));
                            }
                            if (!subAndWheres.isEmpty()) {
                                leftJoins.add(String.format("albo_rcl AS rcl%1$s ON flaeche.fk_rcl = rcl%1$s.id", alias));
                                leftJoins.addAll(subLeftJoins);
                            }
                        } else if (artInfo instanceof StofflicheInfo) {
                            subLeftJoins = new ArrayList();
                            art = ((StofflicheInfo)artInfo).getArtSchluessel();
                            if (art != null) {
                                subLeftJoins.add(String.format("albo_stofflicheart AS stofflicheart%1$s ON stoffliche%1$s.fk_art = stofflicheart%1$s.id", alias));
                                subAndWheres.add(String.format("stofflicheart%s.schluessel LIKE '%s'", alias, art));
                            }
                            if (!subAndWheres.isEmpty()) {
                                leftJoins.add(String.format("albo_stoffliche AS stoffliche%1$s ON flaeche.fk_stoffliche = stoffliche%1$s.id", alias));
                                leftJoins.addAll(subLeftJoins);
                            }
                        }
                    }
                    if (subAndWheres.isEmpty()) continue;
                    wheresArt.add(String.format("(%s)", String.join((CharSequence)" AND ", subAndWheres)));
                }
            }
            if (this.getGeometry() != null) {
                String geomString = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)this.getGeometry());
                leftJoins.add("geom ON flaeche.fk_geom = geom.id");
                wheres.add(String.format("geom.geo_field && st_GeometryFromText('%s')", geomString));
                wheres.add(String.format("st_intersects(st_buffer(geo_field, %s), st_GeometryFromText('%s'))", buffer, geomString));
            }
            if (!wheresMain.isEmpty()) {
                switch (configuration.getSearchModeMain()) {
                    case AND: {
                        wheres.add(String.format("(%s)", String.join((CharSequence)" AND ", wheresMain)));
                        break;
                    }
                    case OR: {
                        wheres.add(String.format("(%s)", String.join((CharSequence)" OR ", wheresMain)));
                    }
                }
            }
            if (!wheresArt.isEmpty()) {
                switch (configuration.getSearchModeArt()) {
                    case AND: {
                        wheres.add(String.format("(%s)", String.join((CharSequence)" AND ", wheresArt)));
                        break;
                    }
                    case OR: {
                        wheres.add(String.format("(%s)", String.join((CharSequence)" OR ", wheresArt)));
                    }
                }
            }
            String leftJoin = !leftJoins.isEmpty() ? String.format("LEFT JOIN %s", String.join((CharSequence)" LEFT JOIN ", leftJoins)) : "";
            String where = !wheres.isEmpty() ? String.join((CharSequence)" AND ", wheres) : "TRUE";
            String query = String.format(QUERY_TEMPLATE, leftJoin, where);
            return query;
        }
        return null;
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            MetaObjectNode mon;
            String name;
            int oid;
            int cid;
            String query = this.createQuery();
            ArrayList<MetaObjectNode> mons = new ArrayList<MetaObjectNode>();
            MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
            StringBuilder flaechenIds = new StringBuilder();
            ArrayList resultList = ms.performCustomSearch(query, this.getConnectionContext());
            for (ArrayList al : resultList) {
                cid = (Integer)al.get(0);
                oid = (Integer)al.get(1);
                name = String.valueOf(al.get(2));
                mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, name, null, null);
                if (flaechenIds.toString().equals("")) {
                    flaechenIds.append(oid);
                } else {
                    flaechenIds.append(",").append(oid);
                }
                mons.add(mon);
            }
            if (this.withAlboVorgang || this.configuration != null && this.configuration.vorgaenge != null) {
                if (this.configuration != null && this.configuration.vorgaenge != null && this.configuration.vorgaenge.booleanValue()) {
                    mons.clear();
                }
                if (!flaechenIds.toString().equals("") || this.configuration.getVorgangSchluessel() != null && !this.configuration.getVorgangSchluessel().isEmpty()) {
                    resultList = this.configuration.getVorgangSchluessel() != null && !this.configuration.getVorgangSchluessel().isEmpty() ? (flaechenIds.toString().equals("") ? ms.performCustomSearch(String.format(QUERY_VORGANG_TEMPLATE_WITHOUT_FL_WITH_NR, this.configuration.getVorgangSchluessel()), this.getConnectionContext()) : ms.performCustomSearch(String.format(QUERY_VORGANG_TEMPLATE_WITH_NR, flaechenIds.toString(), this.configuration.getVorgangSchluessel()), this.getConnectionContext())) : ms.performCustomSearch(String.format(QUERY_VORGANG_TEMPLATE, flaechenIds.toString()), this.getConnectionContext());
                    for (ArrayList al : resultList) {
                        cid = (Integer)al.get(0);
                        oid = (Integer)al.get(1);
                        name = String.valueOf(al.get(2));
                        mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, name, null, null);
                        mons.add(mon);
                    }
                }
            }
            return mons;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while searching for albo_flaeche", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Geometry getGeometry() {
        return this.geometry;
    }

    @Override
    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ArtInfo.class, (JsonDeserializer)new ArtInfoDeserializer());
        OBJECT_MAPPER.registerModule((Module)module);
        LOG = Logger.getLogger(AlboFlaecheSearch.class);
    }

    public static class ArtInfoDeserializer
    extends StdDeserializer<ArtInfo> {
        private final ObjectMapper defaultMapper = new ObjectMapper();

        public ArtInfoDeserializer() {
            super(ArtInfoDeserializer.class);
            this.defaultMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }

        public ArtInfo deserialize(JsonParser jp, DeserializationContext dc) throws IOException, JsonProcessingException {
            ObjectNode on = (ObjectNode)jp.readValueAsTree();
            if (on.has("flaechenartSchluessel")) {
                String flaechenartSchluessel;
                switch (flaechenartSchluessel = (String)this.defaultMapper.treeToValue((TreeNode)on.get("flaechenartSchluessel"), String.class)) {
                    case "betriebsstandort": {
                        return (ArtInfo)this.defaultMapper.treeToValue((TreeNode)on, StandortInfo.class);
                    }
                    case "altstandort": {
                        return (ArtInfo)this.defaultMapper.treeToValue((TreeNode)on, StandortInfo.class);
                    }
                    case "altablagerung": {
                        return (ArtInfo)this.defaultMapper.treeToValue((TreeNode)on, AltablagerungInfo.class);
                    }
                    case "rcl": {
                        return (ArtInfo)this.defaultMapper.treeToValue((TreeNode)on, RclInfo.class);
                    }
                    case "stoffliche": {
                        return (ArtInfo)this.defaultMapper.treeToValue((TreeNode)on, StofflicheInfo.class);
                    }
                }
                return (ArtInfo)this.defaultMapper.treeToValue((TreeNode)on, ArtInfo.class);
            }
            throw new RuntimeException("missing ArtInfo");
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class AltablagerungInfo
    extends ArtInfo {
        @JsonProperty
        private String stilllegungSchluessel;
        @JsonProperty
        private String verfuellkategorieSchluessel;
        @JsonProperty
        private String erhebungsklasseSchluessel;

        public AltablagerungInfo() {
            super("altablagerung");
        }

        public String getStilllegungSchluessel() {
            return this.stilllegungSchluessel;
        }

        public String getVerfuellkategorieSchluessel() {
            return this.verfuellkategorieSchluessel;
        }

        public String getErhebungsklasseSchluessel() {
            return this.erhebungsklasseSchluessel;
        }

        public void setStilllegungSchluessel(String stilllegungSchluessel) {
            this.stilllegungSchluessel = stilllegungSchluessel;
        }

        public void setVerfuellkategorieSchluessel(String verfuellkategorieSchluessel) {
            this.verfuellkategorieSchluessel = verfuellkategorieSchluessel;
        }

        public void setErhebungsklasseSchluessel(String erhebungsklasseSchluessel) {
            this.erhebungsklasseSchluessel = erhebungsklasseSchluessel;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class RclInfo
    extends ArtInfo {
        @JsonProperty
        private String artSchluessel;

        public RclInfo() {
            this(null);
        }

        public RclInfo(String artSchluessel) {
            super("rcl");
            this.artSchluessel = artSchluessel;
        }

        public String getArtSchluessel() {
            return this.artSchluessel;
        }

        public void setArtSchluessel(String artSchluessel) {
            this.artSchluessel = artSchluessel;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class StofflicheInfo
    extends ArtInfo {
        @JsonProperty
        private String artSchluessel;

        public StofflicheInfo() {
            this(null);
        }

        public StofflicheInfo(String artSchluessel) {
            super("stoffliche");
            this.artSchluessel = artSchluessel;
        }

        public String getArtSchluessel() {
            return this.artSchluessel;
        }

        public void setArtSchluessel(String artSchluessel) {
            this.artSchluessel = artSchluessel;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class StandortInfo
    extends ArtInfo {
        @JsonProperty
        private String wzSchluessel;
        @JsonProperty
        private Integer jahr;
        @JsonProperty
        private Boolean jahrModus;
        @JsonProperty
        private Integer dauer;
        @JsonProperty
        private Boolean dauerModus;
        @JsonProperty
        private Integer betriebeModus;
        @JsonProperty
        private Integer betriebe;
        @JsonProperty
        private Integer wz;
        @JsonProperty
        private Integer wzModus;

        public StandortInfo() {
            this(null);
        }

        public StandortInfo(String artSchluessel) {
            super(artSchluessel);
        }

        public String getWzSchluessel() {
            return this.wzSchluessel;
        }

        public Integer getJahr() {
            return this.jahr;
        }

        public Boolean getJahrModus() {
            return this.jahrModus;
        }

        public Integer getDauer() {
            return this.dauer;
        }

        public Boolean getDauerModus() {
            return this.dauerModus;
        }

        public Integer getBetriebeModus() {
            return this.betriebeModus;
        }

        public Integer getBetriebe() {
            return this.betriebe;
        }

        public Integer getWz() {
            return this.wz;
        }

        public Integer getWzModus() {
            return this.wzModus;
        }

        public void setWzSchluessel(String wzSchluessel) {
            this.wzSchluessel = wzSchluessel;
        }

        public void setJahr(Integer jahr) {
            this.jahr = jahr;
        }

        public void setJahrModus(Boolean jahrModus) {
            this.jahrModus = jahrModus;
        }

        public void setDauer(Integer dauer) {
            this.dauer = dauer;
        }

        public void setDauerModus(Boolean dauerModus) {
            this.dauerModus = dauerModus;
        }

        public void setBetriebeModus(Integer betriebeModus) {
            this.betriebeModus = betriebeModus;
        }

        public void setBetriebe(Integer betriebe) {
            this.betriebe = betriebe;
        }

        public void setWz(Integer wz) {
            this.wz = wz;
        }

        public void setWzModus(Integer wzModus) {
            this.wzModus = wzModus;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class ArtInfo
    implements Serializable {
        @JsonProperty
        private final String flaechenartSchluessel;

        public ArtInfo() {
            this(null);
        }

        public ArtInfo(String flaechenartSchluessel) {
            this.flaechenartSchluessel = flaechenartSchluessel;
        }

        public String getFlaechenartSchluessel() {
            return this.flaechenartSchluessel;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class Configuration
    implements StorableSearch.Configuration {
        @JsonProperty
        private String vorgangSchluessel;
        @JsonProperty
        private String erhebungsNummer;
        @JsonProperty
        private String fisAlboNr;
        @JsonProperty
        private String statusSchluessel;
        @JsonProperty
        private String typSchluessel;
        @JsonProperty
        private String zuordnungSchluessel;
        @JsonProperty
        private Boolean unterdrueckt = Boolean.FALSE;
        @JsonProperty
        private Boolean vorgaenge = null;
        @JsonProperty
        private SearchMode searchModeMain = SearchMode.AND;
        @JsonProperty
        private SearchMode searchModeArt = SearchMode.AND;
        @JsonProperty
        private Collection<ArtInfo> artInfos;
        @JsonProperty
        private Double greater;
        @JsonProperty
        private Double smaller;
        @JsonProperty
        private Integer betriebe;
        @JsonProperty
        private Integer betriebeModus;

        public String getVorgangSchluessel() {
            return this.vorgangSchluessel;
        }

        public String getErhebungsNummer() {
            return this.erhebungsNummer;
        }

        public String getFisAlboNr() {
            return this.fisAlboNr;
        }

        public String getStatusSchluessel() {
            return this.statusSchluessel;
        }

        public String getTypSchluessel() {
            return this.typSchluessel;
        }

        public String getZuordnungSchluessel() {
            return this.zuordnungSchluessel;
        }

        public Boolean getUnterdrueckt() {
            return this.unterdrueckt;
        }

        public Boolean getVorgaenge() {
            return this.vorgaenge;
        }

        public SearchMode getSearchModeMain() {
            return this.searchModeMain;
        }

        public SearchMode getSearchModeArt() {
            return this.searchModeArt;
        }

        public Collection<ArtInfo> getArtInfos() {
            return this.artInfos;
        }

        public Double getGreater() {
            return this.greater;
        }

        public Double getSmaller() {
            return this.smaller;
        }

        public Integer getBetriebe() {
            return this.betriebe;
        }

        public Integer getBetriebeModus() {
            return this.betriebeModus;
        }

        public void setVorgangSchluessel(String vorgangSchluessel) {
            this.vorgangSchluessel = vorgangSchluessel;
        }

        public void setErhebungsNummer(String erhebungsNummer) {
            this.erhebungsNummer = erhebungsNummer;
        }

        public void setFisAlboNr(String fisAlboNr) {
            this.fisAlboNr = fisAlboNr;
        }

        public void setStatusSchluessel(String statusSchluessel) {
            this.statusSchluessel = statusSchluessel;
        }

        public void setTypSchluessel(String typSchluessel) {
            this.typSchluessel = typSchluessel;
        }

        public void setZuordnungSchluessel(String zuordnungSchluessel) {
            this.zuordnungSchluessel = zuordnungSchluessel;
        }

        public void setUnterdrueckt(Boolean unterdrueckt) {
            this.unterdrueckt = unterdrueckt;
        }

        public void setVorgaenge(Boolean vorgaenge) {
            this.vorgaenge = vorgaenge;
        }

        public void setSearchModeMain(SearchMode searchModeMain) {
            this.searchModeMain = searchModeMain;
        }

        public void setSearchModeArt(SearchMode searchModeArt) {
            this.searchModeArt = searchModeArt;
        }

        public void setArtInfos(Collection<ArtInfo> artInfos) {
            this.artInfos = artInfos;
        }

        public void setGreater(Double greater) {
            this.greater = greater;
        }

        public void setSmaller(Double smaller) {
            this.smaller = smaller;
        }

        public void setBetriebe(Integer betriebe) {
            this.betriebe = betriebe;
        }

        public void setBetriebeModus(Integer betriebeModus) {
            this.betriebeModus = betriebeModus;
        }
    }

    public static enum SearchMode {
        AND,
        OR;

    }
}

