/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class AlboVorgangSearch
extends AbstractCidsServerSearch
implements MetaObjectNodeServerSearch {
    private static final transient Logger LOG = Logger.getLogger(AlboVorgangSearch.class);
    private static final String QUERY_TEMPLATE = "SELECT (SELECT c.id FROM cs_class c WHERE table_name ILIKE 'albo_vorgang') AS class_id, albo_vorgang.id, albo_vorgang.schluessel AS name FROM albo_vorgang %s %s";
    private Integer flaecheId;
    private Boolean loeschen = Boolean.FALSE;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            ArrayList<String> leftJoins = new ArrayList<String>();
            ArrayList<String> wheres = new ArrayList<String>();
            if (this.getFlaecheId() != null) {
                leftJoins.add("albo_vorgang_flaeche ON albo_vorgang.arr_flaechen = albo_vorgang_flaeche.vorgang_reference");
                wheres.add(String.format("albo_vorgang_flaeche.fk_flaeche = %d", this.getFlaecheId()));
            }
            if (this.getLoeschen() != null) {
                wheres.add(String.format("albo_vorgang.loeschen = %s", this.getLoeschen() != false ? "TRUE" : "FALSE"));
            }
            String leftJoin = !leftJoins.isEmpty() ? String.format("LEFT JOIN %s", String.join((CharSequence)" LEFT JOIN ", leftJoins)) : "";
            String where = !wheres.isEmpty() ? String.format("WHERE %s", String.join((CharSequence)" AND ", wheres)) : "";
            String query = String.format(QUERY_TEMPLATE, leftJoin, where);
            MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
            ArrayList<MetaObjectNode> mons = new ArrayList<MetaObjectNode>();
            ArrayList resultList = ms.performCustomSearch(query, this.getConnectionContext());
            for (ArrayList al : resultList) {
                int cid = (Integer)al.get(0);
                int oid = (Integer)al.get(1);
                String name = String.valueOf(al.get(2));
                MetaObjectNode mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, name, null, null);
                mons.add(mon);
            }
            return mons;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while searching for albo_vorgang", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setFlaecheId(Integer flaecheId) {
        this.flaecheId = flaecheId;
    }

    public Integer getFlaecheId() {
        return this.flaecheId;
    }

    public void setLoeschen(Boolean loeschen) {
        this.loeschen = loeschen;
    }

    public Boolean getLoeschen() {
        return this.loeschen;
    }
}

