/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wunda_blau.search.server.RestApiMonGeometrySearch;
import de.cismet.cids.custom.wunda_blau.search.server.RestApiMonSearch;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class BplaeneMonSearch
extends RestApiMonGeometrySearch {
    private static final transient Logger LOG = Logger.getLogger(BplaeneMonSearch.class);
    private static final String DEFAULT_NAME_PROPERTY = "bplan_verfahren.nummer";
    private List<String> nameProperties = Arrays.asList("bplan_verfahren.nummer");
    private SubUnion[] subUnions;

    public BplaeneMonSearch(SubUnion ... subUnions) {
        this((Geometry)null, (Double)null, subUnions);
    }

    public BplaeneMonSearch(Double buffer) {
        this(null, buffer, new SubUnion[0]);
    }

    public BplaeneMonSearch(Geometry geometry, SubUnion ... subUnions) {
        this(geometry, (Double)null, subUnions);
    }

    public BplaeneMonSearch(Double buffer, SubUnion ... subUnions) {
        this(null, buffer, subUnions);
    }

    public BplaeneMonSearch(Geometry geometry, Double buffer, SubUnion ... subUnions) {
        this.setGeometry(geometry);
        this.setBuffer(buffer);
        this.setSubUnions(subUnions);
        this.setSearchInfo(new SearchInfo(this.getClass().getName(), this.getClass().getSimpleName(), "Builtin Legacy Search to delegate the operation Bplan to the cids Pure REST Search API.", Arrays.asList(new SearchParameterInfo[]{new RestApiMonSearch.MySearchParameterInfo("searchFor", Type.STRING), new RestApiMonSearch.MySearchParameterInfo("geom", Type.UNDEFINED)}), (SearchParameterInfo)new RestApiMonSearch.MySearchParameterInfo("return", Type.ENTITY_REFERENCE, true)));
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            String geomCondition = this.getGeomCondition();
            ArrayList<String> queries = new ArrayList<String>();
            if (this.getNameProperties() != null) {
                String query;
                SubUnion[] subUnions = this.getSubUnions();
                if (subUnions != null && subUnions.length != 0) {
                    for (SubUnion subUnion : subUnions) {
                        String whereClause;
                        if (subUnion == null) continue;
                        ArrayList<String> wheres = new ArrayList<String>();
                        if (geomCondition != null) {
                            wheres.add(geomCondition);
                        }
                        if ((whereClause = subUnion.getWhereClause()) != null) {
                            wheres.add(whereClause);
                        }
                        queries.add("SELECT DISTINCT \n  (SELECT id FROM cs_class WHERE table_name ILIKE 'bplan_verfahren') AS cid,   bplan_verfahren.id AS oid,   " + String.format("%s AS name", subUnion.getFieldProperty()) + ",   " + String.format("%s AS orderField ", subUnion.getOrderField() != null && !subUnion.getOrderField().trim().isEmpty() ? subUnion.getOrderField().trim() : "0") + "FROM bplan_verfahren " + (geomCondition != null ? subUnion.getGeomJoin() : "") + " " + (!wheres.isEmpty() ? "WHERE " + String.join((CharSequence)" AND ", wheres) : ""));
                    }
                    query = String.format("SELECT * FROM (%s) AS unioned ORDER BY orderField ASC;", String.join((CharSequence)" UNION ", queries));
                } else {
                    query = "SELECT DISTINCT \n  (SELECT id FROM cs_class WHERE table_name ILIKE 'bplan_verfahren') AS cid,   bplan_verfahren.id AS oid,   nummer FROM bplan_verfahren " + (geomCondition != null ? "LEFT JOIN geom ON geom.id = bplan_verfahren.geometrie " : " ") + (geomCondition != null ? "WHERE " + geomCondition : " ") + " ORDER BY nummer DESC";
                }
                MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
                ArrayList resultList = ms.performCustomSearch(query, this.getConnectionContext());
                for (ArrayList al : resultList) {
                    int cid = (Integer)al.get(0);
                    int oid = (Integer)al.get(1);
                    String name = (String)al.get(2);
                    result.add(new MetaObjectNode("WUNDA_BLAU", oid, cid, name, null, null));
                }
            }
            return result;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while searching for Bplan object", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public List<String> getNameProperties() {
        return this.nameProperties;
    }

    public void setNameProperties(List<String> nameProperties) {
        this.nameProperties = nameProperties;
    }

    public SubUnion[] getSubUnions() {
        return this.subUnions;
    }

    public void setSubUnions(SubUnion[] subUnions) {
        this.subUnions = subUnions;
    }

    public static class SubUnion
    implements Serializable {
        private String fieldProperty;
        private String geomJoin;
        private String whereClause;
        private String orderField;

        public String getFieldProperty() {
            return this.fieldProperty;
        }

        public String getGeomJoin() {
            return this.geomJoin;
        }

        public String getWhereClause() {
            return this.whereClause;
        }

        public String getOrderField() {
            return this.orderField;
        }

        public void setFieldProperty(String fieldProperty) {
            this.fieldProperty = fieldProperty;
        }

        public void setGeomJoin(String geomJoin) {
            this.geomJoin = geomJoin;
        }

        public void setWhereClause(String whereClause) {
            this.whereClause = whereClause;
        }

        public void setOrderField(String orderField) {
            this.orderField = orderField;
        }

        public SubUnion(String fieldProperty, String geomJoin, String whereClause, String orderField) {
            this.fieldProperty = fieldProperty;
            this.geomJoin = geomJoin;
            this.whereClause = whereClause;
            this.orderField = orderField;
        }
    }
}

