/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.wunda_blau.search.server.SearchProperties;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class CidsTreppenSearchStatement
extends AbstractCidsServerSearch
implements MetaObjectNodeServerSearch {
    private static final Logger LOG = Logger.getLogger(CidsTreppenSearchStatement.class);
    private static final String DOMAIN = "WUNDA_BLAU";
    private static final String INTERSECTS_BUFFER = SearchProperties.getInstance().getIntersectsBuffer();
    private final Boolean andConjuction;
    private final Geometry geom;
    private final HashMap<FilterKey, Object> filter;
    private final StringBuilder fromBuilder = new StringBuilder();
    private final StringBuilder whereBuilder = new StringBuilder();
    private final StringBuilder havingBuilder = new StringBuilder();

    public CidsTreppenSearchStatement(Geometry geom, SearchMode searchMode, HashMap<FilterKey, Object> filterProps) {
        this.geom = geom;
        this.filter = filterProps;
        this.andConjuction = searchMode == SearchMode.AND_SEARCH;
    }

    public Collection<MetaObjectNode> performServerSearch() throws SearchException {
        try {
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            MetaService metaService = (MetaService)this.getActiveLocalServers().get(DOMAIN);
            if (metaService == null) {
                LOG.error((Object)"Could not retrieve MetaService 'WUNDA_BLAU'.");
                return result;
            }
            if (this.geom == null && (this.filter == null || this.filter.isEmpty())) {
                LOG.warn((Object)"No filters provided. Cancel search.");
                return result;
            }
            String sqlStatement = this.generateSqlStatement();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Executing SQL statement '" + sqlStatement + "'."));
            }
            ArrayList resultset = metaService.performCustomSearch(sqlStatement);
            for (ArrayList treppe : resultset) {
                int classID = (Integer)treppe.get(0);
                int objectID = (Integer)treppe.get(1);
                String name = (String)treppe.get(2);
                MetaObjectNode node = new MetaObjectNode(DOMAIN, objectID, classID, name, null, null);
                result.add(node);
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)"Problem", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String generateSqlStatement() {
        Comparable<Date> bisValue;
        Comparable<Date> vonValue;
        this.fromBuilder.append("treppe");
        this.whereBuilder.append("TRUE");
        this.havingBuilder.append(this.andConjuction != false ? " TRUE " : " FALSE ");
        if (this.geom != null) {
            String geostring = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)this.geom);
            this.fromBuilder.append(" LEFT OUTER JOIN geom ON treppe.geometrie = geom.id");
            this.whereBuilder.append(" AND geom.geo_field && st_GeometryFromText('").append(geostring).append("') AND");
            if (this.geom instanceof Polygon || this.geom instanceof MultiPolygon) {
                this.whereBuilder.append(" st_intersects(st_buffer(geo_field, " + INTERSECTS_BUFFER + "),st_buffer(st_GeometryFromText('" + geostring + "'), " + INTERSECTS_BUFFER + "))");
            } else {
                this.whereBuilder.append(" and st_intersects(st_buffer(geo_field, " + INTERSECTS_BUFFER + "),st_GeometryFromText('" + geostring + "'))");
            }
        }
        if (this.filter.containsKey((Object)FilterKey.NAECHSTE_PRUEFUNG_VON) || this.filter.containsKey((Object)FilterKey.NAECHSTE_PRUEFUNG_BIS)) {
            vonValue = (Date)this.filter.get((Object)FilterKey.NAECHSTE_PRUEFUNG_VON);
            bisValue = (Date)this.filter.get((Object)FilterKey.NAECHSTE_PRUEFUNG_BIS);
            if (vonValue != null || bisValue != null) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                this.havingBuilder.append(this.andConjuction != false ? " AND " : " OR ").append(" (").append(vonValue != null ? "max(treppe.datum_naechste_pruefung) >= '" + df.format((Date)vonValue) + "'" : "TRUE").append(" AND ").append(bisValue != null ? "max(treppe.datum_naechste_pruefung)  <= '" + df.format((Date)bisValue) + "'" : "TRUE").append(" )");
            }
        }
        if (this.filter.containsKey((Object)FilterKey.ZUSTAND_TREPPENLAEUFE_VON) || this.filter.containsKey((Object)FilterKey.ZUSTAND_TREPPENLAEUFE_BIS)) {
            vonValue = (Double)this.filter.get((Object)FilterKey.ZUSTAND_TREPPENLAEUFE_VON);
            bisValue = (Double)this.filter.get((Object)FilterKey.ZUSTAND_TREPPENLAEUFE_BIS);
            if (vonValue != null || bisValue != null) {
                this.fromBuilder.append(" LEFT JOIN treppe_treppenlauf ON treppe_treppenlauf.treppe = treppe.id").append(" LEFT JOIN treppe_zustand AS zustand_treppenlauf ON treppe_treppenlauf.zustand = zustand_treppenlauf.id");
                this.havingBuilder.append(this.andConjuction != false ? " AND " : " OR ").append(" (").append(vonValue != null ? "max(zustand_treppenlauf.gesamt) >= " + vonValue : "TRUE").append(" AND ").append(bisValue != null ? "max(zustand_treppenlauf.gesamt) <= " + bisValue : "TRUE").append(" )");
            }
        }
        if (this.filter.containsKey((Object)FilterKey.ZUSTAND_PODESTE_VON) || this.filter.containsKey((Object)FilterKey.ZUSTAND_PODESTE_BIS)) {
            vonValue = (Double)this.filter.get((Object)FilterKey.ZUSTAND_PODESTE_VON);
            bisValue = (Double)this.filter.get((Object)FilterKey.ZUSTAND_PODESTE_BIS);
            if (vonValue != null || bisValue != null) {
                this.fromBuilder.append(" LEFT JOIN treppe_podest ON treppe_podest.treppe = treppe.id").append(" LEFT JOIN treppe_zustand AS zustand_podest ON treppe_podest.zustand = zustand_podest.id");
                this.havingBuilder.append(this.andConjuction != false ? " AND " : " OR ").append(" (").append(vonValue != null ? "max(zustand_podest.gesamt) >= " + vonValue : "TRUE").append(" AND ").append(bisValue != null ? "max(zustand_podest.gesamt) <= " + bisValue : "TRUE").append(" )");
            }
        }
        if (this.filter.containsKey((Object)FilterKey.ZUSTAND_LEITELEMENTE_VON) || this.filter.containsKey((Object)FilterKey.ZUSTAND_LEITELEMENTE_BIS)) {
            vonValue = (Double)this.filter.get((Object)FilterKey.ZUSTAND_LEITELEMENTE_VON);
            bisValue = (Double)this.filter.get((Object)FilterKey.ZUSTAND_LEITELEMENTE_BIS);
            if (vonValue != null || bisValue != null) {
                this.fromBuilder.append(" LEFT JOIN treppe_absturzsicherung ON treppe_absturzsicherung.treppe = treppe.id").append(" LEFT JOIN treppe_zustand AS zustand_leitelement ON treppe_absturzsicherung.zustand = zustand_leitelement.id");
                this.havingBuilder.append(this.andConjuction != false ? " AND " : " OR ").append(" (").append(vonValue != null ? "max(zustand_leitelement.gesamt) >= " + vonValue : "TRUE").append(" AND ").append(bisValue != null ? "max(zustand_leitelement.gesamt) <= " + bisValue : "TRUE").append(" )");
            }
        }
        if (this.filter.containsKey((Object)FilterKey.ZUSTAND_HANDLAEUFE_VON) || this.filter.containsKey((Object)FilterKey.ZUSTAND_HANDLAEUFE_BIS)) {
            vonValue = (Double)this.filter.get((Object)FilterKey.ZUSTAND_HANDLAEUFE_VON);
            bisValue = (Double)this.filter.get((Object)FilterKey.ZUSTAND_HANDLAEUFE_BIS);
            if (vonValue != null || bisValue != null) {
                this.fromBuilder.append(" LEFT JOIN treppe_handlauf ON treppe_handlauf.treppe = treppe.id").append(" LEFT JOIN treppe_zustand AS zustand_handlauf ON treppe_handlauf.zustand = zustand_handlauf.id");
                this.havingBuilder.append(this.andConjuction != false ? " AND " : " OR ").append(" (").append(vonValue != null ? "max(zustand_handlauf.gesamt) >= " + vonValue : "TRUE").append(" AND ").append(bisValue != null ? "max(zustand_handlauf.gesamt) <= " + bisValue : "TRUE").append(" )");
            }
        }
        if (this.filter.containsKey((Object)FilterKey.ZUSTAND_ENTWAESSERUNG_VON) || this.filter.containsKey((Object)FilterKey.ZUSTAND_ENTWAESSERUNG_BIS)) {
            vonValue = (Double)this.filter.get((Object)FilterKey.ZUSTAND_ENTWAESSERUNG_VON);
            bisValue = (Double)this.filter.get((Object)FilterKey.ZUSTAND_ENTWAESSERUNG_BIS);
            if (vonValue != null || bisValue != null) {
                this.fromBuilder.append(" LEFT JOIN treppe_entwaesserung ON treppe.entwaesserung = treppe_entwaesserung.id").append(" LEFT JOIN treppe_zustand AS zustand_entwaesserung ON treppe_entwaesserung.zustand = zustand_entwaesserung.id");
                this.havingBuilder.append(this.andConjuction != false ? " AND " : " OR ").append(" (").append(vonValue != null ? "max(zustand_entwaesserung.gesamt) >= " + vonValue : "TRUE").append(" AND ").append(bisValue != null ? "max(zustand_entwaesserung.gesamt) <= " + bisValue : "TRUE").append(" )");
            }
        }
        if (this.filter.containsKey((Object)FilterKey.ZUSTAND_STUETZMAUERN_VON) || this.filter.containsKey((Object)FilterKey.ZUSTAND_STUETZMAUERN_BIS)) {
            vonValue = (Double)this.filter.get((Object)FilterKey.ZUSTAND_STUETZMAUERN_VON);
            bisValue = (Double)this.filter.get((Object)FilterKey.ZUSTAND_STUETZMAUERN_BIS);
            if (vonValue != null || bisValue != null) {
                this.fromBuilder.append(" LEFT JOIN treppe_stuetzmauer ON treppe_stuetzmauer.treppe = treppe.id").append(" LEFT JOIN mauer ON treppe_stuetzmauer.mauer = mauer.id");
                this.havingBuilder.append(this.andConjuction != false ? " AND " : " OR ").append(" (").append(vonValue != null ? "max(mauer.zustand_gesamt) >= " + vonValue : "TRUE").append(" AND ").append(bisValue != null ? "max(mauer.zustand_gesamt) <= " + bisValue : "TRUE").append(" )");
            }
        }
        return "SELECT <selectClause> FROM <fromClause> WHERE <whereClause> GROUP BY treppe.id HAVING <havingClause>;".replace("<selectClause>", "(SELECT c.id FROM cs_class c WHERE table_name ilike 'treppe') AS class_id, treppe.id, max(treppe.name) AS name").replace("<fromClause>", this.fromBuilder.toString()).replace("<whereClause>", this.whereBuilder.toString()).replace("<havingClause>", this.havingBuilder.toString());
    }

    public static enum FilterKey {
        ZUSTAND_TREPPENLAEUFE_VON,
        ZUSTAND_TREPPENLAEUFE_BIS,
        ZUSTAND_LEITELEMENTE_VON,
        ZUSTAND_LEITELEMENTE_BIS,
        ZUSTAND_PODESTE_VON,
        ZUSTAND_PODESTE_BIS,
        ZUSTAND_HANDLAEUFE_VON,
        ZUSTAND_HANDLAEUFE_BIS,
        ZUSTAND_ENTWAESSERUNG_VON,
        ZUSTAND_ENTWAESSERUNG_BIS,
        ZUSTAND_STUETZMAUERN_VON,
        ZUSTAND_STUETZMAUERN_BIS,
        NAECHSTE_PRUEFUNG_VON,
        NAECHSTE_PRUEFUNG_BIS;

    }

    public static enum SearchMode {
        AND_SEARCH,
        OR_SEARCH;

    }
}

