/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.startuphooks;

import Sirius.server.middleware.interfaces.domainserver.DomainServerStartupHook;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import org.apache.log4j.Logger;

public class WundaServerResourcesStartupHook
implements DomainServerStartupHook {
    private static final Logger LOG = Logger.getLogger((String)WundaServerResourcesStartupHook.class.getName());

    public void domainServerStarted() {
        this.loadAllServerResources();
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }

    public void loadAllServerResources() {
        boolean error = false;
        for (WundaBlauServerResources wundaServerResources : WundaBlauServerResources.values()) {
            try {
                ServerResourcesLoader.getInstance().load(wundaServerResources.getValue());
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while loading resource from the resources base path.", (Throwable)ex);
                error = true;
            }
        }
        if (error) {
            LOG.error((Object)"!!! CAUTION !!! Not all server resources could be loaded !");
        }
    }
}

