/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.deletionprovider;

import Sirius.server.localserver.object.AbstractCustomDeletionProvider;
import Sirius.server.localserver.object.DeletionProviderClientException;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BaumHauptartDeletionProvider
extends AbstractCustomDeletionProvider {
    private static final Logger LOG = Logger.getLogger(BaumHauptartDeletionProvider.class);
    private static final String TABLE_NAME = "baum_hauptart";
    private static final String FIELD__ID = "id";
    private static final String FIELD__FK = "fk_hauptart";
    private static final String TABLE_NAME_SEARCH = "baum_art";
    private static final String DELETE_TEXT = "Diese Hauptart kann nicht gel\u00f6scht werden, da diese verwendet wird.";

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isMatching(User user, MetaObject metaObject) {
        if (!super.isMatching(user, metaObject)) {
            return false;
        }
        CidsBean hauptartBean = metaObject.getBean();
        Integer hauptart_id = (Integer)hauptartBean.getProperty(FIELD__ID);
        String queryHauptartInArt = String.format("SELECT * FROM %s WHERE %s = %d;", TABLE_NAME_SEARCH, FIELD__FK, hauptart_id);
        try {
            ArrayList hauptartArray = this.getMetaService().performCustomSearch(queryHauptartInArt, this.getConnectionContext());
            if (!hauptartArray.isEmpty()) {
                return true;
            }
        }
        catch (RemoteException ex) {
            LOG.error((Object)"Cannot delete hauptart object", (Throwable)ex);
        }
        return false;
    }

    public boolean customDeleteMetaObject(User user, MetaObject metaObject) throws Exception {
        throw new DeletionProviderClientException(DELETE_TEXT);
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

