/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.deletionprovider;

import Sirius.server.localserver.object.AbstractCustomDeletionProvider;
import Sirius.server.localserver.object.DeletionProviderClientException;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class TwMassnahmeDeletionProvider
extends AbstractCustomDeletionProvider {
    private static final Logger LOG = Logger.getLogger(TwMassnahmeDeletionProvider.class);
    private static final String TABLE_NAME = "tw_massnahmen";
    private static final String FIELD__ID = "id";
    private static final String FIELD__FK = "fk_massnahmen";
    private static final String TABLE_NAME_SEARCH = "tw_brunnen_massnahmen";
    private static final String ERROR_MESSAGE = "Der folgende Fehler ist aufgetreten: ";
    private static final String CAUSE = "Diese Massnahme kann nicht gel\u00f6scht werden, da diese bei mindestens einem Trinkwasserbrunnen verwendet wird.";
    private String deleteText = "Diese Massnahme kann nicht gel\u00f6scht werden, da diese verwendet wird.";

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isMatching(User user, MetaObject metaObject) {
        if (!super.isMatching(user, metaObject)) {
            return false;
        }
        CidsBean massBean = metaObject.getBean();
        Integer mass_id = massBean.getPrimaryKeyValue();
        String queryMassIn = String.format("SELECT * FROM %s WHERE %s = %d;", TABLE_NAME_SEARCH, FIELD__FK, mass_id);
        try {
            ArrayList massArray = this.getMetaService().performCustomSearch(queryMassIn, this.getConnectionContext());
            if (!massArray.isEmpty()) {
                this.deleteText = CAUSE;
                return true;
            }
        }
        catch (RemoteException ex) {
            LOG.error((Object)"Cannot delete Massnahme object", (Throwable)ex);
            this.deleteText = ERROR_MESSAGE + ex.getMessage();
            return true;
        }
        return false;
    }

    public boolean customDeleteMetaObject(User user, MetaObject metaObject) throws Exception {
        throw new DeletionProviderClientException(this.deleteText);
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

