/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.alkis;

import de.cismet.cids.custom.utils.StaticProperties;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.commons.security.handler.ExtendedAccessHandler;
import de.cismet.commons.security.handler.SimpleHttpAccessHandler;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class BaulastenPictureFinder {
    public static final String SEP = "/";
    static final Logger log = Logger.getLogger(BaulastenPictureFinder.class);
    private static final String[] SUFFIXE = new String[]{"tif", "jpg", "tiff", "jpeg"};
    private static final String LINKEXTENSION = "txt";
    public static final String SUFFIX_REDUCED_SIZE = "_rs";
    public static final String EXTENSION_REDUCED_SIZE = "jpg";
    private static final String DOWNLOAD_TEMPLATE = "<rasterfari:url>?REQUEST=GetMap&SERVICE=WMS&customDocumentInfo=download&LAYERS=<rasterfari:document>";
    private final ExtendedAccessHandler extendedAccessHandler;
    private final StaticProperties staticProperties;

    protected BaulastenPictureFinder(ExtendedAccessHandler extendedAccessHandler, StaticProperties staticProperties) {
        this.extendedAccessHandler = extendedAccessHandler;
        this.staticProperties = staticProperties;
    }

    private ExtendedAccessHandler getExtendedAccessHandler() {
        return this.extendedAccessHandler;
    }

    private StaticProperties getStaticProperties() {
        return this.staticProperties;
    }

    public List<String> findPlanPicture(CidsBean cidsBean, boolean checkReducedSize) {
        FileWithoutSuffix picturePath = this.getPlanPictureFilename(cidsBean);
        if (log.isDebugEnabled()) {
            log.debug((Object)("findPlanPicture: " + picturePath));
        }
        return this.probeWebserverForRightSuffix(picturePath, checkReducedSize);
    }

    public List<String> findPlanPicture(CidsBean cidsBean) {
        return this.findPlanPicture(cidsBean, false);
    }

    public List<String> findPlanPicture(String blattnummer, String laufendeNummer, boolean checkReducedSize) {
        FileWithoutSuffix picturePath = this.getPlanPictureFilename(blattnummer, laufendeNummer);
        if (log.isDebugEnabled()) {
            log.debug((Object)("findPlanPicture: " + picturePath.toString()));
        }
        return this.probeWebserverForRightSuffix(picturePath, checkReducedSize);
    }

    public List<String> findPlanPicture(String blattnummer, String laufendeNummer) {
        return this.findPlanPicture(blattnummer, laufendeNummer, false);
    }

    public List<String> findTextblattPicture(CidsBean cidsBean, boolean checkReducedSize) {
        FileWithoutSuffix picturePath = this.getTextblattPictureFilename(cidsBean);
        if (log.isDebugEnabled()) {
            log.debug((Object)("findTextblattPicture: " + picturePath.toString()));
        }
        return this.probeWebserverForRightSuffix(picturePath, checkReducedSize);
    }

    public List<String> findTextblattPicture(CidsBean cidsBean) {
        return this.findTextblattPicture(cidsBean, false);
    }

    public URL getUrlForDocument(String document) throws Exception {
        return new URL(DOWNLOAD_TEMPLATE.replace("<rasterfari:url>", this.getStaticProperties().getAlbBaulastUrlPrefix()).replace("<rasterfari:document>", document));
    }

    public List<String> findTextblattPicture(String blattnummer, String laufendeNummer, boolean checkReducedSize) {
        FileWithoutSuffix picturePath = this.getTextblattPictureFilename(blattnummer, laufendeNummer);
        if (log.isDebugEnabled()) {
            log.debug((Object)("findTextblattPicture: " + picturePath.toString()));
        }
        return this.probeWebserverForRightSuffix(picturePath, checkReducedSize);
    }

    public List<String> findTextblattPicture(String blattnummer, String laufendeNummer) {
        return this.findTextblattPicture(blattnummer, laufendeNummer, false);
    }

    public FileWithoutSuffix getTextblattPictureFilename(CidsBean cidsBean) {
        String picturePath = (String)cidsBean.getProperty("textblatt");
        String blattnummer = (String)cidsBean.getProperty("blattnummer");
        String laufendeNummer = (String)cidsBean.getProperty("laufende_nummer");
        if (picturePath != null) {
            return new FileWithoutSuffix(null, picturePath + ".");
        }
        FileWithoutSuffix ret = this.getObjectFilename(blattnummer, laufendeNummer);
        if (ret != null) {
            ret.file = ret.file + "b.";
        }
        return ret;
    }

    public FileWithoutSuffix getTextblattPictureFilename(String blattnummer, String laufendeNummer) {
        FileWithoutSuffix ret = this.getObjectFilename(blattnummer, laufendeNummer);
        if (ret != null) {
            ret.file = ret.file + "b.";
        }
        return ret;
    }

    public FileWithoutSuffix getObjectFilename(String blattnummer, String laufendeNummer) {
        if (laufendeNummer == null) {
            return null;
        }
        int lfdNr = new Integer(laufendeNummer);
        String trenner = "-";
        int number = 0;
        if (blattnummer.length() == 6) {
            number = new Integer(blattnummer);
        } else {
            number = new Integer(blattnummer.substring(0, 6));
            trenner = blattnummer.substring(6, 7);
        }
        String file = new StringBuffer(String.format("%06d", number)).append(trenner).append(String.format("%02d", lfdNr)).toString();
        return new FileWithoutSuffix(number, file);
    }

    public Set<URL> findAdditionalFiles(Collection<CidsBean> baulasten) throws Exception {
        HashSet<String> additionalFilesToDownload = new HashSet<String>();
        for (CidsBean baulast : baulasten) {
            List<String> documentListRasterdaten = this.findPlanPicture(baulast);
            additionalFilesToDownload.addAll(documentListRasterdaten);
        }
        HashSet<URL> urls = new HashSet<URL>();
        for (String additionalFileToDownload : additionalFilesToDownload) {
            urls.add(this.getUrlForDocument(additionalFileToDownload));
        }
        return urls;
    }

    public static int getBlattnummer(String blattnummer) {
        int number = 0;
        number = blattnummer.length() == 6 ? new Integer(blattnummer).intValue() : new Integer(blattnummer.substring(0, 6)).intValue();
        return number;
    }

    public static String getObjectFilenameWithoutFolder(String blattnummer, String laufendeNummer) {
        if (laufendeNummer == null) {
            return null;
        }
        int lfdNr = new Integer(laufendeNummer);
        String trenner = "-";
        int number = 0;
        if (blattnummer.length() == 6) {
            number = new Integer(blattnummer);
        } else {
            number = new Integer(blattnummer.substring(0, 6));
            trenner = blattnummer.substring(6, 7);
        }
        return new StringBuffer().append(String.format("%06d", number)).append(trenner).append(String.format("%02d", lfdNr)).toString();
    }

    private FileWithoutSuffix getObjectPath(String filename) {
        String numberS = filename.substring(0, 6);
        int number = new Integer(numberS);
        return new FileWithoutSuffix(number, filename + ".");
    }

    public FileWithoutSuffix getPlanPictureFilename(CidsBean cidsBean) {
        String picturePath = (String)cidsBean.getProperty("lageplan");
        String blattnummer = (String)cidsBean.getProperty("blattnummer");
        String laufendeNummer = (String)cidsBean.getProperty("laufende_nummer");
        if (picturePath != null) {
            return new FileWithoutSuffix(null, picturePath + ".");
        }
        FileWithoutSuffix ret = this.getObjectFilename(blattnummer, laufendeNummer);
        if (ret != null) {
            ret.file = ret.file + "p.";
        }
        return ret;
    }

    public FileWithoutSuffix getPlanPictureFilename(String blattnummer, String laufendeNummer) {
        FileWithoutSuffix ret = this.getObjectFilename(blattnummer, laufendeNummer);
        if (ret != null) {
            ret.file = ret.file + "p.";
        }
        return ret;
    }

    public static String getFolderWihoutPath(int number) {
        int modulo = number % 1000;
        if (modulo == 0) {
            modulo = 1000;
        }
        int lowerBorder = number - modulo;
        int higherBorder = lowerBorder + 1000;
        if (lowerBorder != 0) {
            ++lowerBorder;
        }
        String lb = String.format("%06d", lowerBorder);
        String hb = String.format("%06d", higherBorder);
        return new StringBuffer().append(lb).append("-").append(hb).toString();
    }

    private List<String> probeWebserverForRightSuffix(FileWithoutSuffix fileWithoutSuffix, boolean checkReducedSize) {
        return this.probeWebserverForRightSuffix(fileWithoutSuffix, 0, checkReducedSize);
    }

    public List<String> probeWebserverForRightSuffix(FileWithoutSuffix fileWithoutSuffix, int recursionDepth, boolean checkReducedSize) {
        String fileWithoutSuffixString = fileWithoutSuffix.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching for picture: " + fileWithoutSuffixString + "xxx"));
        }
        ArrayList<String> results = new ArrayList<String>();
        if (checkReducedSize) {
            int counter = 1;
            int picfound = 1;
            while (picfound != 0) {
                String fileWithSuffix = fileWithoutSuffixString.substring(0, fileWithoutSuffixString.lastIndexOf(".")) + SUFFIX_REDUCED_SIZE + String.format("%02d", counter) + "." + EXTENSION_REDUCED_SIZE;
                try {
                    URL objectURL = this.getUrlForDocument(fileWithSuffix);
                    picfound = this.getExtendedAccessHandler().checkIfURLaccessible(objectURL) ? 1 : 0;
                    if (picfound != 0) {
                        results.add(fileWithSuffix);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)("Problem occured, during checking for " + fileWithSuffix), (Throwable)ex);
                    picfound = 0;
                }
                ++counter;
            }
        } else {
            for (String suffix : SUFFIXE) {
                try {
                    String fileWithSuffix = fileWithoutSuffixString + suffix;
                    URL objectURL = this.getUrlForDocument(fileWithSuffix);
                    if (!this.getExtendedAccessHandler().checkIfURLaccessible(objectURL)) continue;
                    results.add(fileWithSuffix);
                }
                catch (Exception ex) {
                    log.error((Object)("Problem occured, during checking for " + fileWithoutSuffixString + suffix), (Throwable)ex);
                }
            }
        }
        if (results.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No picture file found. Check for Links");
            }
            if (recursionDepth < 3) {
                try {
                    URL objectURL = this.getUrlForDocument(fileWithoutSuffix + LINKEXTENSION);
                    if (this.getExtendedAccessHandler().checkIfURLaccessible(objectURL)) {
                        String link = IOUtils.toString((InputStream)this.getExtendedAccessHandler().doRequest(objectURL), (String)"UTF-8");
                        return this.probeWebserverForRightSuffix(this.getObjectPath(link.trim()), recursionDepth + 1, checkReducedSize);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)ex, (Throwable)ex);
                }
            } else {
                log.error((Object)"No hop,hop,hop possible within this logic. Seems to be an endless loop, sorry.", (Throwable)new Exception("JustTheStackTrace"));
            }
        }
        return results;
    }

    public static BaulastenPictureFinder getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public class FileWithoutSuffix {
        Integer number;
        String file;

        public FileWithoutSuffix(Integer number, String file) {
            this.number = number;
            this.file = file;
        }

        public String toString() {
            if (this.number == null) {
                return this.file.toUpperCase();
            }
            return this.getFolder(this.number) + BaulastenPictureFinder.SEP + this.file;
        }

        private String getFolder(int number) {
            int modulo = number % 1000;
            if (modulo == 0) {
                modulo = 1000;
            }
            int lowerBorder = number == 0 ? 0 : number - modulo;
            int higherBorder = lowerBorder + 1000;
            if (lowerBorder != 0) {
                ++lowerBorder;
            }
            String lb = String.format("%06d", lowerBorder);
            String hb = String.format("%06d", higherBorder);
            return new StringBuffer(BaulastenPictureFinder.this.getStaticProperties().getAlbBaulastDocumentPath()).append(BaulastenPictureFinder.SEP).append(lb).append("-").append(hb).toString();
        }
    }

    private static final class LazyInitialiser {
        private static final BaulastenPictureFinder INSTANCE;

        private LazyInitialiser() {
        }

        static {
            try {
                INSTANCE = new BaulastenPictureFinder((ExtendedAccessHandler)new SimpleHttpAccessHandler(), StaticProperties.getInstance());
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception while initializing BaulastenPictureFinder", ex);
            }
        }
    }
}

