/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.alkis;

import de.cismet.cids.custom.utils.alkis.ServerAlkisConf;
import de.cismet.cids.custom.utils.alkis.ServerAlkisProducts;
import de.cismet.commons.security.handler.SimpleHttpAccessHandler;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import org.apache.log4j.Logger;

public class NivellementPunktReportScriptlet
extends JRDefaultScriptlet {
    protected static final Logger LOG = Logger.getLogger(NivellementPunktReportScriptlet.class);
    private static final transient SimpleHttpAccessHandler EXTENDED_ACCESS_HANDLER = new SimpleHttpAccessHandler();

    public Boolean isImageAvailable(String dgkBlattnummer, String laufendeNummer) {
        Collection<String> validDocuments = ServerAlkisProducts.getInstance().getCorrespondingNivPURLs(dgkBlattnummer, laufendeNummer);
        for (String document : validDocuments) {
            try {
                URL url = ServerAlkisConf.getInstance().getDownloadUrlForDocument(document);
                if (!EXTENDED_ACCESS_HANDLER.checkIfURLaccessible(url)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image loadImage(String dgkBlattnummer, String laufendeNummer) {
        Collection<String> validDocuments = ServerAlkisProducts.getInstance().getCorrespondingNivPURLs(dgkBlattnummer, laufendeNummer);
        InputStream streamToReadFrom = null;
        for (String document : validDocuments) {
            try {
                URL url = ServerAlkisConf.getInstance().getDownloadUrlForDocument(document);
                if (!EXTENDED_ACCESS_HANDLER.checkIfURLaccessible(url) || (streamToReadFrom = EXTENDED_ACCESS_HANDLER.doRequest(url)) == null) continue;
                break;
            }
            catch (Exception ex) {
                LOG.warn((Object)("An exception occurred while opening URL for '" + document + "'. Skipping this url."), (Throwable)ex);
            }
        }
        BufferedImage result = null;
        if (streamToReadFrom == null) {
            LOG.error((Object)"Couldn't get a connection to associated document.");
            return result;
        }
        try {
            result = ImageIO.read(streamToReadFrom);
        }
        catch (IOException ex) {
            LOG.warn((Object)"Could not read image.", (Throwable)ex);
            BufferedImage bufferedImage = result;
            return bufferedImage;
        }
        finally {
            try {
                streamToReadFrom.close();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Couldn't close the stream.", (Throwable)ex);
            }
        }
        return result;
    }
}

