/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.billing;

import de.cismet.cids.custom.utils.billing.BillingProduct;
import java.io.Serializable;

public class BillingPrice
implements Serializable {
    private final double raw;
    private final String usage;
    private final BillingProduct product;

    private double getDiscountFrom1() {
        return this.product.getDiscounts().get(this.usage);
    }

    public double getDiscountAbsolute() {
        return (1.0 - this.getDiscountFrom1()) * this.raw;
    }

    public double getDiscountPercentage() {
        return Math.round((1.0 - this.getDiscountFrom1()) * 100.0);
    }

    public double getNetto() {
        return this.raw * this.getDiscountFrom1();
    }

    public double getMwst() {
        return this.getNetto() * (this.product.getMwst() / 100.0);
    }

    public double getBrutto() {
        return (double)Math.round((this.getNetto() + this.getMwst()) * 100.0) / 100.0;
    }

    public double getRaw() {
        return this.raw;
    }

    public String getUsage() {
        return this.usage;
    }

    public BillingProduct getProduct() {
        return this.product;
    }

    public BillingPrice(double raw, String usage, BillingProduct product) {
        this.raw = raw;
        this.usage = usage;
        this.product = product;
    }
}

