/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.stadtbilder;

import de.cismet.cids.custom.wunda_blau.search.server.MetaObjectNodesStadtbildSerieSearchStatement;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class StadtbilderConf {
    private static final Logger LOG = Logger.getLogger(StadtbilderConf.class);
    public static final String YEAR = "{year}";
    public static final String IMAGE_NUMBER = "{imageNumber}";
    public static final String FILE_ENDING = "{fileEnding}";
    public static final String DIRECTION = "{direction}";
    public static final String FIRST_CHARACTER = "{firstCharacter}";
    private static final Integer DEFAULT_CACHE_SIZE = 100;
    private final String previewUrlBase;
    private final String highresUrlBase;
    private final String defaultHighresLocationTemplate;
    private final String defaultPreviewLocationTemplate;
    private final String reihenschraegHighresLocationTemplate;
    private final String reihenschraegPreviewLocationTemplate;
    private final String arcLocationTemplate;
    private final String[] fileFormats;
    private final Integer cacheSize;
    private final String tifferAnnotation;

    protected StadtbilderConf(Properties serviceProperties) {
        this.previewUrlBase = serviceProperties.getProperty("PREVIEW_URL_BASE");
        this.highresUrlBase = serviceProperties.getProperty("HIGHRES_URL_BASE");
        this.defaultHighresLocationTemplate = serviceProperties.getProperty("DEFAULT_HIGHRES_LOCATION_TEMPLATE");
        this.defaultPreviewLocationTemplate = serviceProperties.getProperty("DEFAULT_PREVIEW_LOCATION_TEMPLATE");
        this.reihenschraegHighresLocationTemplate = serviceProperties.getProperty("REIHENSCHRAEG_HIGHRES_LOCATION_TEMPLATE");
        this.reihenschraegPreviewLocationTemplate = serviceProperties.getProperty("REIHENSCHRAEG_PREVIEW_LOCATION_TEMPLATE");
        this.arcLocationTemplate = serviceProperties.getProperty("ARC_LOCATION_TEMPLATE");
        this.fileFormats = serviceProperties.getProperty("FILE_FORMATS") != null ? serviceProperties.getProperty("FILE_FORMATS").split(",") : new String[]{};
        this.cacheSize = serviceProperties.getProperty("CACHE_SIZE") != null ? Integer.valueOf(serviceProperties.getProperty("CACHE_SIZE")) : DEFAULT_CACHE_SIZE;
        this.tifferAnnotation = serviceProperties.getProperty("TIFFER_ANNOTATION");
    }

    public URL[] getPreviewPictureUrls(String imageNumber, Integer bildtypId, Integer jahr, String blickrichtung, String format) {
        String locationOfImage = MetaObjectNodesStadtbildSerieSearchStatement.Bildtyp.REIHENSCHRAEG.getId() == bildtypId.intValue() ? this.getReihenschraegPreviewLocationTemplate().replace(YEAR, String.valueOf(jahr)).replace(DIRECTION, blickrichtung).replace(IMAGE_NUMBER, imageNumber) : this.getDefaultPreviewLocationTemplate().replace(FIRST_CHARACTER, String.valueOf(imageNumber.charAt(0))).replace(IMAGE_NUMBER, imageNumber);
        ArrayList<URL> urls = new ArrayList<URL>();
        if (format == null) {
            for (String fileEnding : this.getFileFormats()) {
                try {
                    urls.add(new URL(this.getPreviewUrlBase() + locationOfImage.replace(FILE_ENDING, fileEnding)));
                }
                catch (MalformedURLException ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                }
            }
        } else {
            try {
                urls.add(new URL(this.getPreviewUrlBase() + locationOfImage.replace(FILE_ENDING, format)));
            }
            catch (MalformedURLException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
        }
        return urls.toArray(new URL[0]);
    }

    public URL[] getPreviewPictureUrls(String imageNumber, Integer bildtypId, Integer jahr, String blickrichtung) {
        return this.getPreviewPictureUrls(imageNumber, bildtypId, jahr, blickrichtung, null);
    }

    public URL[] getHighresPictureUrls(String imageNumber, Integer bildtypId, Integer jahr, String blickrichtung, String format) {
        String locationOfImage = MetaObjectNodesStadtbildSerieSearchStatement.Bildtyp.REIHENSCHRAEG.getId() == bildtypId.intValue() ? this.getReihenschraegHighresLocationTemplate().replace(YEAR, String.valueOf(jahr)).replace(DIRECTION, blickrichtung).replace(IMAGE_NUMBER, imageNumber) : this.getDefaultHighresLocationTemplate().replace(FIRST_CHARACTER, String.valueOf(imageNumber.charAt(0))).replace(IMAGE_NUMBER, imageNumber);
        ArrayList<URL> urls = new ArrayList<URL>();
        if (format == null) {
            for (String fileEnding : this.getFileFormats()) {
                try {
                    urls.add(new URL(this.getHighresUrlBase() + locationOfImage.replace(FILE_ENDING, fileEnding)));
                }
                catch (MalformedURLException ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                }
            }
        } else {
            try {
                urls.add(new URL(this.getHighresUrlBase() + locationOfImage.replace(FILE_ENDING, format)));
            }
            catch (MalformedURLException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
        }
        return urls.toArray(new URL[0]);
    }

    public URL[] getHighresPictureUrls(String imageNumber, Integer bildtypId, Integer jahr, String blickrichtung) {
        return this.getHighresPictureUrls(imageNumber, bildtypId, jahr, blickrichtung, null);
    }

    public String getPreviewUrlBase() {
        return this.previewUrlBase;
    }

    public String getHighresUrlBase() {
        return this.highresUrlBase;
    }

    public String getDefaultHighresLocationTemplate() {
        return this.defaultHighresLocationTemplate;
    }

    public String getDefaultPreviewLocationTemplate() {
        return this.defaultPreviewLocationTemplate;
    }

    public String getReihenschraegHighresLocationTemplate() {
        return this.reihenschraegHighresLocationTemplate;
    }

    public String getReihenschraegPreviewLocationTemplate() {
        return this.reihenschraegPreviewLocationTemplate;
    }

    public String getArcLocationTemplate() {
        return this.arcLocationTemplate;
    }

    public String[] getFileFormats() {
        return this.fileFormats;
    }

    public Integer getCacheSize() {
        return this.cacheSize;
    }

    public String getTifferAnnotation() {
        return this.tifferAnnotation;
    }
}

