/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.vermessungsunterlagen.tasks;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import de.cismet.cids.custom.utils.alkis.AlkisProductDescription;
import de.cismet.cids.custom.utils.alkis.ServerAlkisProducts;
import de.cismet.cids.custom.utils.vermessungsunterlagen.VermessungsunterlagenUtils;
import de.cismet.cids.custom.utils.vermessungsunterlagen.exceptions.VermessungsunterlagenTaskException;
import de.cismet.cids.custom.utils.vermessungsunterlagen.tasks.VermUntTaskNivP;
import de.cismet.cids.dynamics.CidsBean;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;

public class VermUntTaskNivPUebersicht
extends VermUntTaskNivP {
    public static final String TYPE = "NivP_Uebersicht";
    private final String auftragsnummer;
    private final Collection<CidsBean> flurstuecke;

    public VermUntTaskNivPUebersicht(String jobkey, Collection<CidsBean> nivPoints, Collection<CidsBean> flurstuecke, String auftragsnummer) {
        super(TYPE, jobkey, nivPoints);
        this.flurstuecke = flurstuecke;
        this.auftragsnummer = auftragsnummer;
    }

    @Override
    public void performTask() throws VermessungsunterlagenTaskException {
        File src = new File(this.getProperties().getAbsPathPdfNivP());
        File dst = new File(this.getPath() + "/" + src.getName());
        if (!dst.exists()) {
            try {
                FileUtils.copyFile((File)src, (File)dst);
            }
            catch (Exception ex) {
                String message = "Beim Kopieren des NivP-Informations-PDFs kam es zu einem unerwarteten Fehler.";
                throw new VermessungsunterlagenTaskException(this.getType(), "Beim Kopieren des NivP-Informations-PDFs kam es zu einem unerwarteten Fehler.", ex);
            }
        }
        GeometryFactory geometryFactory = new GeometryFactory();
        ArrayList<Geometry> geometries = new ArrayList<Geometry>(this.getNivPoints().size());
        for (CidsBean nivPoint : this.getNivPoints()) {
            Geometry geom = (Geometry)nivPoint.getProperty("geometrie.geo_field");
            geometries.add(geom);
        }
        Envelope envelope = geometryFactory.createGeometryCollection(geometries.toArray(new Geometry[0])).getEnvelopeInternal();
        Coordinate center = envelope.centre();
        String landparcelcode = (String)this.flurstuecke.iterator().next().getProperty("alkis_id");
        AlkisProductDescription product = VermessungsunterlagenUtils.determineAlkisProduct(String.valueOf("WUP-Kommunal"), String.valueOf("NivP-\u00dcbersicht"), envelope);
        try {
            URL url = ServerAlkisProducts.getInstance().productKarteUrl(landparcelcode, product.getCode(), Double.valueOf(0.0).intValue(), Double.valueOf(center.x).intValue(), Double.valueOf(center.y).intValue(), product.getMassstab(), product.getMassstabMin(), product.getMassstabMax(), "", this.auftragsnummer, false, null);
            String filename = product.getCode() + "." + landparcelcode.replace("/", "--") + (this.flurstuecke.size() > 1 ? ".ua" : "") + ".pdf";
            try (InputStream in = VermessungsunterlagenUtils.doGetRequest(url);
                 FileOutputStream out = new FileOutputStream(this.getPath() + "/" + filename);){
                VermessungsunterlagenUtils.downloadStream(in, out);
            }
        }
        catch (Exception ex) {
            String message = "Beim Herunterladen der NIVP-\u00dcbersicht kam es zu einem unerwarteten Fehler.";
            throw new VermessungsunterlagenTaskException(this.getType(), "Beim Herunterladen der NIVP-\u00dcbersicht kam es zu einem unerwarteten Fehler.", ex);
        }
    }
}

