/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions.orbit;

import de.cismet.cids.custom.wunda_blau.search.actions.orbit.StacEntry;
import java.util.HashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.RandomStringUtils;

public class OrbitStacTools {
    private HashMap<String, StacEntry> stacs = new HashMap();

    private OrbitStacTools() {
    }

    public static OrbitStacTools getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public String createStac(String base_login_name, String ipAddress, String stacOptions) {
        int length = 16;
        boolean useLetters = true;
        boolean useNumbers = true;
        String stac = RandomStringUtils.random((int)16, (boolean)true, (boolean)true);
        StacEntry stacEntry = new StacEntry(stac, base_login_name, ipAddress, stacOptions);
        this.stacs.put(stacEntry.getHash(), stacEntry);
        return stac;
    }

    public StacEntry getEntry(String stac) {
        return this.stacs.get(DigestUtils.md5Hex((String)stac));
    }

    public void removeStac(String stac) {
        this.stacs.remove(DigestUtils.md5Hex((String)stac));
    }

    private static final class LazyInitialiser {
        private static final OrbitStacTools INSTANCE;

        private LazyInitialiser() {
        }

        static {
            try {
                INSTANCE = new OrbitStacTools();
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception while initializing OrbitStacTools", ex);
            }
        }
    }
}

