/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class BaumSchadenSearch
extends AbstractCidsServerSearch
implements MetaObjectNodeServerSearch {
    private static final transient Logger LOG = Logger.getLogger(BaumSchadenSearch.class);
    public static final String TABLE_NAME_MELDUNG = "baum_meldung";
    public static final String TABLE_NAME_SCHADEN = "baum_schaden";
    public static final String TABLE_NAME_GEBIET = "baum_gebiet";
    public static final String TABLE_NAME_ART = "baum_art";
    public static final String TABLE_NAME_HAUPTART = "baum_hauptart";
    public static final String FIELD__SCHADEN_ID = "id";
    public static final String FIELD__SCHADEN_FK = "fk_meldung";
    public static final String FIELD__GEBIET_AZ = "aktenzeichen";
    public static final String FIELD__GEBIET_ID = "id";
    public static final String FIELD__MELDUNG_DATUM = "datum";
    public static final String FIELD__SCHADEN_ART = "fk_art";
    public static final String FIELD__MELDUNG_FK = "fk_gebiet";
    public static final String FIELD__MELDUNG_ID = "id";
    public static final String FIELD__ART_NAME = "name";
    public static final String FIELD__ART_ID = "id";
    public static final String FIELD__ART_FK = "fk_hauptart";
    public static final String FIELD__HAUPTART_NAME = "name";
    public static final String FIELD__HAUPTART_ID = "id";
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String QUERY_TEMPLATE = "SELECT   (SELECT c.id FROM cs_class c WHERE table_name ILIKE 'baum_schaden') AS class_id, baum_schaden.id, baum_gebiet.aktenzeichen || '---' || to_char(baum_meldung.datum, 'DD.MM.YY') || '---' || baum_schaden.id || '(' || COALESCE(baum_hauptart.name, ' '::character varying) || '-' || COALESCE(baum_art.name, ' '::character varying) || ')' AS zuord_name FROM baum_schaden LEFT JOIN baum_meldung ON baum_meldung.id = baum_schaden.fk_meldung LEFT JOIN baum_gebiet ON baum_meldung.fk_gebiet = baum_gebiet.id LEFT JOIN baum_art ON baum_schaden.fk_art = baum_art.id LEFT JOIN baum_hauptart ON baum_art.fk_hauptart = baum_hauptart.id ORDER BY baum_gebiet.aktenzeichen, baum_meldung.datum";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private Integer ersatzId;
    private Integer ersatzFKSchaden;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            ArrayList leftJoins = new ArrayList();
            ArrayList<String> wheres = new ArrayList<String>();
            if (this.getErsatzId() != null) {
                wheres.add(String.format("baum_schaden.id = %d", this.getErsatzFKSchaden()));
            }
            String leftJoin = !leftJoins.isEmpty() ? String.format("LEFT JOIN %s", String.join((CharSequence)" LEFT JOIN ", leftJoins)) : "";
            String where = !wheres.isEmpty() ? String.format("WHERE %s", String.join((CharSequence)" AND ", wheres)) : "";
            String query = String.format(QUERY_TEMPLATE, leftJoin, where);
            LOG.info((Object)query);
            MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
            ArrayList<MetaObjectNode> mons = new ArrayList<MetaObjectNode>();
            ArrayList resultList = ms.performCustomSearch(query, this.getConnectionContext());
            for (ArrayList al : resultList) {
                int cid = (Integer)al.get(0);
                int oid = (Integer)al.get(1);
                String name = String.valueOf(al.get(2));
                MetaObjectNode mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, name, null, null);
                mons.add(mon);
            }
            return mons;
        }
        catch (RemoteException ex) {
            LOG.error((Object)"error while searching for baum_schaden", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setErsatzId(Integer ersatzId) {
        this.ersatzId = ersatzId;
    }

    public Integer getErsatzId() {
        return this.ersatzId;
    }

    public void setErsatzFKSchaden(Integer ersatzFKSchaden) {
        this.ersatzFKSchaden = ersatzFKSchaden;
    }

    public Integer getErsatzFKSchaden() {
        return this.ersatzFKSchaden;
    }
}

