/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.ActionService;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.search.SearchRuntimeException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Geometry;
import de.aedsicad.aaaweb.rest.api.AlkisSucheApi;
import de.aedsicad.aaaweb.rest.client.ApiException;
import de.cismet.cids.custom.utils.alkis.AlkisAccessProvider;
import de.cismet.cids.custom.utils.alkis.AlkisRestConf;
import de.cismet.cids.custom.wunda_blau.search.server.SearchProperties;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;

public class CidsAlkisSearchStatement
extends AbstractCidsServerSearch
implements MetaObjectNodeServerSearch,
ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(CidsAlkisSearchStatement.class);
    private static final String INTERSECTS_BUFFER = SearchProperties.getInstance().getIntersectsBuffer();
    public static String WILDCARD = "%";
    private static final int TIMEOUT = 100000;
    private Resulttyp resulttyp = Resulttyp.FLURSTUECK;
    private String name;
    private String vorname;
    private String geburtsname;
    private String geburtstag;
    private Personentyp ptyp = null;
    private String flurstuecksnummer = null;
    private String buchungsblattnummer = null;
    private SucheUeber ueber = null;
    private Geometry geometry = null;
    private boolean useWildcardForBuchungsblattsearch = true;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public CidsAlkisSearchStatement(Resulttyp resulttyp, SucheUeber ueber, String flurstuecksnummerOrBuchungsblattnummer, Geometry geometry) {
        this(resulttyp, ueber, flurstuecksnummerOrBuchungsblattnummer, geometry, true);
    }

    public CidsAlkisSearchStatement(Resulttyp resulttyp, SucheUeber ueber, String flurstuecksnummerOrBuchungsblattnummer, Geometry geometry, boolean useWildcardForBuchungsblattsearch) {
        this.resulttyp = resulttyp;
        this.ueber = ueber;
        if (ueber == SucheUeber.FLURSTUECKSNUMMER) {
            this.flurstuecksnummer = flurstuecksnummerOrBuchungsblattnummer;
        } else if (ueber == SucheUeber.BUCHUNGSBLATTNUMMER) {
            this.buchungsblattnummer = flurstuecksnummerOrBuchungsblattnummer;
        }
        this.geometry = geometry;
        this.useWildcardForBuchungsblattsearch = useWildcardForBuchungsblattsearch;
    }

    public CidsAlkisSearchStatement(Resulttyp resulttyp, String name, String vorname, String geburtsname, String geburtstag, Personentyp ptyp, Geometry g) {
        this.resulttyp = resulttyp;
        this.ueber = SucheUeber.EIGENTUEMER;
        String lengthTest = name;
        this.name = lengthTest.length() > 0 ? lengthTest : null;
        lengthTest = vorname;
        this.vorname = lengthTest.length() > 0 ? lengthTest : null;
        lengthTest = geburtsname;
        this.geburtsname = lengthTest.length() > 0 ? lengthTest : null;
        lengthTest = geburtstag;
        this.geburtstag = lengthTest.length() > 0 ? lengthTest : null;
        this.ptyp = ptyp;
        this.geometry = g;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            AlkisAccessProvider accessProvider = new AlkisAccessProvider(AlkisRestConf.loadFromDomainServer(this.getUser(), (ActionService)this.getActiveLocalServers().get("WUNDA_BLAU"), this.getConnectionContext()));
            AlkisSucheApi searchService = accessProvider.getAlkisSearchService();
            String query = null;
            switch (this.ueber) {
                case EIGENTUEMER: {
                    String salutation = null;
                    if (this.ptyp == Personentyp.MANN) {
                        salutation = "2000";
                    } else if (this.ptyp == Personentyp.FRAU) {
                        salutation = "1000";
                    } else if (this.ptyp == Personentyp.FIRMA) {
                        salutation = "3000";
                    }
                    String aToken = accessProvider.login();
                    List ownersIds = searchService.searchOwnersWithAttributes(aToken, accessProvider.getAlkisRestConf().getConfiguration(), salutation, this.vorname, this.name, this.geburtsname, this.geburtstag, null, null, Integer.valueOf(100000));
                    accessProvider.logout(aToken);
                    if (ownersIds == null) break;
                    StringBuilder whereClauseBuilder = new StringBuilder(ownersIds.size() * 20);
                    for (String oid : ownersIds) {
                        if (whereClauseBuilder.length() > 0) {
                            whereClauseBuilder.append(',');
                        }
                        whereClauseBuilder.append('\'').append(StringEscapeUtils.escapeSql((String)oid)).append('\'');
                    }
                    if (this.resulttyp == Resulttyp.FLURSTUECK) {
                        query = "select distinct (select id from cs_class where table_name ilike 'alkis_landparcel') as class_id, lp.id as object_id, lp.alkis_id from alkis_landparcel lp,alkis_flurstueck_to_buchungsblaetter jt,alkis_buchungsblatt bb,ownerofbb where lp.buchungsblaetter=jt.flurstueck_reference and jt.buchungsblatt=bb.id and bb.buchungsblattcode = ownerofbb.bb and ownerofbb.ownerid in (" + whereClauseBuilder + ")";
                        break;
                    }
                    query = "select distinct (select id from cs_class where table_name ilike 'alkis_buchungsblatt') as class_id, jt.buchungsblatt as object_id,bb.buchungsblattcode from alkis_landparcel lp,alkis_flurstueck_to_buchungsblaetter jt,alkis_buchungsblatt bb,ownerofbb where lp.buchungsblaetter=jt.flurstueck_reference and jt.buchungsblatt=bb.id and bb.buchungsblattcode = ownerofbb.bb and ownerofbb.ownerid in (" + whereClauseBuilder + ")";
                    break;
                }
                case BUCHUNGSBLATTNUMMER: {
                    if (this.resulttyp == Resulttyp.FLURSTUECK) {
                        if (this.useWildcardForBuchungsblattsearch) {
                            query = "select distinct (select id from cs_class where table_name ilike 'alkis_landparcel') as class_id, lp.id as object_id, lp.alkis_id from alkis_landparcel lp,alkis_flurstueck_to_buchungsblaetter jt,alkis_buchungsblatt bb where lp.buchungsblaetter=jt.flurstueck_reference and jt.buchungsblatt=bb.id and bb.buchungsblattcode ilike '" + this.buchungsblattnummer + WILDCARD + "'";
                            break;
                        }
                        query = "select distinct (select id from cs_class where table_name ilike 'alkis_landparcel') as class_id, lp.id as object_id, lp.alkis_id from alkis_landparcel lp,alkis_flurstueck_to_buchungsblaetter jt,alkis_buchungsblatt bb where lp.buchungsblaetter=jt.flurstueck_reference and jt.buchungsblatt=bb.id and bb.buchungsblattcode ilike '" + this.buchungsblattnummer + "'";
                        break;
                    }
                    if (this.useWildcardForBuchungsblattsearch) {
                        query = "select distinct (select id from cs_class where table_name ilike 'alkis_buchungsblatt') as class_id, jt.buchungsblatt as object_id,bb.buchungsblattcode from alkis_landparcel lp,alkis_flurstueck_to_buchungsblaetter jt,alkis_buchungsblatt bb where lp.buchungsblaetter=jt.flurstueck_reference and jt.buchungsblatt=bb.id and bb.buchungsblattcode ilike '" + this.buchungsblattnummer + WILDCARD + "'";
                        break;
                    }
                    query = "select distinct (select id from cs_class where table_name ilike 'alkis_buchungsblatt') as class_id, jt.buchungsblatt as object_id,bb.buchungsblattcode from alkis_landparcel lp,alkis_flurstueck_to_buchungsblaetter jt,alkis_buchungsblatt bb where lp.buchungsblaetter=jt.flurstueck_reference and jt.buchungsblatt=bb.id and bb.buchungsblattcode ilike '" + this.buchungsblattnummer + "'";
                    break;
                }
                case FLURSTUECKSNUMMER: {
                    String flurstueckClause = this.flurstuecksnummer.endsWith("/%") ? "(lp.alkis_id ilike '" + this.flurstuecksnummer + "' or lp.alkis_id ilike '" + this.flurstuecksnummer.substring(0, this.flurstuecksnummer.length() - 2) + "')" : "lp.alkis_id ilike '" + this.flurstuecksnummer + "'";
                    if (this.resulttyp == Resulttyp.FLURSTUECK) {
                        query = "select distinct (select id from cs_class where table_name ilike 'alkis_landparcel') as class_id, lp.id as object_id, lp.alkis_id from alkis_landparcel lp where " + flurstueckClause;
                        break;
                    }
                    query = "select distinct (select id from cs_class where table_name ilike 'alkis_buchungsblatt') as class_id, jt.buchungsblatt as object_id,bb.buchungsblattcode from  alkis_landparcel lp,alkis_flurstueck_to_buchungsblaetter jt,alkis_buchungsblatt bb where lp.buchungsblaetter=jt.flurstueck_reference and jt.buchungsblatt=bb.id and " + flurstueckClause;
                    break;
                }
            }
            if (this.geometry != null && query != null) {
                String geostring = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)this.geometry);
                query = query + " and st_intersects(geometrie,st_buffer(st_GeomFromEWKT('" + geostring + "'), " + INTERSECTS_BUFFER + "))";
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Search:\n" + query));
            }
            if (query != null) {
                MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
                ArrayList resultList = ms.performCustomSearch(query, this.getConnectionContext());
                for (ArrayList al : resultList) {
                    int cid = (Integer)al.get(0);
                    int oid = (Integer)al.get(1);
                    String nodename = (String)al.get(2);
                    MetaObjectNode mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, nodename, null, null);
                    result.add(mon);
                }
            }
            return result;
        }
        catch (ApiException e) {
            if (e.getResponseBody() != null) {
                LOG.error((Object)("Problem" + e.getResponseBody()), (Throwable)e);
                String message = e.getResponseBody();
                try {
                    ObjectMapper map = new ObjectMapper();
                    JsonNode node = map.readTree(message);
                    JsonNode tmpMessage = node.get("error");
                    if (tmpMessage != null && tmpMessage.get("message") != null) {
                        tmpMessage = tmpMessage.get("message");
                        message = "<html>" + tmpMessage.textValue();
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Cannot parse exception", (Throwable)ex);
                }
                throw new SearchRuntimeException(message);
            }
            LOG.error((Object)"Problem", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            LOG.error((Object)"Problem", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum Personentyp {
        MANN,
        FRAU,
        FIRMA;

    }

    public static enum SucheUeber {
        FLURSTUECKSNUMMER,
        BUCHUNGSBLATTNUMMER,
        EIGENTUEMER;

    }

    public static enum Resulttyp {
        FLURSTUECK,
        BUCHUNGSBLATT;

    }
}

