/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class CidsVermessungRissArtSearchStatement
extends AbstractCidsServerSearch
implements ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(CidsVermessungRissArtSearchStatement.class);
    private static final String DOMAIN = "WUNDA_BLAU";
    private static final String CIDSCLASS = "vermessung_art";
    private static final String SQL = "SELECT DISTINCT (SELECT c.id FROM cs_class c WHERE table_name ilike 'vermessung_art') as class_id, id, code||' - '||name as name FROM vermessung_art ORDER BY name";
    private final User user;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public CidsVermessungRissArtSearchStatement(User user) {
        this.user = user;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection performServerSearch() {
        try {
            MetaService metaService;
            LinkedList<MetaObject> result = new LinkedList<MetaObject>();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Search for all geometry states started.");
            }
            if ((metaService = (MetaService)this.getActiveLocalServers().get(DOMAIN)) == null) {
                LOG.error((Object)"Could not retrieve MetaService 'WUNDA_BLAU'.");
                return result;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Executing SQL statement 'SELECT DISTINCT (SELECT c.id FROM cs_class c WHERE table_name ilike 'vermessung_art') as class_id, id, code||' - '||name as name FROM vermessung_art ORDER BY name'.");
            }
            ArrayList resultset = metaService.performCustomSearch(SQL, this.getConnectionContext());
            for (ArrayList veraenderungsart : resultset) {
                int classID = (Integer)veraenderungsart.get(0);
                int objectID = (Integer)veraenderungsart.get(1);
                try {
                    result.add(metaService.getMetaObject(this.user, objectID, classID, this.getConnectionContext()));
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Couldn't get CidsBean for class '" + classID + "', object '" + objectID + "', user '" + this.user + "'."), (Throwable)ex);
                }
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)"Problem", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

