/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.custom.wunda_blau.search.server.BaumSchadenSearch;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class ZaehlungLastYearsSearch
extends AbstractCidsServerSearch
implements MetaObjectNodeServerSearch {
    private static final transient Logger LOG = Logger.getLogger(BaumSchadenSearch.class);
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String QUERY_TEMPLATE = String.format("SELECT   (SELECT c.id FROM cs_class c WHERE table_name ILIKE 'zaehlung') AS class_id,  z.id \nfrom zaehlung z\nleft join zaehlung_ref r on z.id = r.zaehlung_ref\n", new Object[0]);
    private ConnectionContext connectionContext = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)ZaehlungLastYearsSearch.class.getSimpleName());
    private Integer standortId;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            ArrayList leftJoins = new ArrayList();
            ArrayList<String> wheres = new ArrayList<String>();
            if (this.getStandortId() != null) {
                wheres.add(String.format("standpunkt_ref= %d", this.getStandortId()));
                wheres.add(String.format("date_part('year'::text, datum) in (\nselect date_part('year'::text, datum)\nfrom zaehlung z\nleft join zaehlung_ref r on z.id = r.zaehlung_ref\nwhere standpunkt_ref= %d \ngroup by date_part('year'::text, datum)\norder by date_part('year'::text, datum) desc\nfetch first 2 row only)", this.getStandortId()));
            }
            String leftJoin = !leftJoins.isEmpty() ? String.format("LEFT JOIN %s", String.join((CharSequence)" LEFT JOIN ", leftJoins)) : "";
            String where = !wheres.isEmpty() ? String.format("WHERE %s", String.join((CharSequence)" AND ", wheres)) : "";
            String query = this.QUERY_TEMPLATE + where;
            LOG.info((Object)query);
            MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
            ArrayList<MetaObjectNode> mons = new ArrayList<MetaObjectNode>();
            ArrayList resultList = ms.performCustomSearch(query, this.getConnectionContext());
            for (ArrayList al : resultList) {
                int cid = (Integer)al.get(0);
                int oid = (Integer)al.get(1);
                String name = String.valueOf(al.get(1));
                MetaObjectNode mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, name, null, null);
                mons.add(mon);
            }
            return mons;
        }
        catch (RemoteException ex) {
            LOG.error((Object)"error while searching for zaehlung", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setStandortId(Integer standortId) {
        this.standortId = standortId;
    }

    public Integer getStandortId() {
        return this.standortId;
    }
}

