/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.deletionprovider;

import Sirius.server.localserver.object.AbstractCustomDeletionProvider;
import Sirius.server.localserver.object.DeletionProviderClientException;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SpstArtDeletionProvider
extends AbstractCustomDeletionProvider {
    private static final Logger LOG = Logger.getLogger(SpstArtDeletionProvider.class);
    private static final String TABLE_NAME = "spst_art";
    private static final String FIELD__ID = "id";
    private static final String FIELD__FK = "fk_art";
    private static final String TABLE_NAME_SEARCH = "spst_anlage";
    private static final String DELETE_TEXT = "Diese Art kann nicht gel\u00f6scht werden, da diese verwendet wird.";

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isMatching(User user, MetaObject metaObject) {
        if (!super.isMatching(user, metaObject)) {
            return false;
        }
        CidsBean artBean = metaObject.getBean();
        Integer art_id = (Integer)artBean.getProperty(FIELD__ID);
        String queryArtInAnlage = String.format("SELECT * FROM %s WHERE %s = %d;", TABLE_NAME_SEARCH, FIELD__FK, art_id);
        try {
            ArrayList artArray = this.getMetaService().performCustomSearch(queryArtInAnlage, this.getConnectionContext());
            if (!artArray.isEmpty()) {
                return true;
            }
        }
        catch (RemoteException ex) {
            LOG.error((Object)"Cannot delete art object", (Throwable)ex);
        }
        return false;
    }

    public boolean customDeleteMetaObject(User user, MetaObject metaObject) throws Exception {
        throw new DeletionProviderClientException(DELETE_TEXT);
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

