/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils;

import de.cismet.cids.custom.utils.WundaBlauServerResources;
import java.util.Properties;
import org.apache.log4j.Logger;

public class UaWebDavProperties {
    private static final transient Logger LOG = Logger.getLogger(UaWebDavProperties.class);
    private final Properties properties;
    private final String webDavHost;
    private final String webDavPath;
    private final String webDavLogin;
    private final String webDavPass;

    public UaWebDavProperties(Properties properties) {
        this.properties = properties;
        this.webDavHost = this.readProperty("WEBDAV_HOST", null);
        this.webDavPath = this.readProperty("WEBDAV_PATH", null);
        this.webDavLogin = this.readProperty("WEBDAV_LOGIN", null);
        this.webDavPass = this.readProperty("WEBDAV_PASS", null);
    }

    private String readProperty(String property, String defaultValue) {
        String value = defaultValue;
        try {
            value = this.getProperties().getProperty(property, defaultValue);
        }
        catch (Exception ex) {
            String message = "could not read " + property + " from " + WundaBlauServerResources.UMWELTALARM_WEBDAV_PROPERTIES.getValue() + ". setting to default value: " + defaultValue;
            LOG.warn((Object)message, (Throwable)ex);
        }
        return value;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getWebDavHost() {
        return this.webDavHost;
    }

    public String getWebDavPath() {
        return this.webDavPath;
    }

    public String getWebDavLogin() {
        return this.webDavLogin;
    }

    public String getWebDavPass() {
        return this.webDavPass;
    }
}

