/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.alkis;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import de.cismet.cids.custom.utils.alkis.ServerAlkisConf;
import de.cismet.cids.custom.utils.alkis.ServerAlkisProducts;
import de.cismet.commons.security.handler.ExtendedAccessHandler;
import de.cismet.commons.security.handler.SimpleHttpAccessHandler;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.media.jai.RenderedImageAdapter;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import org.apache.log4j.Logger;

public class AlkisPunktReportScriptlet
extends JRDefaultScriptlet {
    protected static final Logger LOG = Logger.getLogger(AlkisPunktReportScriptlet.class);
    public static final String[] SUFFIXES = new String[]{"tif", "jpg", "tiff", "jpeg"};
    private static final transient SimpleHttpAccessHandler EXTENDED_ACCESS_HANDLER = new SimpleHttpAccessHandler();

    public static Boolean isImageAvailable(String pointcode) {
        return AlkisPunktReportScriptlet.isImageAvailable(pointcode, (ExtendedAccessHandler)EXTENDED_ACCESS_HANDLER);
    }

    public static Boolean isImageAvailable(String pointcode, ExtendedAccessHandler extendedAccessHandler) {
        Collection<String> validDocuments = ServerAlkisProducts.getInstance().getCorrespondingPointDocuments(pointcode);
        for (String document : validDocuments) {
            try {
                URL url = ServerAlkisConf.getInstance().getDownloadUrlForDocument(document);
                if (!extendedAccessHandler.checkIfURLaccessible(url)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return Boolean.FALSE;
    }

    public static Image loadImage(String pointcode) {
        return AlkisPunktReportScriptlet.loadImage(pointcode, (ExtendedAccessHandler)EXTENDED_ACCESS_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image loadImage(String pointcode, ExtendedAccessHandler extendedAccessHandler) {
        Collection<String> validDocuments = ServerAlkisProducts.getInstance().getCorrespondingPointDocuments(pointcode);
        String suffix = "";
        InputStream streamToReadFrom = null;
        for (String document : validDocuments) {
            try {
                URL url = ServerAlkisConf.getInstance().getDownloadUrlForDocument(document);
                if (!extendedAccessHandler.checkIfURLaccessible(url)) continue;
                streamToReadFrom = extendedAccessHandler.doRequest(url);
                suffix = url.toExternalForm().substring(url.toExternalForm().lastIndexOf(46));
                if (streamToReadFrom == null) continue;
                break;
            }
            catch (Exception ex) {
                LOG.warn((Object)("An exception occurred while opening URL '" + document + "'. Skipping this url."), (Throwable)ex);
            }
        }
        BufferedImage result = null;
        try {
            if (streamToReadFrom == null) {
                String document;
                LOG.error((Object)"Couldn't get a connection to associated ap map.");
                document = result;
                return document;
            }
            if (suffix.endsWith("tif") || suffix.endsWith("tiff") || suffix.endsWith("TIF") || suffix.endsWith("TIFF")) {
                ImageDecodeParam param = null;
                ImageDecoder decoder = ImageCodec.createImageDecoder((String)"tiff", (InputStream)streamToReadFrom, param);
                RenderedImage image = decoder.decodeAsRenderedImage();
                RenderedImageAdapter imageAdapter = new RenderedImageAdapter(image);
                result = imageAdapter.getAsBufferedImage();
            } else {
                result = ImageIO.read(streamToReadFrom);
            }
        }
        catch (IOException ex) {
            LOG.warn((Object)"Could not read image.", (Throwable)ex);
            BufferedImage bufferedImage = result;
            return bufferedImage;
        }
        finally {
            try {
                if (streamToReadFrom != null) {
                    streamToReadFrom.close();
                }
            }
            catch (IOException ex) {
                LOG.warn((Object)"Couldn't close the stream.", (Throwable)ex);
            }
        }
        return result;
    }
}

