/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.alkis;

import Sirius.server.middleware.interfaces.domainserver.ActionService;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;

public class AlkisRestConf
extends Properties {
    private final Crendetials creds;
    private final String configuration;
    private final String credentialsFile;
    private final String tokenApi;
    private final String aaaWebApi;
    private final Boolean newRestServiceUsed;

    public AlkisRestConf(Properties serviceProperties) throws IOException {
        this.configuration = serviceProperties.getProperty("CONFIGURATION");
        this.credentialsFile = serviceProperties.getProperty("CREDENTIALS_FILE");
        this.tokenApi = serviceProperties.getProperty("TOKEN_API");
        this.aaaWebApi = serviceProperties.getProperty("AAAWEB_API");
        this.newRestServiceUsed = serviceProperties.getProperty("NEW_REST_SERVICE_USED", "false").equalsIgnoreCase("true");
        String crendentialsFile = this.getCredentialsFile();
        if (crendentialsFile != null) {
            Properties credProperties = new Properties();
            credProperties.load(new FileInputStream(new File(crendentialsFile)));
            this.creds = new Crendetials(credProperties);
        } else {
            this.creds = null;
        }
    }

    public static AlkisRestConf getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public static AlkisRestConf loadFromDomainServer(User user, ActionService as, ConnectionContext connectionContext) throws Exception {
        Properties properties = new Properties();
        properties.load(new StringReader((String)as.executeTask(user, "getServerResource", (Object)WundaBlauServerResources.ALKIS_REST_CONF.getValue(), connectionContext, new ServerActionParameter[0])));
        return new AlkisRestConf(properties);
    }

    public Crendetials getCreds() {
        return this.creds;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getCredentialsFile() {
        return this.credentialsFile;
    }

    public String getTokenApi() {
        return this.tokenApi;
    }

    public String getAaaWebApi() {
        return this.aaaWebApi;
    }

    public Boolean getNewRestServiceUsed() {
        return this.newRestServiceUsed;
    }

    public class Crendetials {
        private final String user;
        private final String password;

        public Crendetials(Properties properties) {
            this.user = properties.getProperty("USER");
            this.password = properties.getProperty("PASSWORD");
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }
    }

    private static final class LazyInitialiser {
        private static final AlkisRestConf INSTANCE;

        private LazyInitialiser() {
        }

        static {
            try {
                INSTANCE = new AlkisRestConf(ServerResourcesLoader.getInstance().loadProperties(WundaBlauServerResources.ALKIS_REST_CONF.getValue()));
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception while initializing ServerAlkisRestConf", ex);
            }
        }
    }
}

