/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.alkis;

import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.jfif.JfifDescriptor;
import com.drew.metadata.jfif.JfifDirectory;
import com.drew.metadata.jpeg.JpegDescriptor;
import com.drew.metadata.jpeg.JpegDirectory;
import com.twelvemonkeys.imageio.metadata.CompoundDirectory;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.exif.EXIFReader;
import com.twelvemonkeys.imageio.metadata.exif.Rational;
import de.cismet.cids.custom.utils.alkis.BaulastenPictureFinder;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.commons.utils.MultiPagePictureReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.log4j.Logger;

public class BaulastenReportGenerator {
    private static final Logger LOG = Logger.getLogger(BaulastenReportGenerator.class);
    private static final String PARAMETER_JOBNUMBER = "JOBNUMBER";
    private static final String PARAMETER_PROJECTNAME = "PROJECTNAME";
    private static final String PARAMETER_TYPE = "TYPE";
    private static final String PARAMETER_STARTINGPAGES = "STARTINGPAGES";
    private static final String PARAMETER_IMAGEAVAILABLE = "IMAGEAVAILABLE";
    private static final String PARAMETER_FABRICATIONNOTICE = "FABRICATIONNOTICE";
    private static final double INCH_IN_MM = 25.4;
    private static final int MAX_WIDTH_DINA4 = 170;
    private static final int MAX_HEIGHT_DINA4 = 257;
    private static final int MAX_WIDTH_DINA3 = 257;
    private static final int MAX_HEIGHT_DINA3 = 380;
    private static final int MAX_WIDTH_DINA2 = 380;
    private static final int MAX_HEIGHT_DINA2 = 554;
    private static final int MAX_WIDTH_DINA1 = 554;
    private static final int MAX_HEIGHT_DINA1 = 801;
    private static final int MAX_WIDTH_DINA0 = 801;
    private static final int MAX_HEIGHT_DINA0 = 1149;
    private JRDataSource dataSource;
    private Map parameters;
    private final BaulastenPictureFinder pictureFinder;
    private final MultiPagePictureReaderCreator multipageReaderCreator;

    public BaulastenReportGenerator(BaulastenPictureFinder pictureFinder) {
        this(pictureFinder, new MultiPagePictureReaderCreator());
    }

    public BaulastenReportGenerator(BaulastenPictureFinder pictureFinder, MultiPagePictureReaderCreator multipageReaderCreator) {
        this.pictureFinder = pictureFinder;
        this.multipageReaderCreator = multipageReaderCreator;
    }

    public void generate(Collection<CidsBean> selectedBaulasten, Type type, String jobNumber, String projectName, String fertigungsVermerk) throws Exception {
        ArrayList<CidsBean> sortedBaulasten = new ArrayList<CidsBean>(selectedBaulasten);
        Collections.sort(sortedBaulasten, new Comparator<CidsBean>(){

            @Override
            public int compare(CidsBean o1, CidsBean o2) {
                int lfdN2;
                String bnr1 = o1 == null ? "" : (String)o1.getProperty("blattnummer");
                String bnr2 = o2 == null ? "" : (String)o2.getProperty("blattnummer");
                Integer lfdN1 = o1 == null ? -1 : Integer.parseInt((String)o1.getProperty("laufende_nummer"));
                int n = lfdN2 = o2 == null ? -1 : Integer.parseInt((String)o2.getProperty("laufende_nummer"));
                if (!bnr1.equalsIgnoreCase(bnr2)) {
                    return bnr1.compareToIgnoreCase(bnr2);
                }
                return lfdN1.compareTo(lfdN2);
            }
        });
        LinkedList<BaulastReportBean> reportBeans = new LinkedList<BaulastReportBean>();
        LinkedList<BaulastImageReportBean> imageBeans = new LinkedList<BaulastImageReportBean>();
        LinkedList<BaulastPlotempfehlungReportBean> plotBeans = new LinkedList<BaulastPlotempfehlungReportBean>();
        HashMap<Object, String> startingPages = new HashMap<Object, String>();
        int tileTableRows = 10 + sortedBaulasten.size();
        HashMap<Object, Boolean> imageAvailable = new HashMap<Object, Boolean>();
        if (Type.TEXTBLATT_PLAN_RASTER.equals((Object)type)) {
            int rasterPages = 0;
            for (CidsBean selectedBaulast : sortedBaulasten) {
                List<String> documentListRasterdaten = this.pictureFinder.findPlanPicture(selectedBaulast);
                for (String document : documentListRasterdaten) {
                    MetadataInfo metadataInfo;
                    URL url = this.pictureFinder.getUrlForDocument(document);
                    MultiPagePictureReader reader = this.multipageReaderCreator.createReader(url, false, false);
                    EXIFReader exif = new EXIFReader();
                    HashMap<Integer, MetadataInfo> metadatainfoPerPage = new HashMap<Integer, MetadataInfo>();
                    InputStream is = reader.getInputStream();
                    if ("jpeg".equals(reader.getCodec())) {
                        Metadata metadata = ImageMetadataReader.readMetadata((InputStream)is);
                        metadataInfo = this.createMetadataInfoFromJpeg(metadata);
                        if (metadataInfo != null) {
                            metadatainfoPerPage.put(metadataInfo.getPageNumber(), metadataInfo);
                        }
                    } else if ("tiff".equals(reader.getCodec())) {
                        MetadataInfo metadataInfo2;
                        Directory dir = exif.read(ImageIO.createImageInputStream(is));
                        HashMap<Integer, MetadataInfo> metadataInfoPerPageFallBack = new HashMap<Integer, MetadataInfo>();
                        CompoundDirectory dirs = (CompoundDirectory)dir;
                        boolean exifPageError = false;
                        for (int i = 0; i < dirs.directoryCount(); ++i) {
                            Directory subDir = dirs.getDirectory(i);
                            metadataInfo2 = this.createMetadataInfoFromTiff(subDir);
                            if (metadataInfo2 != null) {
                                if (metadataInfo2.getPageNumber() <= 0 || metadataInfo2.getPageNumber() > dirs.directoryCount() || metadataInfoPerPageFallBack.keySet().contains(metadataInfo2.getPageNumber())) {
                                    exifPageError = true;
                                }
                                metadatainfoPerPage.put(metadataInfo2.getPageNumber(), metadataInfo2);
                                metadataInfoPerPageFallBack.put(i + 1, metadataInfo2);
                                continue;
                            }
                            exifPageError = true;
                        }
                        if (metadataInfoPerPageFallBack.size() != dirs.directoryCount()) {
                            exifPageError = true;
                        }
                        if (exifPageError) {
                            Iterator iterator = metadataInfoPerPageFallBack.keySet().iterator();
                            while (iterator.hasNext()) {
                                int pageNumber = (Integer)iterator.next();
                                metadataInfo2 = (MetadataInfo)metadataInfoPerPageFallBack.get(pageNumber);
                                metadataInfo2.setPageNumber(pageNumber);
                            }
                            metadatainfoPerPage.clear();
                            metadatainfoPerPage.putAll(metadataInfoPerPageFallBack);
                        }
                    }
                    for (int page = 1; page <= reader.getNumberOfPages(); ++page) {
                        metadataInfo = (MetadataInfo)metadatainfoPerPage.get(page);
                        String plotempfehlung = metadataInfo != null ? this.calculateDinFormat(metadataInfo.getWidth(), metadataInfo.getHeight(), metadataInfo.getDpiWidth(), metadataInfo.getDpiHeight()) : null;
                        plotBeans.add(new BaulastPlotempfehlungReportBean(page, reader.getNumberOfPages(), url.getFile().substring(url.getFile().lastIndexOf("/") + 1), (String)selectedBaulast.getProperty("blattnummer"), (String)selectedBaulast.getProperty("laufende_nummer"), plotempfehlung != null ? plotempfehlung : "-"));
                    }
                    rasterPages += reader.getNumberOfPages();
                }
            }
            tileTableRows += 5 + rasterPages;
        }
        int startingPage = 2 + tileTableRows / 37;
        for (CidsBean selectedBaulast : sortedBaulasten) {
            ArrayList<String> documentListTextblatt = new ArrayList<String>();
            ArrayList<String> documentListLageplan = new ArrayList<String>();
            try {
                documentListTextblatt.addAll(this.pictureFinder.findTextblattPicture(selectedBaulast));
            }
            catch (Exception ex) {
                LOG.warn((Object)("Could not include raster document for baulast '" + selectedBaulast.toJSONString(true) + "'."), (Throwable)ex);
                continue;
            }
            if (Type.TEXTBLATT_PLAN.equals((Object)type) || Type.TEXTBLATT_PLAN_RASTER.equals((Object)type)) {
                documentListLageplan.addAll(this.pictureFinder.findPlanPicture(selectedBaulast));
            }
            if (documentListTextblatt.isEmpty()) {
                LOG.info((Object)"No document URLS found for the Baulasten report");
            }
            int pageCount = 0;
            ArrayList<String> documentList = new ArrayList<String>(documentListTextblatt);
            documentList.addAll(documentListLageplan);
            for (String document : documentList) {
                try {
                    URL url = this.pictureFinder.getUrlForDocument(document);
                    MultiPagePictureReader reader = this.multipageReaderCreator.createReader(url, false, false);
                    for (int i = 0; i < reader.getNumberOfPages(); ++i) {
                        imageBeans.add(new BaulastImageReportBean(i, reader));
                    }
                    pageCount += reader.getNumberOfPages();
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Could not read document '" + document + "'. Skipping this url."), (Throwable)ex);
                }
            }
            imageAvailable.put(selectedBaulast.getProperty("id"), pageCount > 0);
            String startingPageString = Integer.toString(startingPage);
            startingPages.put(selectedBaulast.getProperty("id"), startingPageString);
            startingPage += pageCount;
        }
        reportBeans.add(new BaulastReportBean(sortedBaulasten, imageBeans, plotBeans));
        this.dataSource = new JRBeanCollectionDataSource(reportBeans);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(PARAMETER_JOBNUMBER, jobNumber);
        parameters.put(PARAMETER_PROJECTNAME, projectName);
        parameters.put(PARAMETER_TYPE, type.toString());
        parameters.put(PARAMETER_STARTINGPAGES, startingPages);
        parameters.put(PARAMETER_IMAGEAVAILABLE, imageAvailable);
        parameters.put(PARAMETER_FABRICATIONNOTICE, fertigungsVermerk);
        this.parameters = parameters;
    }

    public JRDataSource getDataSource() {
        return this.dataSource;
    }

    public Map getParameters() {
        return this.parameters;
    }

    private String calculateDinFormat(long pixX, long pixY, int dpiX, int dpiY) {
        if (dpiX > 0 && dpiY > 0) {
            String din;
            String format;
            double mmX = (double)(pixX / (long)dpiX) * 25.4;
            double mmY = (double)(pixY / (long)dpiY) * 25.4;
            double cmWidth = mmX <= mmY ? mmX : mmY;
            double cmHeight = mmX <= mmY ? mmY : mmX;
            String string = format = mmX <= mmY ? "Hochformat" : "Querformat";
            if (cmWidth < 170.0 && cmHeight < 257.0) {
                din = "DIN A4";
            } else if (cmWidth < 257.0 && cmHeight < 380.0) {
                din = "DIN A3";
            } else if (cmWidth < 380.0 && cmHeight < 554.0) {
                din = "DIN A2";
            } else if (cmWidth < 554.0 && cmHeight < 801.0) {
                din = "DIN A1";
            } else if (cmWidth < 801.0 && cmHeight < 1149.0) {
                din = "DIN A0";
            } else {
                return null;
            }
            return din + " " + format;
        }
        return null;
    }

    private MetadataInfo createMetadataInfoFromTiff(Directory dir) {
        if (dir == null) {
            return null;
        }
        Entry pageNumberEntry = dir.getEntryById((Object)297);
        Entry imageWidthEntry = dir.getEntryById((Object)256);
        Entry imageHeightEntry = dir.getEntryById((Object)257);
        Entry xResolutionEntry = dir.getEntryById((Object)282);
        Entry yResolutionEntry = dir.getEntryById((Object)283);
        int pageNumber = pageNumberEntry != null ? ((int[])pageNumberEntry.getValue())[0] + 1 : -1;
        try {
            int imageWidth = Integer.parseInt(imageWidthEntry.getValue().toString());
            int imageHeight = Integer.parseInt(imageHeightEntry.getValue().toString());
            int xResolution = ((Rational)xResolutionEntry.getValue()).intValue();
            int yResolution = ((Rational)yResolutionEntry.getValue()).intValue();
            return new MetadataInfo(pageNumber, imageWidth, imageHeight, xResolution, yResolution);
        }
        catch (Exception ex) {
            LOG.info((Object)"could not extract metadata for this page", (Throwable)ex);
            return null;
        }
    }

    private MetadataInfo createMetadataInfoFromJpeg(Metadata metadata) {
        try {
            JpegDirectory jpegDirectory = (JpegDirectory)metadata.getFirstDirectoryOfType(JpegDirectory.class);
            JfifDirectory jfifDirectory = (JfifDirectory)metadata.getFirstDirectoryOfType(JfifDirectory.class);
            JpegDescriptor descJPeg = new JpegDescriptor(jpegDirectory);
            String widthDesc = descJPeg.getImageWidthDescription();
            String heightDesc = descJPeg.getImageHeightDescription();
            JfifDescriptor descJFif = new JfifDescriptor(jfifDirectory);
            String xResDesc = descJFif.getImageResXDescription();
            String yResDesc = descJFif.getImageResYDescription();
            if (widthDesc != null && heightDesc != null && xResDesc != null && yResDesc != null) {
                long width = Long.parseLong(widthDesc.replaceAll(" pixels", ""));
                long height = Long.parseLong(heightDesc.replaceAll(" pixels", ""));
                int dpiX = Integer.parseInt(xResDesc.replaceAll(" dots", ""));
                int dpiY = Integer.parseInt(yResDesc.replaceAll(" dots", ""));
                return new MetadataInfo(1, width, height, dpiX, dpiY);
            }
            return null;
        }
        catch (Exception ex) {
            LOG.warn((Object)"couldn't read the metadata", (Throwable)ex);
            return null;
        }
    }

    public static class MultiPagePictureReaderCreator {
        public MultiPagePictureReader createReader(URL imageURL, boolean caching, boolean checkHeapSize) throws IOException {
            return new MultiPagePictureReader(imageURL, caching, checkHeapSize);
        }
    }

    public static class MetadataInfo {
        private int pageNumber;
        private long width;
        private long height;
        private int dpiWidth;
        private int dpiHeight;

        public int getPageNumber() {
            return this.pageNumber;
        }

        public long getWidth() {
            return this.width;
        }

        public long getHeight() {
            return this.height;
        }

        public int getDpiWidth() {
            return this.dpiWidth;
        }

        public int getDpiHeight() {
            return this.dpiHeight;
        }

        public void setPageNumber(int pageNumber) {
            this.pageNumber = pageNumber;
        }

        public void setWidth(long width) {
            this.width = width;
        }

        public void setHeight(long height) {
            this.height = height;
        }

        public void setDpiWidth(int dpiWidth) {
            this.dpiWidth = dpiWidth;
        }

        public void setDpiHeight(int dpiHeight) {
            this.dpiHeight = dpiHeight;
        }

        public MetadataInfo(int pageNumber, long width, long height, int dpiWidth, int dpiHeight) {
            this.pageNumber = pageNumber;
            this.width = width;
            this.height = height;
            this.dpiWidth = dpiWidth;
            this.dpiHeight = dpiHeight;
        }
    }

    public static class BaulastPlotempfehlungReportBean {
        private final Integer page;
        private final Integer totalPages;
        private final String fileName;
        private final String blattnummer;
        private final String laufende_nummer;
        private final String plotempfehlung;

        public Integer getPage() {
            return this.page;
        }

        public Integer getTotalPages() {
            return this.totalPages;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getBlattnummer() {
            return this.blattnummer;
        }

        public String getLaufende_nummer() {
            return this.laufende_nummer;
        }

        public String getPlotempfehlung() {
            return this.plotempfehlung;
        }

        public BaulastPlotempfehlungReportBean(Integer page, Integer totalPages, String fileName, String blattnummer, String laufende_nummer, String plotempfehlung) {
            this.page = page;
            this.totalPages = totalPages;
            this.fileName = fileName;
            this.blattnummer = blattnummer;
            this.laufende_nummer = laufende_nummer;
            this.plotempfehlung = plotempfehlung;
        }
    }

    public static class BaulastImageReportBean {
        private final Integer page;
        private final MultiPagePictureReader reader;

        public Integer getPage() {
            return this.page;
        }

        public MultiPagePictureReader getReader() {
            return this.reader;
        }

        public BaulastImageReportBean(Integer page, MultiPagePictureReader reader) {
            this.page = page;
            this.reader = reader;
        }
    }

    public static class BaulastReportBean {
        private final Collection<CidsBean> baulasten;
        private final Collection<BaulastImageReportBean> images;
        private final Collection<BaulastPlotempfehlungReportBean> plotempfehlungen;

        public Collection<CidsBean> getBaulasten() {
            return this.baulasten;
        }

        public Collection<BaulastImageReportBean> getImages() {
            return this.images;
        }

        public Collection<BaulastPlotempfehlungReportBean> getPlotempfehlungen() {
            return this.plotempfehlungen;
        }

        public BaulastReportBean(Collection<CidsBean> baulasten, Collection<BaulastImageReportBean> images, Collection<BaulastPlotempfehlungReportBean> plotempfehlungen) {
            this.baulasten = baulasten;
            this.images = images;
            this.plotempfehlungen = plotempfehlungen;
        }
    }

    public static enum Type {
        TEXTBLATT("Bericht mit Textbl\u00e4ttern"),
        TEXTBLATT_PLAN("Bericht mit Textbl\u00e4ttern und Pl\u00e4nen"),
        TEXTBLATT_PLAN_RASTER("Bericht mit Textbl\u00e4ttern, Pl\u00e4nen und Rasterdateien");

        private final String string;

        private Type(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

