/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class BerechtigungspruefungBescheinigungFlurstueckInfo {
    @JsonProperty
    private final String alkisId;
    @JsonProperty
    private final String gemarkung;
    @JsonProperty
    private final String flur;
    @JsonProperty
    private final String zaehler;
    @JsonProperty
    private final String nenner;
    @JsonProperty
    private final String lage;
    @JsonProperty
    private final Collection<String> grundstuecke = new ArrayList<String>();

    public BerechtigungspruefungBescheinigungFlurstueckInfo(@JsonProperty(value="alkisId") String alkisId, @JsonProperty(value="gemarkung") String gemarkung, @JsonProperty(value="flur") String flur, @JsonProperty(value="zaehler") String zaehler, @JsonProperty(value="nenner") String nenner, @JsonProperty(value="lage") String lage, @JsonProperty(value="grundstuecke") Collection<String> grundstuecke) {
        this.alkisId = alkisId;
        this.gemarkung = gemarkung;
        this.flur = flur;
        this.zaehler = zaehler;
        this.nenner = nenner;
        this.lage = lage;
        if (grundstuecke != null) {
            this.grundstuecke.addAll(grundstuecke);
        }
    }

    public String getLage() {
        if (this.lage == null) {
            return null;
        }
        if (this.lage.matches("^\\([0-9]{5}\\) .*$")) {
            return this.lage.substring(8);
        }
        return this.lage;
    }

    public String getNummer() {
        String nummer = Integer.parseInt(this.zaehler) + (this.nenner != null ? "/" + Integer.parseInt(this.nenner) : "");
        return nummer;
    }

    public String getGrundstueckString() {
        if (this.grundstuecke.isEmpty()) {
            return "-";
        }
        String grundstueck = this.grundstuecke.iterator().next();
        if (this.grundstuecke.size() == 1) {
            return grundstueck;
        }
        return grundstueck + " u.a.";
    }

    public String getAlkisId() {
        return this.alkisId;
    }

    public String getGemarkung() {
        return this.gemarkung;
    }

    public String getFlur() {
        return this.flur;
    }

    public String getZaehler() {
        return this.zaehler;
    }

    public String getNenner() {
        return this.nenner;
    }

    public Collection<String> getGrundstuecke() {
        return this.grundstuecke;
    }
}

