/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.formsolutions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import de.cismet.cids.custom.utils.formsolutions.FormSolutionBestellungSpecialLogger;
import de.cismet.cids.custom.utils.formsolutions.FormSolutionsProperties;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class FormSolutionsMySqlHelper {
    private static final transient Logger LOG = Logger.getLogger(FormSolutionsMySqlHelper.class);
    private PreparedStatement preparedSelectStatement;
    private PreparedStatement preparedInsertStatement;
    private PreparedStatement preparedInsertCompleteStatement;
    private PreparedStatement preparedUpdateProductStatement;
    private PreparedStatement preparedUpdateInfoStatement;
    private PreparedStatement preparedUpdateStatusStatement;
    private PreparedStatement preparedUpdatePruefungFreigabeStatement;
    private PreparedStatement preparedUpdatePruefungAblehnungStatement;
    private Connection connection = null;

    private FormSolutionsMySqlHelper() {
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException ex) {
            LOG.error((Object)"com.mysql.jdbc.Driver not found, FormSolutionsMySqlHelper will not work !", (Throwable)ex);
        }
    }

    private void connect() throws SQLException {
        if (this.connection == null || this.connection.isClosed() || !this.connection.isValid(5)) {
            this.connection = DriverManager.getConnection(FormSolutionsProperties.getInstance().getMysqlJdbc());
            this.preparedSelectStatement = this.connection.prepareStatement("SELECT id FROM bestellung WHERE transid = ?;");
            this.preparedInsertStatement = this.connection.prepareStatement("INSERT INTO bestellung (id, transid, status, flurstueck, buchungsblatt, produkt, nur_download, email, dokument_dateipfad, dokument_dateiname, last_update) VALUES (default, ?, ?, null, null, null, null, null, null, null, now());");
            this.preparedInsertCompleteStatement = this.connection.prepareStatement("INSERT INTO bestellung (id, transid, bpruefnr, status, flurstueck, buchungsblatt, produkt, nur_download, email, dokument_dateipfad, dokument_dateiname, last_update) VALUES (default, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, now());");
            this.preparedUpdateProductStatement = this.connection.prepareStatement("UPDATE bestellung SET bpruefnr = ?, status = ?, last_update = now(), dokument_dateipfad = ?, dokument_dateiname = ? WHERE transid = ?;");
            this.preparedUpdateInfoStatement = this.connection.prepareStatement("UPDATE bestellung SET status = ?, last_update = now(), flurstueck = ?, buchungsblatt = ?, produkt = ?, nur_download = ?, email = ? WHERE transid = ?;");
            this.preparedUpdateStatusStatement = this.connection.prepareStatement("UPDATE bestellung SET status = ?, last_update = now() WHERE transid = ?;");
            this.preparedUpdatePruefungFreigabeStatement = this.connection.prepareStatement("UPDATE bestellung SET bpruefnr = ?, status = ?, last_update = now(), abschlussformular = ? WHERE transid = ?;");
            this.preparedUpdatePruefungAblehnungStatement = this.connection.prepareStatement("UPDATE bestellung SET bpruefnr = ?, status = ?, last_update = now(), ablehnungsgrund = ? WHERE transid = ?;");
        }
    }

    public void insertOrUpdateStatus(String transid, int status) throws SQLException {
        if (this.isEnabled()) {
            if (this.checkMysqlEntry(transid)) {
                this.updateStatus(transid, status);
            } else {
                this.insertStatus(transid, status);
            }
        }
    }

    public void insertStatus(String transid, int status) throws SQLException {
        if (this.isEnabled()) {
            this.connect();
            int index = 1;
            this.preparedInsertStatement.setString(index++, transid);
            this.preparedInsertStatement.setInt(index++, status);
            this.preparedInsertStatement.executeUpdate();
        }
    }

    private boolean checkMysqlEntry(String transid) throws SQLException {
        boolean mysqlEntryAlreadyExists = false;
        try (ResultSet resultSet = this.select(transid);){
            mysqlEntryAlreadyExists = resultSet != null && resultSet.next();
        }
        catch (SQLException ex) {
            LOG.error((Object)"check nach bereits vorhandenen transids fehlgeschlagen.", (Throwable)ex);
        }
        return mysqlEntryAlreadyExists;
    }

    public void insertOrUpdateProduct(String transid, int status, String landparcelcode, String buchungsblatt, String product, Boolean downloadOnly, String email, String schluessel, String filePath, String origName) throws SQLException {
        if (this.isEnabled()) {
            if (this.checkMysqlEntry(transid)) {
                this.updateProduct(transid, schluessel, status, filePath, origName);
            } else {
                this.insertProduct(transid, schluessel, status, landparcelcode, buchungsblatt, product, downloadOnly, email, filePath, origName);
            }
        }
    }

    public void insertProduct(String transid, String schluessel, int status, String landparcelcode, String buchungsblatt, String product, Boolean downloadOnly, String email, String filePath, String origName) throws SQLException {
        if (this.isEnabled()) {
            this.connect();
            int index = 1;
            this.preparedInsertCompleteStatement.setString(index++, transid);
            this.preparedInsertCompleteStatement.setString(index++, schluessel);
            this.preparedInsertCompleteStatement.setInt(index++, status);
            this.preparedInsertCompleteStatement.setString(index++, landparcelcode);
            this.preparedInsertCompleteStatement.setString(index++, buchungsblatt);
            this.preparedInsertCompleteStatement.setString(index++, product);
            this.preparedInsertCompleteStatement.setBoolean(index++, downloadOnly);
            this.preparedInsertCompleteStatement.setString(index++, email);
            this.preparedInsertCompleteStatement.setString(index++, filePath);
            this.preparedInsertCompleteStatement.setString(index++, origName);
            this.preparedInsertCompleteStatement.executeUpdate();
        }
    }

    public void updateStatus(String transid, int status) throws SQLException {
        if (this.isEnabled()) {
            FormSolutionBestellungSpecialLogger.getInstance().log("updating mysql entry for: " + transid);
            this.connect();
            int index = 1;
            this.preparedUpdateStatusStatement.setInt(index++, status);
            this.preparedUpdateStatusStatement.setString(index++, transid);
            this.preparedUpdateStatusStatement.executeUpdate();
        }
    }

    public void updatePruefungFreigabe(String schluessel, String transid, int status, String abschlussformular) throws SQLException {
        if (this.isEnabled()) {
            this.connect();
            int index = 1;
            this.preparedUpdatePruefungFreigabeStatement.setString(index++, schluessel);
            this.preparedUpdatePruefungFreigabeStatement.setInt(index++, status);
            this.preparedUpdatePruefungFreigabeStatement.setString(index++, abschlussformular);
            this.preparedUpdatePruefungFreigabeStatement.setString(index++, transid);
            this.preparedUpdatePruefungFreigabeStatement.executeUpdate();
        }
    }

    public void updatePruefungAblehnung(String schluessel, String transid, int status, String ablehnungsgrund) throws SQLException {
        if (this.isEnabled()) {
            this.connect();
            int index = 1;
            this.preparedUpdatePruefungAblehnungStatement.setString(index++, schluessel);
            this.preparedUpdatePruefungAblehnungStatement.setInt(index++, status);
            this.preparedUpdatePruefungAblehnungStatement.setString(index++, ablehnungsgrund);
            this.preparedUpdatePruefungAblehnungStatement.setString(index++, transid);
            this.preparedUpdatePruefungAblehnungStatement.executeUpdate();
        }
    }

    public void updateRequest(String transid, int status, String landparcelcode, String buchungsblattcode, String product, Boolean downloadOnly, String email) throws SQLException {
        if (this.isEnabled()) {
            this.connect();
            int index = 1;
            this.preparedUpdateInfoStatement.setInt(index++, status);
            this.preparedUpdateInfoStatement.setString(index++, landparcelcode);
            this.preparedUpdateInfoStatement.setString(index++, buchungsblattcode);
            this.preparedUpdateInfoStatement.setString(index++, product);
            this.preparedUpdateInfoStatement.setBoolean(index++, downloadOnly);
            this.preparedUpdateInfoStatement.setString(index++, email);
            this.preparedUpdateInfoStatement.setString(index++, transid);
            this.preparedUpdateInfoStatement.executeUpdate();
        }
    }

    public void updateProduct(String transid, String schluessel, int status, String filePath, String origName) throws SQLException {
        if (this.isEnabled()) {
            this.connect();
            int index = 1;
            this.preparedUpdateProductStatement.setString(index++, schluessel);
            this.preparedUpdateProductStatement.setInt(index++, status);
            this.preparedUpdateProductStatement.setString(index++, filePath);
            this.preparedUpdateProductStatement.setString(index++, origName);
            this.preparedUpdateProductStatement.setString(index++, transid);
            this.preparedUpdateProductStatement.executeUpdate();
        }
    }

    private ResultSet select(String transid) throws SQLException {
        this.connect();
        this.preparedSelectStatement.setString(1, transid);
        ResultSet resultSet = this.preparedSelectStatement.executeQuery();
        return resultSet;
    }

    public static FormSolutionsMySqlHelper getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public boolean isEnabled() {
        return "production".equalsIgnoreCase(DomainServerImpl.getServerProperties().getDeployEnv()) && !FormSolutionsProperties.getInstance().isMysqlDisabled();
    }

    private static final class LazyInitialiser {
        private static final FormSolutionsMySqlHelper INSTANCE = new FormSolutionsMySqlHelper();

        private LazyInitialiser() {
        }
    }
}

