/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.pointnumberreservation;

import de.cismet.cids.custom.utils.pointnumberreservation.PointNumberReservation;
import de.cismet.cids.custom.utils.pointnumberreservation.PointNumberReservationRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PointNumberReservationBeanParser {
    private static final transient Logger LOG = Logger.getLogger(PointNumberReservationBeanParser.class);

    private static String parseAuftragsnummer(Node rootNode) {
        NodeList childs = rootNode.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node currChild = childs.item(i);
            if (!currChild.getNodeName().equals("antragsnummer") && !currChild.getNodeName().equals("auftragsnummer")) continue;
            return currChild.getTextContent();
        }
        return null;
    }

    private static PointNumberWrapper parseAxReservierungNode(Node axReservierung) {
        PointNumberWrapper pointNumber = new PointNumberWrapper();
        Node gmlIdNode = axReservierung.getAttributes().getNamedItem("gml:id");
        if (gmlIdNode != null) {
            pointNumber.setUuid(gmlIdNode.getNodeValue());
        }
        NodeList childs = axReservierung.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node currChild = childs.item(i);
            if (currChild.getNodeName().equals("antragsnummer")) {
                pointNumber.setAntragsnummer(currChild.getTextContent());
                continue;
            }
            if (currChild.getNodeName().equals("ablaufDerReservierung")) {
                pointNumber.setAblaufdatum(currChild.getTextContent());
                continue;
            }
            if (currChild.getNodeName().equals("nummer")) {
                pointNumber.setPunktnummer(currChild.getTextContent());
                continue;
            }
            if (currChild.getNodeName().equals("lebenszeitintervall")) {
                Node lebenszeitNode = currChild.getChildNodes().item(1);
                Node beginntNode = lebenszeitNode.getChildNodes().item(1);
                pointNumber.setIntervallbeginn(beginntNode.getTextContent());
                continue;
            }
            if (!currChild.getNodeName().equals("vermessungsstelle")) continue;
            Node schluesselNode = currChild.getChildNodes().item(1);
            Node stelleNode = schluesselNode.getChildNodes().item(3);
            pointNumber.setStelle(stelleNode.getTextContent());
        }
        return pointNumber;
    }

    public static void parseFortfuehrungsergebnis() {
    }

    public static PointNumberReservationRequest parseReservierungsErgebnis(String resultString) {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            byte[] b;
            byte[] res = resultString.getBytes("UTF-8");
            if (resultString.startsWith("\ufeff")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"resultString starts with \\uFEFF which is a UTF-8 BOM. Removing first 3 bytes");
                }
                b = Arrays.copyOfRange(res, 3, res.length);
            } else {
                b = res;
            }
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(b);
            Document doc = dBuilder.parse(is);
            String anr = PointNumberReservationBeanParser.parseAuftragsnummer(doc.getLastChild());
            PointNumberReservationRequest requestBean = new PointNumberReservationRequest();
            requestBean.setRawResult(new String(b));
            requestBean.setAntragsnummer(anr);
            boolean wasSuccessFull = PointNumberReservationBeanParser.parseSuccessfull(doc.getLastChild());
            requestBean.setSuccessful(wasSuccessFull);
            if (wasSuccessFull) {
                ArrayList<PointNumberReservation> pointNumbers = new ArrayList<PointNumberReservation>();
                NodeList pointNumberNodes = doc.getElementsByTagName("reservierteNummern");
                for (int i = 0; i < pointNumberNodes.getLength(); ++i) {
                    Node resNumNode = pointNumberNodes.item(i);
                    PointNumberReservation pointNumber = new PointNumberReservation();
                    pointNumber.setPunktnummer(resNumNode.getTextContent());
                    pointNumbers.add(pointNumber);
                }
                requestBean.setPointNumbers(pointNumbers);
            } else {
                String protokoll = PointNumberReservationBeanParser.parseProtkoll(doc.getLastChild());
                List<String> errorMsg = PointNumberReservationBeanParser.parseProtokollErrorMessages(protokoll);
                requestBean.setProtokoll(protokoll);
                requestBean.setErrorMessages(errorMsg);
            }
            return requestBean;
        }
        catch (Exception ex) {
            LOG.error((Object)"Could not parse 3A server Result", (Throwable)ex);
            return null;
        }
    }

    public static Collection<PointNumberReservationRequest> parseBestandsdatenauszug(String resultString) {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        HashMap<String, PointNumberReservationRequest> requests = new HashMap<String, PointNumberReservationRequest>();
        try {
            byte[] b;
            byte[] res = resultString.getBytes("UTF-8");
            if (resultString.startsWith("\ufeff")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"resultString starts with \\uFEFF which is a UTF-8 BOM. Removing first 3 bytes");
                }
                b = Arrays.copyOfRange(res, 3, res.length);
            } else {
                b = res;
            }
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(b);
            Document doc = dBuilder.parse(is);
            NodeList axReservierungen = doc.getElementsByTagName("AX_Reservierung");
            for (int i = 0; i < axReservierungen.getLength(); ++i) {
                Node axReservierung = axReservierungen.item(i);
                PointNumberWrapper pointNumber = PointNumberReservationBeanParser.parseAxReservierungNode(axReservierung);
                if (pointNumber.getAntragsnummer() == null || pointNumber.getPunktnummer() == null) continue;
                if (!requests.containsKey(pointNumber.getAntragsnummer())) {
                    PointNumberReservationRequest request = new PointNumberReservationRequest();
                    request.setAntragsnummer(pointNumber.getAntragsnummer());
                    requests.put(pointNumber.getAntragsnummer(), request);
                }
                PointNumberReservation pnr = new PointNumberReservation();
                pnr.setAblaufDatum(pointNumber.getAblaufdatum());
                pnr.setPunktnummer(pointNumber.getPunktnummer());
                pnr.setIntervallbeginn(pointNumber.getIntervallbeginn());
                pnr.setVermessungsstelle(pointNumber.getStelle());
                pnr.setUuid(pointNumber.getUuid());
                ((PointNumberReservationRequest)requests.get(pointNumber.getAntragsnummer())).addPointNumberReservation(pnr);
            }
        }
        catch (ParserConfigurationException ex) {
            LOG.error((Object)"Could not parse 3A server Result", (Throwable)ex);
        }
        catch (SAXException ex) {
            LOG.error((Object)"Could not parse 3A server Result", (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.error((Object)"Could not parse 3A server Result", (Throwable)ex);
        }
        return requests.values();
    }

    private static boolean parseSuccessfull(Node rootNode) {
        NodeList childs = rootNode.getChildNodes();
        boolean b = false;
        for (int i = 0; i < childs.getLength(); ++i) {
            Node currChild = childs.item(i);
            if (!currChild.getNodeName().equals("erfolgreich")) continue;
            b = Boolean.parseBoolean(currChild.getTextContent());
            break;
        }
        return b;
    }

    private static String parseProtkoll(Node rootNode) {
        NodeList childs = rootNode.getChildNodes();
        boolean b = false;
        for (int i = 0; i < childs.getLength(); ++i) {
            Node currChild = childs.item(i);
            if (!currChild.getNodeName().equals("erlaeuterung")) continue;
            String protString = currChild.getTextContent();
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            try {
                byte[] bytes;
                byte[] res = protString.getBytes("UTF-8");
                if (protString.startsWith("\ufeff")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Protokoll starts with \\uFEFF which is a UTF-8 BOM. Removing first 3 bytes");
                    }
                    bytes = Arrays.copyOfRange(res, 3, res.length);
                } else {
                    bytes = res;
                }
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                Document doc = dBuilder.parse(is);
                OutputFormat format = new OutputFormat(doc, "UTF-8", true);
                StringWriter stringOut = new StringWriter();
                XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
                serial.serialize(doc);
                return stringOut.toString();
            }
            catch (ParserConfigurationException ex) {
                LOG.error((Object)"Could not parse 3A server Protokoll: ", (Throwable)ex);
                continue;
            }
            catch (SAXException ex) {
                LOG.error((Object)"Could not parse 3A server Protokoll: ", (Throwable)ex);
                continue;
            }
            catch (IOException ex) {
                LOG.error((Object)"Could not parse 3A server Protokoll: ", (Throwable)ex);
            }
        }
        return "";
    }

    private static List<String> parseProtokollErrorMessages(String protokoll) {
        ArrayList<String> errorMsg = new ArrayList<String>();
        try {
            ByteArrayInputStream result = new ByteArrayInputStream(protokoll.getBytes());
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(result);
            Node rootNode = doc.getLastChild();
            NodeList childs = rootNode.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node n = childs.item(i);
                if (!n.getNodeName().equals("Message")) continue;
                NodeList messageChilds = n.getChildNodes();
                for (int j = 0; j < messageChilds.getLength(); ++j) {
                    String messageLevel;
                    Node tmp = messageChilds.item(j);
                    if (!tmp.getNodeName().equals("MessageLevel") || !(messageLevel = tmp.getTextContent()).equals("Error")) continue;
                    String errorMessage = tmp.getNextSibling().getNextSibling().getTextContent();
                    errorMsg.add(errorMessage);
                }
            }
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return errorMsg;
    }

    private static final class PointNumberWrapper {
        private String antragsnummer;
        private String ablaufdatum;
        private String punktnummer;
        private String stelle;
        private String intervallbeginn;
        private String uuid;

        private PointNumberWrapper() {
        }

        public String getAntragsnummer() {
            return this.antragsnummer;
        }

        public void setAntragsnummer(String antragsnummer) {
            this.antragsnummer = antragsnummer;
        }

        public String getAblaufdatum() {
            return this.ablaufdatum;
        }

        public void setAblaufdatum(String ablaufdatum) {
            this.ablaufdatum = ablaufdatum;
        }

        public String getPunktnummer() {
            return this.punktnummer;
        }

        public void setPunktnummer(String punktnummer) {
            this.punktnummer = punktnummer;
        }

        public String getStelle() {
            return this.stelle;
        }

        public void setStelle(String stelle) {
            this.stelle = stelle;
        }

        public String getIntervallbeginn() {
            return this.intervallbeginn;
        }

        public void setIntervallbeginn(String intervallbeginn) {
            this.intervallbeginn = intervallbeginn;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }
    }
}

