/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.utils.BaumMeldungReportScriptlet;
import de.cismet.cids.custom.utils.StampedJasperReportServerAction;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.wunda_blau.search.server.BaumChildLightweightSearch;
import de.cismet.cids.server.actions.ServerActionHelper;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.io.ByteArrayInputStream;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class BaumGebietReportServerAction
extends StampedJasperReportServerAction
implements ConnectionContextStore {
    private static final String CHILD_TOSTRING_TEMPLATE = "%s";
    private static final String TABLE_MELDUNG = "baum_meldung";
    private static final String[] CHILD_TOSTRING_FIELDS = new String[]{"id"};
    private static final String FK_GEBIET = "fk_gebiet";
    public static final String TASK_NAME = "baumGebietReport";
    public static final String FIELD__BEZEICHNUNG = "name";
    public static final String FIELD__AZ = "aktenzeichen";
    public static final String FIELD__STRASSE_NAME = "fk_strasse.name";
    public static final String FIELD__WV = "erneut";
    public static final String FIELD__ADR_HNR = "fk_adresse.hausnummer";
    public static final String FIELD__BEMERKUNG = "bemerkung";
    public static final String FIELD__ID = "id";
    public static final String FIELD__GEOREFERENZ = "fk_geom";
    private final BaumChildLightweightSearch searchChild = new BaumChildLightweightSearch("%s", CHILD_TOSTRING_FIELDS, "baum_meldung", "fk_gebiet");

    protected JasperReport getJasperReport() throws Exception {
        return ServerResourcesLoader.getInstance().loadJasperReport(WundaBlauServerResources.BAUMGEBIET_JASPER.getValue());
    }

    public Object execute(Object o, ServerActionParameter ... params) {
        try {
            byte[] imageBytes = null;
            if (params != null) {
                for (ServerActionParameter sap : params) {
                    if (!sap.getKey().equals(Parameter.MAP_IMAGE_BYTES.toString())) continue;
                    imageBytes = (byte[])sap.getValue();
                }
            }
            MetaObjectNode gebietMon = (MetaObjectNode)o;
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("SUBREPORT_DIR", DomainServerImpl.getServerProperties().getServerResourcesBasePath() + "");
            parameters.put(FIELD__AZ, gebietMon.getObject().getBean().getProperty(FIELD__AZ).toString());
            parameters.put(FIELD__ID, gebietMon.getObject().getBean().getProperty(FIELD__ID).toString());
            parameters.put("bezeichnung", gebietMon.getObject().getBean().getProperty(FIELD__BEZEICHNUNG).toString());
            parameters.put("strasse", gebietMon.getObject().getBean().getProperty(FIELD__STRASSE_NAME).toString());
            parameters.put("hnr", this.getAttribute(gebietMon, FIELD__ADR_HNR));
            parameters.put(FIELD__BEMERKUNG, this.getAttribute(gebietMon, FIELD__BEMERKUNG));
            parameters.put("wiedervorlage", this.getDateAttribute(gebietMon, FIELD__WV));
            parameters.put("mon", gebietMon);
            if (imageBytes != null) {
                try (ByteArrayInputStream bis = new ByteArrayInputStream(imageBytes);){
                    parameters.put("MAP_IMAGE", ImageIO.read(bis));
                }
            }
            JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(Arrays.asList(this.getMetaService().getMetaObject(this.getUser(), gebietMon.getObjectId(), gebietMon.getClassId(), this.getConnectionContext()).getBean()));
            this.searchChild.setParentId(gebietMon.getObject().getBean().getPrimaryKeyValue());
            this.searchChild.setFkField(FK_GEBIET);
            this.searchChild.setTable(TABLE_MELDUNG);
            this.searchChild.setRepresentationFields(CHILD_TOSTRING_FIELDS);
            BaumMeldungReportScriptlet scriptlet = new BaumMeldungReportScriptlet(this.getMetaService(), this.getUser(), this.getConnectionContext());
            parameters.put("REPORT_SCRIPTLET", (Object)scriptlet);
            return ServerActionHelper.asyncByteArrayHelper((Object)this.generateReport(parameters, (JRDataSource)dataSource), (String)"BaumgebietReport.pdf");
        }
        catch (Exception ex) {
            LOG.error((Object)"Parameter f\u00fcr Gebiet-Report nicht erzeugt.", (Throwable)ex);
            return ex;
        }
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    private String getAttribute(MetaObjectNode mon, String attribute) {
        if (mon.getObject().getBean().getProperty(attribute) == null) {
            return "";
        }
        String result = (String)mon.getObject().getBean().getProperty(attribute);
        return result;
    }

    private String getDateAttribute(MetaObjectNode mon, String attribute) {
        if (mon.getObject().getBean().getProperty(attribute) == null) {
            return "";
        }
        SimpleDateFormat formatTag = new SimpleDateFormat("dd.MM.yy");
        Date datum = (Date)mon.getObject().getBean().getProperty(attribute);
        String result = formatTag.format(datum);
        return result;
    }

    public static enum Parameter {
        MAP_IMAGE_BYTES;

    }
}

