/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.butler.ButlerFormat;
import de.cismet.cids.custom.utils.butler.ButlerProduct;
import de.cismet.cids.custom.utils.butler.ButlerProductGenerator;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;

public class ButlerQueryAction
implements UserAwareServerAction {
    private User user;

    public Object execute(Object body, ServerActionParameter ... params) {
        METHOD_TYPE method = null;
        String orderId = null;
        String requestId = null;
        ButlerProduct product = null;
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        String box = null;
        boolean isEtrsBlattschnitt = false;
        boolean useWmps = false;
        for (ServerActionParameter sap : params) {
            String sapKey = sap.getKey();
            if (sapKey.equals(PARAMETER_TYPE.ORDER_ID.toString())) {
                orderId = (String)sap.getValue();
                continue;
            }
            if (sapKey.equals(PARAMETER_TYPE.BUTLER_PRODUCT.toString())) {
                product = (ButlerProduct)sap.getValue();
                continue;
            }
            if (sapKey.equals(PARAMETER_TYPE.MIN_X.toString())) {
                minX = (Double)sap.getValue();
                continue;
            }
            if (sapKey.equals(PARAMETER_TYPE.MIN_Y.toString())) {
                minY = (Double)sap.getValue();
                continue;
            }
            if (sapKey.equals(PARAMETER_TYPE.MAX_X.toString())) {
                maxX = (Double)sap.getValue();
                continue;
            }
            if (sapKey.equals(PARAMETER_TYPE.MAX_Y.toString())) {
                maxY = (Double)sap.getValue();
                continue;
            }
            if (sapKey.equals(PARAMETER_TYPE.METHOD.toString())) {
                method = (METHOD_TYPE)((Object)sap.getValue());
                continue;
            }
            if (sapKey.equals(PARAMETER_TYPE.REQUEST_ID.toString())) {
                requestId = (String)sap.getValue();
                continue;
            }
            if (sapKey.equals(PARAMETER_TYPE.IS_WMPS.toString())) {
                useWmps = (Boolean)sap.getValue();
                continue;
            }
            if (sapKey.equals(PARAMETER_TYPE.BOX_SIZE.toString())) {
                box = (String)sap.getValue();
                continue;
            }
            if (!sapKey.equals(PARAMETER_TYPE.ETRS_BLATTSCHNITT.toString())) continue;
            isEtrsBlattschnitt = (Boolean)sap.getValue();
        }
        if (method == METHOD_TYPE.ADD) {
            if (product != null && product.getKey() != null) {
                if (!useWmps) {
                    boolean isGeoTif = product.getFormat().getKey().equals("geotif");
                    if (isGeoTif) {
                        ButlerFormat f = product.getFormat();
                        f.setKey("tif");
                        product.setFormat(f);
                    }
                    return ButlerProductGenerator.getInstance().createButlerRequest(orderId, this.user, product, minX, minY, maxX, maxY, isGeoTif);
                }
                return ButlerProductGenerator.getInstance().createButler2Request(orderId, this.user, product, isEtrsBlattschnitt, box, minX, minY);
            }
        } else {
            if (method == METHOD_TYPE.GET_ALL) {
                return ButlerProductGenerator.getInstance().getAllOpenUserRequests(this.user);
            }
            if (method == METHOD_TYPE.CANCEL) {
                ButlerProductGenerator.getInstance().removeOrder(this.user, requestId);
            }
        }
        return null;
    }

    public String getTaskName() {
        return "butler1Query";
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public static enum PARAMETER_TYPE {
        IS_WMPS,
        REQUEST_ID,
        ORDER_ID,
        BUTLER_PRODUCT,
        MIN_X,
        MIN_Y,
        MAX_X,
        MAX_Y,
        METHOD,
        BOX_SIZE,
        ETRS_BLATTSCHNITT;

    }

    public static enum METHOD_TYPE {
        ADD,
        GET_ALL,
        CANCEL;

    }
}

