/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.utils.StampedJasperReportServerAction;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.utils.alkis.NivellementPunktReportBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionHelper;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class NivPReportServerAction
extends StampedJasperReportServerAction
implements ConnectionContextStore {
    public static final String TASK_NAME = "nivPReport";
    private static final String PARAMETER_JOBNUMBER = "JOBNUMBER";
    private static final String PARAMETER_PROJECTNAME = "PROJECTNAME";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    @Override
    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        Collection reportMons = null;
        String jobnumber = null;
        String projectname = null;
        try {
            if (params != null) {
                for (ServerActionParameter sap : params) {
                    if (sap.getKey().equals(Parameter.POINT_MONS.toString())) {
                        reportMons = (Collection)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.JOBNUMBER.toString())) {
                        jobnumber = (String)sap.getValue();
                        continue;
                    }
                    if (!sap.getKey().equals(Parameter.PROJECTNAME.toString())) continue;
                    projectname = (String)sap.getValue();
                }
            }
            if (reportMons != null) {
                ArrayList<CidsBean> cidsBeans = new ArrayList<CidsBean>(reportMons.size());
                for (MetaObjectNode reportMon : reportMons) {
                    CidsBean cidsBean = this.getMetaService().getMetaObject(this.getUser(), reportMon.getObjectId(), reportMon.getClassId(), this.getConnectionContext()).getBean();
                    cidsBeans.add(cidsBean);
                }
                ArrayList<NivellementPunktReportBean> reportBeans = new ArrayList<NivellementPunktReportBean>(reportMons.size());
                reportBeans.add(new NivellementPunktReportBean(cidsBeans));
                JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(reportBeans);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put(PARAMETER_JOBNUMBER, jobnumber);
                parameters.put(PARAMETER_PROJECTNAME, projectname);
                parameters.put("SUBREPORT_DIR", DomainServerImpl.getServerProperties().getServerResourcesBasePath() + "/");
                return ServerActionHelper.asyncByteArrayHelper((Object)this.generateReport(parameters, (JRDataSource)dataSource), (String)"NivPReport.pdf");
            }
            return null;
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return ex;
        }
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    protected JasperReport getJasperReport() throws Exception {
        return ServerResourcesLoader.getInstance().loadJasperReport(WundaBlauServerResources.NIVP_JASPER.getValue());
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum Parameter {
        POINT_MONS,
        JOBNUMBER,
        PROJECTNAME;

    }
}

