/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.utils.PotenzialflaechenProperties;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.DefaultServerAction;
import de.cismet.cids.server.actions.ServerActionHelper;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.utils.serverresources.PropertiesServerResource;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class PfReportDownloadAction
extends DefaultServerAction {
    private static final transient Logger LOG = Logger.getLogger(PfReportDownloadAction.class);
    public static final String TASK_NAME = "pfJasperDownload";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(Object body, ServerActionParameter ... params) {
        try {
            String fileName;
            MetaObjectNode mon = (MetaObjectNode)body;
            String reportFile = null;
            if (params != null) {
                for (ServerActionParameter sap : params) {
                    if (sap.getKey().equals(Parameter.MAINREPORT.toString())) {
                        mon = (MetaObjectNode)sap.getValue();
                        continue;
                    }
                    if (!sap.getKey().equals(Parameter.REPORT_FILE.toString())) continue;
                    reportFile = (String)sap.getValue();
                }
            }
            if (mon != null) {
                MetaObject mo = this.getMetaService().getMetaObject(this.getUser(), mon.getObjectId(), mon.getClassId(), this.getConnectionContext());
                CidsBean bean = mo.getBean();
                fileName = (String)bean.getProperty("link");
            } else {
                if (reportFile == null) return null;
                fileName = this.getProperties().getReportFile(reportFile);
            }
            try (FileInputStream inputStream = new FileInputStream(new File(DomainServerImpl.getServerProperties().getServerResourcesBasePath(), fileName.startsWith("/") ? fileName.substring(1) : fileName));){
                Object object = ServerActionHelper.asyncByteArrayHelper((Object)IOUtils.toByteArray((InputStream)inputStream), (String)"PfReport.pdf");
                return object;
            }
        }
        catch (Exception ex) {
            LOG.info((Object)"error while jasper file", (Throwable)ex);
            return ex;
        }
    }

    private PotenzialflaechenProperties getProperties() throws Exception {
        return (PotenzialflaechenProperties)ServerResourcesLoader.getInstance().get((PropertiesServerResource)WundaBlauServerResources.POTENZIALFLAECHEN_PROPERTIES.getValue());
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public static enum Parameter {
        MAINREPORT,
        REPORT_FILE;

    }
}

