/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.sql.PreparableStatement;
import de.cismet.cids.custom.wunda_blau.search.server.GazzResult;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class BPlanAPIGazeteerSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(BPlanAPIGazeteerSearch.class);
    private static final PreparableStatement QUERY = new PreparableStatement("select * from bplanGazeteerAPISearch(?)", new int[]{12});
    private static final String DOMAIN = "WUNDA_BLAU";
    private final SearchInfo searchInfo;
    private String input;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public BPlanAPIGazeteerSearch() {
        this.searchInfo = new SearchInfo();
        this.searchInfo.setKey(((Object)((Object)this)).getClass().getSimpleName());
        this.searchInfo.setName(((Object)((Object)this)).getClass().getSimpleName());
        this.searchInfo.setDescription("BPlan Gazeteer Search to use in Geoportal 3");
        LinkedList<SearchParameterInfo> parameterDescription = new LinkedList<SearchParameterInfo>();
        this.searchInfo.setParameterDescription(parameterDescription);
        SearchParameterInfo wktStringParameterInfo = new SearchParameterInfo();
        wktStringParameterInfo.setKey("input");
        wktStringParameterInfo.setType(Type.STRING);
        parameterDescription.add(wktStringParameterInfo);
        this.searchInfo.setParameterDescription(parameterDescription);
        SearchParameterInfo resultParameterInfo = new SearchParameterInfo();
        resultParameterInfo.setKey("return");
        resultParameterInfo.setArray(true);
        resultParameterInfo.setType(Type.JAVA_CLASS);
        this.searchInfo.setResultDescription(resultParameterInfo);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        try {
            MetaService metaService = (MetaService)this.getActiveLocalServers().get(DOMAIN);
            if (metaService != null) {
                QUERY.setObjects(new Object[]{this.input});
                ArrayList results = metaService.performCustomSearch(QUERY, this.getConnectionContext());
                ArrayList<GazzResult> ret = new ArrayList<GazzResult>(results.size());
                for (ArrayList row : results) {
                    String s = (String)row.get(0);
                    String glyph = (String)row.get(1);
                    double x = ((BigDecimal)row.get(2)).doubleValue();
                    double y = ((BigDecimal)row.get(3)).doubleValue();
                    String more = (String)row.get(7);
                    ret.add(new GazzResult(s, glyph, x, y, more));
                }
                return ret;
            }
            LOG.error((Object)"active local server not found");
            return null;
        }
        catch (Exception ex) {
            throw new SearchException("error while loading gazetteer result objects", (Throwable)ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }
}

