/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class BaumMeldungSearch
extends AbstractCidsServerSearch
implements MetaObjectNodeServerSearch {
    private static final transient Logger LOG = Logger.getLogger(BaumMeldungSearch.class);
    public static final String TABLE_NAME = "baum_gebiet";
    public static final String TABLE_NAME_MELDUNG = "baum_meldung";
    public static final String FIELD__GEBIET_NAME = "name";
    public static final String FIELD__MELDUNG_ID = "id";
    public static final String FIELD__GEBIET_AZ = "aktenzeichen";
    public static final String FIELD__MELDUNG_DATUM = "datum";
    public static final String FIELD__MELDUNG_FK = "fk_gebiet";
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String QUERY_TEMPLATE = "SELECT   (SELECT c.id FROM cs_class c WHERE table_name ILIKE 'baum_meldung') AS class_id, baum_meldung.id, baum_gebiet.aktenzeichen || '---' || to_char(baum_meldung.datum, 'DD.MM.YY') AS aktenzeichen , baum_gebiet.name, '[' || baum_meldung.datum || ']' AS datum FROM baum_meldung LEFT JOIN baum_gebiet ON baum_meldung.fk_gebiet = baum_gebiet.id ORDER BY baum_gebiet.aktenzeichen, baum_meldung.datum";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private Integer ortsterminId;
    private Integer ortsterminFKMeldung;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            ArrayList leftJoins = new ArrayList();
            ArrayList<String> wheres = new ArrayList<String>();
            if (this.getOrtsterminId() != null) {
                wheres.add(String.format("baum_meldung.id = %d", this.getOrtsterminFKMeldung()));
            }
            String leftJoin = !leftJoins.isEmpty() ? String.format("LEFT JOIN %s", String.join((CharSequence)" LEFT JOIN ", leftJoins)) : "";
            String where = !wheres.isEmpty() ? String.format("WHERE %s", String.join((CharSequence)" AND ", wheres)) : "";
            String query = String.format(QUERY_TEMPLATE, leftJoin, where);
            LOG.info((Object)query);
            MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
            ArrayList<MetaObjectNode> mons = new ArrayList<MetaObjectNode>();
            ArrayList resultList = ms.performCustomSearch(query, this.getConnectionContext());
            for (ArrayList al : resultList) {
                int cid = (Integer)al.get(0);
                int oid = (Integer)al.get(1);
                String name = String.valueOf(al.get(2));
                MetaObjectNode mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, name, null, null);
                mons.add(mon);
            }
            return mons;
        }
        catch (RemoteException ex) {
            LOG.error((Object)"error while searching for baum_meldung", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setOrtsterminId(Integer ortsterminId) {
        this.ortsterminId = ortsterminId;
    }

    public Integer getOrtsterminId() {
        return this.ortsterminId;
    }

    public void setOrtsterminFKMeldung(Integer ortsterminFKMeldung) {
        this.ortsterminFKMeldung = ortsterminFKMeldung;
    }

    public Integer getOrtsterminFKMeldung() {
        return this.ortsterminFKMeldung;
    }
}

