/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wunda_blau.search.server.RestApiMonGeometrySearch;
import de.cismet.cids.custom.wunda_blau.search.server.RestApiMonSearch;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;

public class KstGeometryMonSearch
extends RestApiMonGeometrySearch {
    private static final transient Logger LOG = Logger.getLogger(KstGeometryMonSearch.class);
    private SearchFor searchFor = null;

    public KstGeometryMonSearch(SearchFor searchFor) {
        this(searchFor, null, null);
    }

    public KstGeometryMonSearch(SearchFor searchFor, Geometry geometry) {
        this(searchFor, geometry, null);
    }

    public KstGeometryMonSearch(SearchFor searchFor, Double buffer) {
        this(searchFor, null, buffer);
    }

    public KstGeometryMonSearch(SearchFor searchFor, Geometry geometry, Double buffer) {
        this.setGeometry(geometry);
        this.setBuffer(buffer);
        this.searchFor = searchFor;
        this.setSearchInfo(new SearchInfo(this.getClass().getName(), this.getClass().getSimpleName(), "Builtin Legacy Search to delegate the operation KstSearch to the cids Pure REST Search API.", Arrays.asList(new SearchParameterInfo[]{new RestApiMonSearch.MySearchParameterInfo("searchFor", Type.STRING), new RestApiMonSearch.MySearchParameterInfo("geom", Type.UNDEFINED)}), (SearchParameterInfo)new RestApiMonSearch.MySearchParameterInfo("return", Type.ENTITY_REFERENCE, true)));
    }

    private KstGeometryMonSearch() {
        this(null);
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            String kst = null;
            String nr = null;
            switch (this.searchFor) {
                case BEZIRK: {
                    kst = "kst_stadtbezirk";
                    nr = "stadtbezirk_nr";
                    break;
                }
                case QUARTIER: {
                    kst = "kst_quartier";
                    nr = "quartier_nr";
                    break;
                }
            }
            Geometry geom = this.getGeometry();
            String geomCondition = this.getGeomCondition();
            Geometry geometry = this.getGeometry();
            String area = geometry != null ? String.format("st_area(st_intersection(geom.geo_field, st_GeometryFromText('%1$s')))", PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)geometry)) : "st_area(geom.geo_field)";
            String query = String.format("SELECT   (SELECT id FROM cs_class WHERE table_name ILIKE '%1$s') AS class_id,   object_id,   min(object_name),   sum(area),   min(nummer) FROM (    SELECT     %2$s AS area,     kst.id AS object_id,     kst.name AS object_name,     kst.%3$s AS nummer   FROM %1$s AS kst   %4$s  %5$s) AS sub GROUP BY object_id ORDER BY sum(area) DESC;", kst, area, nr, geomCondition != null ? "LEFT JOIN geom ON kst.georeferenz = geom.id " : " ", geomCondition != null ? "WHERE " + geomCondition : " ");
            if (query != null) {
                MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
                ArrayList resultList = ms.performCustomSearch(query, this.getConnectionContext());
                for (ArrayList al : resultList) {
                    int cid = (Integer)al.get(0);
                    int oid = (Integer)al.get(1);
                    String name = (String)al.get(2);
                    MetaObjectNode mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, name, null, null);
                    result.add(mon);
                }
            }
            return result;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while searching for kst object", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public SearchFor getSearchFor() {
        return this.searchFor;
    }

    public void setSearchFor(SearchFor searchFor) {
        this.searchFor = searchFor;
    }

    public static enum SearchFor {
        BEZIRK,
        QUARTIER;

    }
}

