/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class MauerNummerSearch
extends AbstractCidsServerSearch
implements ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(MauerNummerSearch.class);
    private final String mauerNummer;
    private final String QUERY = "SELECT id, mauer_nummer FROM mauer WHERE mauer_nummer = '%1$s'";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public MauerNummerSearch(String mauerNummer) {
        this.mauerNummer = mauerNummer;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (ms != null) {
            try {
                String query = String.format("SELECT id, mauer_nummer FROM mauer WHERE mauer_nummer = '%1$s'", this.mauerNummer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("query: " + query));
                }
                ArrayList lists = ms.performCustomSearch(query, this.getConnectionContext());
                return lists;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

