/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.wunda_blau.search.server.SearchProperties;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MetaObjectNodesStadtbildSerieSearchStatement
extends AbstractCidsServerSearch
implements MetaObjectNodeServerSearch,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(MetaObjectNodesStadtbildSerieSearchStatement.class);
    private static final String DOMAIN = "WUNDA_BLAU";
    private static final String INTERSECTS_BUFFER = SearchProperties.getInstance().getIntersectsBuffer();
    private Geometry geometryToSearchFor;
    private ArrayList<Bildtyp> bildtypen = new ArrayList();
    private ArrayList<Integer> suchwoerterIDs = new ArrayList();
    private ArrayList<Integer> nutzungseinschraenkungIDs = new ArrayList();
    private Interval interval;
    private Date from;
    private Date till;
    private String streetID;
    private String ortID;
    private String hausnummer;
    private String imageNumberRule;
    private StringBuilder query;
    private final SimpleDateFormat postgresDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private ArrayList<ArrayList> resultset;
    private boolean hasAllSuchworte = true;
    private boolean preparationExecution = false;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public MetaObjectNodesStadtbildSerieSearchStatement(User user) {
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection prepareResultSetAndReturnItsSize() {
        MetaService metaService = (MetaService)this.getActiveLocalServers().get(DOMAIN);
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (metaService != null) {
            try {
                this.generateQuery();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The used query is: " + this.query.toString()));
                }
                this.resultset = metaService.performCustomSearch(this.query.toString(), this.getConnectionContext());
                result.add(this.resultset.size());
                return result;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        result.clear();
        result.add(0);
        return result;
    }

    public Collection<MetaObjectNode> performServerSearch() throws SearchException {
        if (this.isPreparationExecution()) {
            return this.prepareResultSetAndReturnItsSize();
        }
        MetaService metaService = (MetaService)this.getActiveLocalServers().get(DOMAIN);
        if (metaService != null) {
            try {
                if (this.query == null) {
                    this.generateQuery();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The used query is: " + this.query.toString()));
                }
                if (this.resultset == null) {
                    this.resultset = metaService.performCustomSearch(this.query.toString(), this.getConnectionContext());
                }
                ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
                for (ArrayList stadtbildserie : this.resultset) {
                    int classID = (Integer)stadtbildserie.get(0);
                    int objectID = (Integer)stadtbildserie.get(1);
                    String name = (String)stadtbildserie.get(2);
                    MetaObjectNode node = new MetaObjectNode(DOMAIN, objectID, classID, name, null, null);
                    result.add(node);
                }
                return result;
            }
            catch (RemoteException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            LOG.error((Object)"active local server not found");
        }
        return null;
    }

    public String generateQuery() {
        this.query = new StringBuilder();
        this.query.append("SELECT DISTINCT (SELECT id                 FROM    cs_class                 WHERE   name ilike 'sb_stadtbildserie'                 ), sbs.id, (select bildnummer from sb_stadtbild sb where sb.id = sbs.vorschaubild) ");
        this.query.append(" FROM sb_stadtbildserie sbs");
        if (StringUtils.isNotBlank((String)this.imageNumberRule) || this.interval != null) {
            this.query.append(" join sb_serie_bild_array as arr ");
            this.query.append(" on sbs.id = arr.sb_stadtbildserie_reference ");
            this.query.append(" JOIN sb_stadtbild AS sb ON sb.id = arr.stadtbild ");
        }
        if (this.geometryToSearchFor != null) {
            this.query.append(" join geom g ON sbs.geom = g.id ");
        }
        this.query.append(" WHERE ");
        this.query.append(" TRUE ");
        this.appendBildtyp();
        this.appendSuchworte();
        this.appendDates();
        this.appendStreetID();
        this.appendNutzungseinschraenkungIDs();
        this.appendOrtID();
        this.appendHausnummer();
        this.appendImageNumberRule();
        this.appendInterval();
        this.appendGeometry();
        return this.query.toString();
    }

    private void appendBildtyp() {
        if (!this.bildtypen.isEmpty()) {
            StringBuilder bildtypListString = new StringBuilder(" and sbs.bildtyp in (");
            for (Bildtyp typ : this.bildtypen) {
                bildtypListString.append(String.valueOf(typ.getId()));
                bildtypListString.append(",");
            }
            bildtypListString.deleteCharAt(bildtypListString.length() - 1);
            bildtypListString.append(")");
            this.query.append(bildtypListString.toString());
        }
    }

    private void appendSuchworte() {
        if (!this.suchwoerterIDs.isEmpty()) {
            this.query.append(" and sbs.id IN (");
            String subquery = "select sb_stadtbild_reference from sb_stadtbild_suchwort_array b where b.sb_suchwort = " + this.suchwoerterIDs.get(0);
            this.query.append(subquery);
            for (int i = 1; i < this.suchwoerterIDs.size(); ++i) {
                if (this.hasAllSuchworte) {
                    this.query.append(" INTERSECT ");
                } else {
                    this.query.append(" UNION ");
                }
                subquery = "select sb_stadtbild_reference from sb_stadtbild_suchwort_array b where b.sb_suchwort = " + this.suchwoerterIDs.get(i);
                this.query.append(subquery);
            }
            this.query.append(" ) ");
        }
    }

    private void appendNutzungseinschraenkungIDs() {
        if (this.nutzungseinschraenkungIDs != null && !this.nutzungseinschraenkungIDs.isEmpty()) {
            this.query.append(" and sbs.nutzungseinschraenkung IN (").append(StringUtils.join(this.nutzungseinschraenkungIDs, (char)',')).append(") ");
        } else {
            this.query.append(" and sbs.nutzungseinschraenkung IS NULL ");
        }
    }

    private void appendDates() {
        if (this.from != null || this.till != null) {
            if (this.till == null) {
                this.query.append(" and date_trunc('day',aufnahmedatum) >= '");
                this.query.append(this.postgresDateFormat.format(this.from));
                this.query.append("' ");
            } else if (this.from == null) {
                this.query.append(" and date_trunc('day',aufnahmedatum) <= '");
                this.query.append(this.postgresDateFormat.format(this.till));
                this.query.append("' ");
            } else if (this.postgresDateFormat.format(this.till).equals(this.postgresDateFormat.format(this.from))) {
                this.query.append(" and date_trunc('day',aufnahmedatum) = '");
                this.query.append(this.postgresDateFormat.format(this.from));
                this.query.append("' ");
            } else {
                this.query.append(" and date_trunc('day',aufnahmedatum) >= '");
                this.query.append(this.postgresDateFormat.format(this.from));
                this.query.append("' ");
                this.query.append(" and date_trunc('day',aufnahmedatum) <= '");
                this.query.append(this.postgresDateFormat.format(this.till));
                this.query.append("' ");
            }
        }
    }

    private void appendStreetID() {
        if (StringUtils.isNotBlank((String)this.streetID)) {
            this.query.append(" and sbs.strasse = ").append(this.streetID).append(" ");
        }
    }

    private void appendOrtID() {
        if (StringUtils.isNotBlank((String)this.ortID)) {
            this.query.append(" and sbs.ort = ").append(this.ortID).append(" ");
        }
    }

    private void appendHausnummer() {
        if (StringUtils.isNotBlank((String)this.hausnummer)) {
            this.query.append("and sbs.hausnummer ilike '").append(this.hausnummer).append("' ");
        }
    }

    private void appendImageNumberRule() {
        if (StringUtils.isNotBlank((String)this.imageNumberRule)) {
            String spaceSeparatedNumbers = this.imageNumberRule.trim().replaceAll("(\\s|;|,)+", " ");
            String quotedNumbers = "'" + spaceSeparatedNumbers.trim().replaceAll(" ", "' '").trim() + "'";
            Object[] numbers = quotedNumbers.split(" ");
            String sqlArray = "array[" + MetaObjectNodesStadtbildSerieSearchStatement.implode(numbers, ", ") + "]";
            this.query.append(" and sb.bildnummer ilike any (").append(sqlArray).append(") ");
        }
    }

    public static String implode(Object[] stringArray, String delimiter) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(stringArray[0]);
        for (int index = 1; index < stringArray.length; ++index) {
            sb.append(delimiter);
            sb.append(stringArray[index]);
        }
        return sb.toString();
    }

    private void appendInterval() {
        if (this.interval != null) {
            String logicalConnective = " and ";
            if (this.interval.intervalStart != null && this.interval.intervalEnd != null) {
                String whereStatement;
                String imageNrFrom = this.interval.intervalStart;
                String imageNrTo = this.interval.intervalEnd;
                if (Character.isLetter(imageNrFrom.charAt(0))) {
                    char firstLetter = imageNrFrom.charAt(0);
                    imageNrFrom = imageNrFrom.substring(1);
                    imageNrTo = imageNrTo.substring(1);
                    int length = imageNrFrom.length();
                    whereStatement = String.format(" and sb.bildnummer ~ '^%4$s\\\\d{%1$d}[a-z]?$' and %2$s <= substring(sb.bildnummer,2,%1$d)::bigint and substring(sb.bildnummer,2,%1$d)::bigint <= %3$s ", length, imageNrFrom, imageNrTo, Character.valueOf(firstLetter));
                } else {
                    int length = imageNrFrom.length();
                    whereStatement = String.format(" and sb.bildnummer ~ '^\\\\d{%1$d}[a-z]?$' and %2$s <= substring(sb.bildnummer,1,%1$d)::bigint and substring(sb.bildnummer,1,%1$d)::bigint <= %3$s ", length, imageNrFrom, imageNrTo);
                }
                this.query.append(whereStatement);
                logicalConnective = " or ";
            }
            if (this.interval.additionalExactMatches != null && !this.interval.additionalExactMatches.isEmpty()) {
                this.query.append(logicalConnective);
                this.query.append(" sb.bildnummer IN ('").append(StringUtils.join((Collection)this.interval.additionalExactMatches, (String)"','")).append("') ");
            }
        }
    }

    private void appendGeometry() {
        if (this.geometryToSearchFor != null) {
            String geostring = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)this.geometryToSearchFor);
            this.query.append("and g.geo_field && st_GeometryFromText('").append(geostring).append("')");
            if (this.geometryToSearchFor instanceof Polygon || this.geometryToSearchFor instanceof MultiPolygon) {
                this.query.append(" and st_intersects(st_buffer(geo_field, " + INTERSECTS_BUFFER + "),st_buffer(st_GeometryFromText('").append(geostring).append("'), " + INTERSECTS_BUFFER + "))");
            } else {
                this.query.append(" and st_intersects(st_buffer(geo_field, " + INTERSECTS_BUFFER + "),st_GeometryFromText('").append(geostring).append("'))");
            }
        }
    }

    public ArrayList<Bildtyp> getBildtypen() {
        return this.bildtypen;
    }

    public void setBildtypen(ArrayList<Bildtyp> bildtypen) {
        this.bildtypen = bildtypen;
    }

    public ArrayList<Integer> getSuchwoerterIDs() {
        return this.suchwoerterIDs;
    }

    public void setSuchwoerterIDs(ArrayList<Integer> suchwoerterIDs) {
        this.suchwoerterIDs = suchwoerterIDs;
    }

    public Date getFrom() {
        return this.from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public Date getTill() {
        return this.till;
    }

    public void setTill(Date till) {
        this.till = till;
    }

    public String getStreetID() {
        return this.streetID;
    }

    public void setStreetID(String streetID) {
        this.streetID = streetID;
    }

    public String getOrtID() {
        return this.ortID;
    }

    public void setOrtID(String ortID) {
        this.ortID = ortID;
    }

    public String getHausnummer() {
        return this.hausnummer;
    }

    public void setHausnummer(String hausnummer) {
        this.hausnummer = hausnummer;
    }

    public String getSingleImageNumber() {
        return this.imageNumberRule;
    }

    public void setImageNumberRule(String imageNumberRule) {
        this.imageNumberRule = imageNumberRule;
    }

    public boolean isPreparationExecution() {
        return this.preparationExecution;
    }

    public void setPreparationExecution(boolean preparationExecution) {
        this.preparationExecution = preparationExecution;
    }

    public void setGeometryToSearchFor(Geometry geometryToSearchFor) {
        this.geometryToSearchFor = geometryToSearchFor;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public void setInterval(Interval interval) {
        this.interval = interval;
    }

    public boolean isHasAllSuchworte() {
        return this.hasAllSuchworte;
    }

    public void setHasAllSuchworte(boolean hasAllSuchworte) {
        this.hasAllSuchworte = hasAllSuchworte;
    }

    public void setNutzungseinschraenkungIDs(ArrayList<Integer> nutzungseinschraenkungIDs) {
        this.nutzungseinschraenkungIDs = nutzungseinschraenkungIDs;
    }

    public ArrayList<Integer> getNutzungseinschraenkungIDs() {
        return this.nutzungseinschraenkungIDs;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static class Interval
    implements Serializable {
        private final String intervalStart;
        private final String intervalEnd;
        private final ArrayList<String> additionalExactMatches;

        public Interval(String intervalStart, String intervalEnd) {
            this(intervalStart, intervalEnd, null);
        }

        public Interval(String intervalStart, String intervalEnd, ArrayList<String> additionalExactMatches) {
            this.intervalStart = intervalStart;
            this.intervalEnd = intervalEnd;
            this.additionalExactMatches = additionalExactMatches;
        }

        public String getIntervalStart() {
            return this.intervalStart;
        }

        public String getIntervalEnd() {
            return this.intervalEnd;
        }

        public ArrayList<String> getAdditionalExactMatches() {
            return this.additionalExactMatches;
        }

        public int hashCode() {
            int hash = 3;
            hash = 41 * hash + (this.intervalStart != null ? this.intervalStart.hashCode() : 0);
            hash = 41 * hash + (this.intervalEnd != null ? this.intervalEnd.hashCode() : 0);
            hash = 41 * hash + (this.additionalExactMatches != null ? this.additionalExactMatches.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Interval other = (Interval)obj;
            if (this.intervalStart == null ? other.intervalStart != null : !this.intervalStart.equals(other.intervalStart)) {
                return false;
            }
            if (this.intervalEnd == null ? other.intervalEnd != null : !this.intervalEnd.equals(other.intervalEnd)) {
                return false;
            }
            return this.additionalExactMatches == other.additionalExactMatches || this.additionalExactMatches != null && this.additionalExactMatches.equals(other.additionalExactMatches);
        }
    }

    public static enum Bildtyp {
        LUFTSCHRAEG(0),
        LUFTSENK(1),
        BODENNAH(2),
        REIHENSCHRAEG(3);

        private final int id;

        private Bildtyp(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

