/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.cidsx.server.search.builtin.legacy.LightweightMetaObjectsSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;

public class TreppeMaterialArtLightweightSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch,
LightweightMetaObjectsSearch,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(TreppeMaterialArtLightweightSearch.class);
    private static final String TABLE__TREPPE_TREPPENLAUF_MATERIAL_ART = "treppe_treppenlauf_material_art";
    private static final String TABLE__TREPPE_PODEST_MATERIAL_ART = "treppe_podest_material_art";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final SearchInfo searchInfo = new SearchInfo(((Object)((Object)this)).getClass().getName(), ((Object)((Object)this)).getClass().getSimpleName(), "Builtin Legacy Search to delegate the operation getLightweightMetaObjectsByQuery to the cids Pure REST Search API.", Arrays.asList(new SearchParameterInfo[]{new MySearchParameterInfo("materialId", Type.INTEGER), new MySearchParameterInfo("typId", Type.INTEGER), new MySearchParameterInfo("searchFor", Type.UNDEFINED), new MySearchParameterInfo("representationPattern", Type.STRING, true), new MySearchParameterInfo("representationFields", Type.STRING, true)}), (SearchParameterInfo)new MySearchParameterInfo("return", Type.ENTITY_REFERENCE, true));
    private SearchFor searchFor;
    private Integer materialId;
    private Integer typId;
    private String representationPattern;
    private String[] representationFields;

    public TreppeMaterialArtLightweightSearch() {
    }

    public TreppeMaterialArtLightweightSearch(SearchFor searchFor, String representationPattern, String[] representationFields) {
        this();
        this.setSearchFor(searchFor);
        this.setRepresentationPattern(representationPattern);
        this.setRepresentationFields(representationFields);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        String table;
        SearchFor searchFor = this.getSearchFor();
        Integer materialId = this.getMaterialId();
        Integer typId = this.getTypId();
        if (searchFor == null) {
            throw new SearchException("searchFor has to be set");
        }
        MetaService metaService = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (metaService == null) {
            String message = "Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'";
            LOG.error((Object)"Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'");
            throw new SearchException("Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'");
        }
        ArrayList<String> conditions = new ArrayList<String>();
        if (materialId != null) {
            conditions.add(String.format("material = %d", materialId));
        }
        if (typId != null) {
            conditions.add(String.format("typ = %d", typId));
        }
        switch (searchFor) {
            case TREPPENLAUF: {
                table = TABLE__TREPPE_TREPPENLAUF_MATERIAL_ART;
                break;
            }
            case PODEST: {
                table = TABLE__TREPPE_PODEST_MATERIAL_ART;
                break;
            }
            default: {
                throw new SearchException("searchFor has to be set");
            }
        }
        String query = "SELECT id, name FROM " + table + (conditions.isEmpty() ? "" : " wHERE " + String.join((CharSequence)" AND ", conditions));
        try {
            MetaClass mc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)table, (ConnectionContext)this.getConnectionContext());
            if (this.getRepresentationPattern() != null) {
                return Arrays.asList(metaService.getLightweightMetaObjectsByQuery(mc.getID(), this.getUser(), query, this.getRepresentationFields(), this.getRepresentationPattern()));
            }
            return Arrays.asList(metaService.getLightweightMetaObjectsByQuery(mc.getID(), this.getUser(), query, this.getRepresentationFields()));
        }
        catch (Exception ex) {
            throw new SearchException("error while loading lwmos", (Throwable)ex);
        }
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public SearchFor getSearchFor() {
        return this.searchFor;
    }

    public void setSearchFor(SearchFor searchFor) {
        this.searchFor = searchFor;
    }

    public Integer getMaterialId() {
        return this.materialId;
    }

    public void setMaterialId(Integer materialId) {
        this.materialId = materialId;
    }

    public Integer getTypId() {
        return this.typId;
    }

    public void setTypId(Integer typId) {
        this.typId = typId;
    }

    public String getRepresentationPattern() {
        return this.representationPattern;
    }

    public void setRepresentationPattern(String representationPattern) {
        this.representationPattern = representationPattern;
    }

    public String[] getRepresentationFields() {
        return this.representationFields;
    }

    public void setRepresentationFields(String[] representationFields) {
        this.representationFields = representationFields;
    }

    private class MySearchParameterInfo
    extends SearchParameterInfo {
        private MySearchParameterInfo(String key, Type type) {
            this(key, type, (Boolean)null);
        }

        private MySearchParameterInfo(String key, Type type, Boolean array) {
            super.setKey(key);
            super.setType(type);
            if (array != null) {
                super.setArray(array.booleanValue());
            }
        }
    }

    public static enum SearchFor {
        TREPPENLAUF,
        PODEST;

    }
}

