/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.deletionprovider;

import Sirius.server.localserver.object.AbstractCustomDeletionProvider;
import Sirius.server.localserver.object.DeletionProviderClientException;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BaumAnsprechpartnerDeletionProvider
extends AbstractCustomDeletionProvider {
    private static final Logger LOG = Logger.getLogger(BaumAnsprechpartnerDeletionProvider.class);
    private static final String TABLE_NAME = "baum_ansprechpartner";
    private static final String FIELD__ID = "id";
    private static final String FIELD__FK = "fk_ansprechpartner";
    private static final String TABLE_NAME_SEARCH_OT = "baum_ortstermin_ansprechpartner";
    private static final String TABLE_NAME_SEARCH_M = "baum_meldung_ansprechpartner";
    private static final String DELETE_TEXT_OT = "Dieser Ansprechpartner kann nicht gel\u00f6scht werden, da dieser beim Ortstermin verwendet wird.";
    private static final String DELETE_TEXT_M = "Dieser Ansprechpartner/Melder kann nicht gel\u00f6scht werden, da dieser bei der Meldung verwendet wird.";
    private String deleteText = "Dieser Ansprechpartner kann nicht gel\u00f6scht werden, da dieser verwendet wird.";

    public String getTableName() {
        return TABLE_NAME;
    }

    public boolean isMatching(User user, MetaObject metaObject) {
        if (!super.isMatching(user, metaObject)) {
            return false;
        }
        CidsBean ansprechpartnerBean = metaObject.getBean();
        Integer ansprechpartner_id = (Integer)ansprechpartnerBean.getProperty(FIELD__ID);
        String queryApInOt = String.format("SELECT * FROM %s WHERE %s = %d;", TABLE_NAME_SEARCH_OT, FIELD__FK, ansprechpartner_id);
        String queryApInM = String.format("SELECT * FROM %s WHERE %s = %d;", TABLE_NAME_SEARCH_M, FIELD__FK, ansprechpartner_id);
        try {
            ArrayList artArrayM = this.getMetaService().performCustomSearch(queryApInM, this.getConnectionContext());
            if (!artArrayM.isEmpty()) {
                this.deleteText = DELETE_TEXT_M;
                return true;
            }
            ArrayList artArrayOt = this.getMetaService().performCustomSearch(queryApInOt, this.getConnectionContext());
            if (!artArrayOt.isEmpty()) {
                this.deleteText = DELETE_TEXT_OT;
                return true;
            }
        }
        catch (RemoteException ex) {
            LOG.error((Object)"Cannot delete Ap object", (Throwable)ex);
        }
        return false;
    }

    public boolean customDeleteMetaObject(User user, MetaObject metaObject) throws Exception {
        throw new DeletionProviderClientException(this.deleteText);
    }

    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

