/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.permissions.wunda_blau;

import Sirius.server.middleware.interfaces.domainserver.DomainServerCallServerService;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import Sirius.server.newuser.UserGroup;
import de.cismet.cids.dynamics.AbstractCustomBeanPermissionProvider;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.connectioncontext.ConnectionContext;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public abstract class AbstractObjectPermissionProvider
extends AbstractCustomBeanPermissionProvider {
    private static final String CLASSNAME__OBJECTPERMISSIONS = "cs_objectpermissions";
    private static final String PROPERTY__READ = "read";
    private static final String PROPERTY__WRITE = "write";
    private static final String QUERY_TEMPLATE = "SELECT (SELECT id from cs_class WHERE table_name ILIKE '%1$s'), id FROM %1$s WHERE class_id = %2$d AND (object_id IS NULL OR object_id = %3$d) AND (user_name LIKE %4$s OR group_name = ANY(VALUES %5$s)) AND (ts_start IS NULL OR ts_start < %6$s) AND (ts_end IS NULL OR ts_end > %6$s);";

    public boolean getCustomReadPermissionDecisionforUser(User user, ConnectionContext connectionContext) {
        CidsBean cidsBean = this.getCidsBean();
        if (cidsBean == null || user == null) {
            return false;
        }
        Timestamp now = new Timestamp(new Date().getTime());
        Collection<CidsBean> permissionBeans = AbstractObjectPermissionProvider.getObjectPermissionBeans(user, cidsBean, now, connectionContext);
        if (permissionBeans != null) {
            for (CidsBean permissionBean : permissionBeans) {
                if (!AbstractObjectPermissionProvider.checkPermission(permissionBean, user, PermissionType.READ)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean getCustomWritePermissionDecisionforUser(User user, ConnectionContext connectionContext) {
        CidsBean cidsBean = this.getCidsBean();
        if (cidsBean == null || user == null) {
            return false;
        }
        Timestamp now = new Timestamp(new Date().getTime());
        Collection<CidsBean> permissionBeans = AbstractObjectPermissionProvider.getObjectPermissionBeans(user, cidsBean, now, connectionContext);
        if (permissionBeans != null) {
            for (CidsBean permissionBean : permissionBeans) {
                if (!AbstractObjectPermissionProvider.checkPermission(permissionBean, user, PermissionType.WRITE)) continue;
                return true;
            }
        }
        return false;
    }

    private static Collection<CidsBean> getObjectPermissionBeans(User user, CidsBean cidsBean, Timestamp now, ConnectionContext connectionContext) {
        if (user == null || cidsBean == null) {
            return null;
        }
        int classId = cidsBean.getMetaObject().getClassID();
        int objectId = cidsBean.getMetaObject().getId();
        String userName = user.getName();
        ArrayList<String> groupNames = new ArrayList<String>();
        for (UserGroup group : user.getPotentialUserGroups()) {
            if (group == null) continue;
            groupNames.add(String.format("('%s')", group.getName()));
        }
        String query = String.format(QUERY_TEMPLATE, CLASSNAME__OBJECTPERMISSIONS, classId, objectId, String.format("'%s'", userName), String.join((CharSequence)", ", groupNames), String.format("'%s'", now.toString()));
        try {
            ArrayList<CidsBean> permissionBeans = new ArrayList<CidsBean>();
            for (MetaObject metaObject : DomainServerCallServerService.getCallServerServiceInstance().getMetaObject(user, query, connectionContext)) {
                permissionBeans.add(metaObject.getBean());
            }
            return permissionBeans;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static boolean checkPermission(CidsBean permissionBean, User user, PermissionType permissionType) {
        Boolean permission;
        return permissionBean != null && user != null && Boolean.TRUE.equals(permission = (Boolean)permissionBean.getProperty(PermissionType.READ.equals((Object)permissionType) ? PROPERTY__READ : PROPERTY__WRITE));
    }

    public boolean getCustomWritePermissionDecisionforUser(User u) {
        return this.getCustomWritePermissionDecisionforUser(u, ConnectionContext.createDeprecated());
    }

    public boolean getCustomReadPermissionDecisionforUser(User u) {
        return this.getCustomReadPermissionDecisionforUser(u, ConnectionContext.createDeprecated());
    }

    private static enum PermissionType {
        READ,
        WRITE;

    }
}

