/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.newuser.User;
import Sirius.util.MapImageFactoryConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.custom.utils.ByteArrayFactoryHandler;
import de.cismet.cids.custom.utils.PotenzialflaechenMapsJson;
import de.cismet.cids.custom.utils.PotenzialflaechenProperties;
import de.cismet.cids.custom.wunda_blau.search.actions.PotenzialflaecheReportServerAction;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.utils.serverresources.JasperReportServerResource;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.log4j.Logger;

public class PotenzialflaecheReportCreator {
    private static final transient Logger LOG = Logger.getLogger(PotenzialflaecheReportCreator.class);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("dd.MM.yyyy");
    private final CidsBean flaecheBean;
    private CidsBean templateBean;
    private final User user;
    private final MetaService metaService;
    private final ConnectionContext connectionContext;
    private final PotenzialflaechenProperties properties;
    private final PotenzialflaechenMapsJson mapsJson;

    public PotenzialflaecheReportCreator(PotenzialflaechenProperties properties, PotenzialflaechenMapsJson mapsJson, CidsBean flaecheBean, User user, MetaService metaService, ConnectionContext connectionContext) throws Exception {
        this.properties = properties;
        this.mapsJson = mapsJson;
        this.flaecheBean = flaecheBean;
        this.user = user;
        this.metaService = metaService;
        this.connectionContext = connectionContext;
    }

    public CidsBean getTemplateBean() {
        return this.templateBean;
    }

    public void writeReportToOutputStream(CidsBean flaecheBean, CidsBean templateBean, OutputStream outputStream) throws Exception {
        CidsBean kategorie = flaecheBean != null ? (CidsBean)flaecheBean.getProperty("kampagne") : null;
        CidsBean selectedTemplateBean = null;
        if (templateBean != null) {
            selectedTemplateBean = templateBean;
        } else if (kategorie != null) {
            List templateBeans = kategorie.getBeanCollectionProperty("n_steckbrieftemplates");
            selectedTemplateBean = templateBeans != null && !templateBeans.isEmpty() ? (CidsBean)templateBeans.iterator().next() : null;
            Integer mainSteckbriefId = (Integer)kategorie.getProperty("haupt_steckbrieftemplate_id");
            if (mainSteckbriefId != null) {
                for (CidsBean templateSubBean : templateBeans) {
                    if (templateSubBean == null || mainSteckbriefId.intValue() != templateSubBean.getMetaObject().getId()) continue;
                    selectedTemplateBean = templateSubBean;
                    break;
                }
            }
        }
        if (selectedTemplateBean == null) {
            throw new Exception("no template found");
        }
        String confAttr = (String)selectedTemplateBean.getProperty("conf_attr");
        if (confAttr != null && !confAttr.trim().isEmpty() && !((DomainServerImpl)this.getMetaService()).hasConfigAttr(this.getUser(), confAttr, this.getConnectionContext())) {
            throw new Exception("kein Recht an Konfigurationsattribut " + confAttr);
        }
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(Arrays.asList(flaecheBean));
        Map parameters = this.generateParams(this);
        parameters.put("PF_ID", flaecheBean != null ? flaecheBean.getPrimaryKeyValue() : null);
        parameters.put("SUBREPORT_DIR", DomainServerImpl.getServerProperties().getServerResourcesBasePath() + "/");
        parameters.put("CREATOR", this);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)PotenzialflaecheReportCreator.getJasperReport(selectedTemplateBean), (Map)parameters, (JRDataSource)dataSource);
        JasperExportManager.exportReportToPdfStream((JasperPrint)print, (OutputStream)outputStream);
        outputStream.flush();
    }

    private Map generateParams(final PotenzialflaecheReportCreator creator) throws Exception {
        final ConcurrentHashMap params = new ConcurrentHashMap();
        ExecutorService calcExecutor = Executors.newFixedThreadPool(4);
        for (PotenzialflaecheReportServerAction.Property property : PotenzialflaecheReportServerAction.Property.values()) {
            final String parameterName = property.name();
            final PotenzialflaecheReportServerAction.ReportProperty reportProperty = property.getValue();
            calcExecutor.execute(new SwingWorker(){

                protected Void doInBackground() throws Exception {
                    Object object = reportProperty.calculateProperty(creator);
                    if (object instanceof Collection) {
                        ArrayList<String> list = new ArrayList<String>(((Collection)object).size());
                        for (Object single : (Collection)object) {
                            list.add(single != null ? String.valueOf(object) : null);
                        }
                        params.put(parameterName, String.join((CharSequence)", ", list));
                        params.put(String.format("%s_LIST", parameterName), object);
                    } else if (object instanceof Date) {
                        params.put(parameterName, SDF.format((Date)object));
                        params.put(String.format("%s_DATE", parameterName), object);
                    } else if (object instanceof BufferedImage) {
                        params.put(parameterName, (BufferedImage)object);
                    } else {
                        params.put(parameterName, object != null ? object.toString() : null);
                    }
                    return null;
                }
            });
        }
        try {
            calcExecutor.shutdown();
            calcExecutor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw new Exception("calculation of params took too long", ex);
        }
        return params;
    }

    public Collection<MetaObjectNode> executeSearch(CidsServerSearch search) throws Exception {
        search.setUser(this.getUser());
        if (search instanceof ConnectionContextStore) {
            ((ConnectionContextStore)search).initWithConnectionContext(this.getConnectionContext());
        }
        HashMap<String, MetaService> localServers = new HashMap<String, MetaService>();
        localServers.put("WUNDA_BLAU", this.getMetaService());
        search.setActiveLocalServers(localServers);
        return search.performServerSearch();
    }

    private MapConfiguration getMapConfiguration(int pfId, String identifier) {
        PotenzialflaechenProperties properties = this.getProperties();
        PotenzialflaechenMapsJson.MapProperties mapProperties = identifier != null ? this.getMapsJson().getMapProperties(identifier) : null;
        MapConfiguration config = new MapConfiguration(identifier);
        config.setPfId(pfId);
        config.setCacheDirectory(properties.getPictureCacheDirectory());
        config.setUseCache(Boolean.TRUE);
        config.setWidth(mapProperties != null ? mapProperties.getWidth() : 300);
        config.setHeight(mapProperties != null ? mapProperties.getHeight() : 200);
        config.setBuffer(mapProperties != null ? mapProperties.getBuffer() : 50);
        config.setMapDpi(mapProperties != null ? mapProperties.getDpi() : 300);
        config.setMapUrl(mapProperties != null ? mapProperties.getWmsUrl() : null);
        config.setIds(Arrays.asList(pfId));
        config.setShowGeom(mapProperties != null ? Boolean.valueOf(mapProperties.isShowGeom()) : null);
        config.setBbX1(properties.getHomeX1());
        config.setBbY1(properties.getHomeY1());
        config.setBbX2(properties.getHomeX2());
        config.setBbY2(properties.getHomeY2());
        config.setSrs(properties.getSrs());
        return config;
    }

    public BufferedImage loadMapFor(String identifier) throws Exception {
        MapConfiguration config = this.getMapConfiguration(this.getFlaecheBean().getPrimaryKeyValue(), identifier);
        File file = config.getFileFromCache();
        if (file != null && file.exists() && file.isFile()) {
            return ImageIO.read(file);
        }
        byte[] bytes = ByteArrayFactoryHandler.getInstance().execute(this.getProperties().getMapFactory(), new ObjectMapper().writeValueAsString((Object)config), this.getUser(), this.getConnectionContext());
        return ImageIO.read(new ByteArrayInputStream(bytes));
    }

    public MetaObject getMetaObject(MetaObjectNode mon) throws Exception {
        return this.metaService.getMetaObject(this.getUser(), mon.getObjectId(), mon.getClassId(), this.getConnectionContext());
    }

    public static JasperReport getJasperReport(CidsBean templateBean) throws Exception {
        return ServerResourcesLoader.getInstance().loadJasperReport(new JasperReportServerResource((String)templateBean.getProperty("link")));
    }

    public CidsBean getFlaecheBean() {
        return this.flaecheBean;
    }

    public User getUser() {
        return this.user;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public PotenzialflaechenProperties getProperties() {
        return this.properties;
    }

    public PotenzialflaechenMapsJson getMapsJson() {
        return this.mapsJson;
    }

    public static class MapConfiguration
    extends MapImageFactoryConfiguration {
        private String identifier;
        private Integer pfId;
        private Collection<Integer> ids;
        private Boolean showGeom;
        private Integer buffer;
        private Boolean useCache;
        private String cacheDirectory;

        public MapConfiguration(String identifier) {
            this.identifier = identifier;
        }

        @JsonIgnore
        public File getFileFromCache() throws Exception {
            String dirName = this.getCacheDirectory();
            if (dirName != null) {
                File dir = new File(dirName);
                return new File(dir, String.format("%d_%s_%s.png", this.getPfId(), this.getIdentifier(), this.getShowGeom() != null && this.getShowGeom() != false ? "geom" : "nogeom"));
            }
            return null;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public Integer getPfId() {
            return this.pfId;
        }

        public Collection<Integer> getIds() {
            return this.ids;
        }

        public Boolean getShowGeom() {
            return this.showGeom;
        }

        public Integer getBuffer() {
            return this.buffer;
        }

        public Boolean getUseCache() {
            return this.useCache;
        }

        public String getCacheDirectory() {
            return this.cacheDirectory;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public void setPfId(Integer pfId) {
            this.pfId = pfId;
        }

        public void setIds(Collection<Integer> ids) {
            this.ids = ids;
        }

        public void setShowGeom(Boolean showGeom) {
            this.showGeom = showGeom;
        }

        public void setBuffer(Integer buffer) {
            this.buffer = buffer;
        }

        public void setUseCache(Boolean useCache) {
            this.useCache = useCache;
        }

        public void setCacheDirectory(String cacheDirectory) {
            this.cacheDirectory = cacheDirectory;
        }

        public MapConfiguration() {
        }
    }
}

