/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils;

import de.cismet.cids.custom.utils.ServerStamperUtils;
import de.cismet.cids.custom.utils.StamperUtils;
import de.cismet.cids.server.actions.JasperReportServerAction;
import de.cismet.cids.server.actions.UploadableInputStream;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import org.apache.commons.io.IOUtils;

public abstract class StampedJasperReportServerAction
extends JasperReportServerAction
implements ConnectionContextStore {
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    protected byte[] generateReport(Map<String, Object> parameters, JRDataSource dataSource) throws Exception {
        String documentType = "action_" + this.getTaskName();
        final byte[] bytes = super.generateReport(parameters, dataSource);
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            UploadableInputStream stream = ServerStamperUtils.getInstance().stampDocument(documentType, bis, new StamperUtils.StamperFallback(){

                @Override
                public UploadableInputStream createProduct() throws Exception {
                    return new UploadableInputStream((InputStream)new ByteArrayInputStream(bytes));
                }
            }, this.getConnectionContext());
            byte[] byArray = IOUtils.toByteArray((InputStream)stream.getInputStream());
            return byArray;
        }
    }
}

