/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.custom.utils.StamperConf;
import de.cismet.cids.server.actions.UploadableInputStream;
import de.cismet.commons.security.handler.SimpleHttpAccessHandler;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class StamperUtils {
    private static final Logger LOG = Logger.getLogger(StamperUtils.class);
    private static final DateFormat DATE_FORMAT_SKIPPING_LOG = new SimpleDateFormat("dd.MM.yyyy - HH:mm:ss");
    private static final DateFormat DATE_FORMAT_STAMPER_CONTEXT = new SimpleDateFormat("dd.MM.yyyy - HH:mm:ss");
    private final StamperConf conf;

    protected StamperUtils(StamperConf conf) {
        this.conf = conf;
    }

    protected StamperConf getConf() {
        return this.conf;
    }

    private File createUniqueTmpDir() {
        String unique = UUID.randomUUID().toString();
        File uniqueTmpDir = new File(this.getConf().getTmpDir(), unique);
        uniqueTmpDir.mkdirs();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("uniqueTmpDir created: " + uniqueTmpDir.toString()));
        }
        return uniqueTmpDir;
    }

    public boolean isStampEnabledFor(String documentType) {
        boolean isStampEnabledFor = false;
        if (documentType != null) {
            for (String enabledFor : this.getConf().getEnabledFor()) {
                String pattern = enabledFor.trim().replace("?", ".?").replace("*", ".*?");
                if (!documentType.matches(pattern)) continue;
                isStampEnabledFor = true;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("stampEnabledFor(" + documentType + ") : " + isStampEnabledFor));
        }
        return isStampEnabledFor;
    }

    public boolean isSkippingOnErrorEnabled() {
        String onErrorSkipAndLogInto = this.getConf().getOnErrorSkipAndLogInto();
        return onErrorSkipAndLogInto != null && !onErrorSkipAndLogInto.trim().isEmpty();
    }

    public File getSkippingLogFile() {
        if (this.isSkippingOnErrorEnabled()) {
            return new File(this.getConf().getOnErrorSkipAndLogInto());
        }
        return null;
    }

    public UploadableInputStream stampRequest(String documentType, URL url, String postParams, StamperFallback fallback, ConnectionContext connectionContext) throws Exception {
        if (this.isStampEnabledFor(documentType)) {
            try {
                return this.stampRequest(url, postParams, StamperUtils.createStamperContext(StamperContext.Type.Request, documentType, connectionContext));
            }
            catch (Exception ex) {
                if (this.isSkippingOnErrorEnabled()) {
                    File skippingLogFile = this.getSkippingLogFile();
                    LOG.info((Object)("Error while stamping request. skipping is enabled. Logging into " + skippingLogFile.getCanonicalPath()), (Throwable)ex);
                    StringBuffer sb = new StringBuffer();
                    sb.append(DATE_FORMAT_SKIPPING_LOG.format(new Date())).append(" | stampRequest(\n\t").append(documentType).append(",\n\t").append(url.toExternalForm()).append(",\n\t").append(postParams).append("\n) => ").append(ExceptionUtils.getStackTrace((Throwable)ex)).append("\n");
                    FileUtils.writeStringToFile((File)skippingLogFile, (String)sb.toString(), (String)"UTF-8", (boolean)true);
                    return fallback.createProduct();
                }
                throw ex;
            }
        }
        return fallback.createProduct();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploadableInputStream stampRequest(URL url, String postParams, StamperContext stamperContext) throws Exception {
        URL serviceUrl = new URL(this.getConf().getStamperService() + this.getConf().getStamperRequest());
        OptionsJson optionsJson = postParams != null ? new OptionsJson(OptionsJson.Method.POST, new HeadersJson("application/x-www-form-urlencoded"), postParams) : new OptionsJson(OptionsJson.Method.GET, null, null);
        String optionsJsonAsString = new ObjectMapper().writeValueAsString((Object)new FetchJson(url, optionsJson));
        String connectionContextJsonAsString = new ObjectMapper().writeValueAsString((Object)stamperContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("serviceUrl: " + serviceUrl));
            LOG.debug((Object)("optionsJsonAsString: " + optionsJsonAsString));
            LOG.debug((Object)("connectionContextJsonAsString: " + connectionContextJsonAsString));
        }
        File uniqueTmpDir = this.createUniqueTmpDir();
        File fileRequest = new File(uniqueTmpDir, "request.json");
        File fileContext = new File(uniqueTmpDir, "context.json");
        try {
            FileUtils.writeStringToFile((File)fileRequest, (String)optionsJsonAsString, (String)"UTF-8");
            FileUtils.writeStringToFile((File)fileContext, (String)connectionContextJsonAsString, (String)"UTF-8");
            ArrayList<Object> parts = new ArrayList<Object>();
            parts.add(new StringPart("password", this.getConf().getPassword()));
            parts.add(new FilePart("requestJson", fileRequest));
            parts.add(new FilePart("context", fileContext));
            UploadableInputStream uploadableInputStream = new UploadableInputStream(new SimpleHttpAccessHandler().doMultipartRequest(serviceUrl, parts.toArray(new Part[0]), null));
            return uploadableInputStream;
        }
        finally {
            fileContext.delete();
            fileRequest.delete();
            uniqueTmpDir.delete();
        }
    }

    public UploadableInputStream stampDocument(String documentType, InputStream inputStream, StamperFallback fallback, ConnectionContext connectionContext) throws Exception {
        if (this.isStampEnabledFor(documentType)) {
            try {
                return this.stampDocument(inputStream, StamperUtils.createStamperContext(StamperContext.Type.Document, documentType, connectionContext));
            }
            catch (Exception ex) {
                if (this.isSkippingOnErrorEnabled()) {
                    File skippingLogFile = this.getSkippingLogFile();
                    StringBuffer sb = new StringBuffer();
                    sb.append(DATE_FORMAT_SKIPPING_LOG.format(new Date())).append(" | stampDocument(\n\t").append(documentType).append(",\n\t").append(inputStream).append("\n) => ").append(ExceptionUtils.getStackTrace((Throwable)ex)).append("\n");
                    FileUtils.writeStringToFile((File)skippingLogFile, (String)sb.toString(), (String)"UTF-8", (boolean)true);
                    return fallback.createProduct();
                }
                throw ex;
            }
        }
        return fallback.createProduct();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploadableInputStream stampDocument(InputStream inputStream, StamperContext stamperContext) throws Exception {
        URL serviceUrl = new URL(this.getConf().getStamperService() + this.getConf().getStamperDocument());
        String connectionContextJsonAsString = new ObjectMapper().writeValueAsString((Object)stamperContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("serviceUrl: " + serviceUrl));
            LOG.debug((Object)("connectionContextJsonAsString: " + connectionContextJsonAsString));
        }
        File uniqueTmpDir = this.createUniqueTmpDir();
        File fileDocument = new File(uniqueTmpDir, "document.pdf");
        File fileContext = new File(uniqueTmpDir, "context.json");
        try {
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)fileDocument);
            FileUtils.writeStringToFile((File)fileContext, (String)connectionContextJsonAsString, (String)"UTF-8");
            ArrayList<Object> parts = new ArrayList<Object>();
            parts.add(new StringPart("password", this.getConf().getPassword()));
            parts.add(new FilePart("document", fileDocument));
            parts.add(new FilePart("context", fileContext));
            UploadableInputStream uploadableInputStream = new UploadableInputStream(new SimpleHttpAccessHandler().doMultipartRequest(serviceUrl, parts.toArray(new Part[0]), null));
            return uploadableInputStream;
        }
        finally {
            fileContext.delete();
            fileDocument.delete();
            uniqueTmpDir.delete();
        }
    }

    private static StamperContext createStamperContext(StamperContext.Type contextType, String documentType, ConnectionContext connectionContext) {
        HashMap infoFields = connectionContext.getInfoFields();
        infoFields.remove("ClientIp");
        StamperContext stamperContext = new StamperContext(DATE_FORMAT_STAMPER_CONTEXT.format(new Date()), contextType, documentType, new StamperContextInfoConnectionContext(connectionContext.getCategory(), infoFields));
        return stamperContext;
    }

    public static class StamperContextInfoConnectionContext {
        private final AbstractConnectionContext.Category category;
        private final HashMap<String, Object> infoFields;

        public AbstractConnectionContext.Category getCategory() {
            return this.category;
        }

        public HashMap<String, Object> getInfoFields() {
            return this.infoFields;
        }

        public StamperContextInfoConnectionContext(AbstractConnectionContext.Category category, HashMap<String, Object> infoFields) {
            this.category = category;
            this.infoFields = infoFields;
        }
    }

    public static class StamperContext {
        private final String date;
        private final Type type;
        private final String documentType;
        private final Object info;

        public String getDate() {
            return this.date;
        }

        public Type getType() {
            return this.type;
        }

        public String getDocumentType() {
            return this.documentType;
        }

        public Object getInfo() {
            return this.info;
        }

        public StamperContext(String date, Type type, String documentType, Object info) {
            this.date = date;
            this.type = type;
            this.documentType = documentType;
            this.info = info;
        }

        public static enum Type {
            Request,
            Document;

        }
    }

    static class HeadersJson {
        @JsonProperty(value="Content-Type")
        private final String contentType;

        public String getContentType() {
            return this.contentType;
        }

        public HeadersJson(String contentType) {
            this.contentType = contentType;
        }
    }

    static class OptionsJson {
        private final Method method;
        private final HeadersJson headers;
        private final String body;

        public Method getMethod() {
            return this.method;
        }

        public HeadersJson getHeaders() {
            return this.headers;
        }

        public String getBody() {
            return this.body;
        }

        public OptionsJson(Method method, HeadersJson headers, String body) {
            this.method = method;
            this.headers = headers;
            this.body = body;
        }

        public static enum Method {
            POST,
            GET,
            PUT;

        }
    }

    public static class FetchJson {
        private final URL url;
        private final OptionsJson options;

        public URL getUrl() {
            return this.url;
        }

        public OptionsJson getOptions() {
            return this.options;
        }

        public FetchJson(URL url, OptionsJson options) {
            this.url = url;
            this.options = options;
        }
    }

    public static interface StamperFallback {
        public UploadableInputStream createProduct() throws Exception;
    }
}

