/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.alkis;

import java.net.URL;
import java.util.Properties;

public abstract class AlkisConf {
    private static final String DOWNLOAD_TEMPLATE = "<rasterfari:url>?REQUEST=GetMap&SERVICE=WMS&customDocumentInfo=download&LAYERS=<rasterfari:document>";
    private final String service;
    private final String server;
    private final String srsGeom;
    private final String srsService;
    private final String mapCallString;
    private final double geoBuffer;
    private final double geoBufferMultiplier;
    private final String einzelNachweisService;
    private final String listenNachweisService;
    private final String LiegenschaftskarteService;
    private final String rasterfariUrl;
    private final String nivpHost;
    private final String nivpPrefix;
    private final String apmapsHost;
    private final String apmapsEtrsHost;
    private final String apmapsPrefix;
    private final String vermessungHostBilder;
    private final String vermessungHostGrenzniederschriften;
    private final String vermessungHostFlurbuecher;
    private final String vermessungHostLiegenschaftsbuecher;
    private final String vermessungHostNamensverzeichnis;
    private final String vermessungHostErgaenzungskarten;
    private final String vermessungHostInselkarten;
    private final String vermessungHostGewannen;
    private final String vermessungHostGebaeudebeschreibungen;
    private final String landparcelFeatureRendererColor;
    private final String demoServiceUrl;

    protected AlkisConf(Properties serviceProperties) {
        this.service = serviceProperties.getProperty("SERVICE");
        this.server = serviceProperties.getProperty("SERVER");
        this.demoServiceUrl = serviceProperties.getProperty("DEMOSERVICEURL");
        this.einzelNachweisService = this.server + serviceProperties.getProperty("BUCH_NACHWEIS_SERVICE");
        this.listenNachweisService = this.server + serviceProperties.getProperty("LISTEN_NACHWEIS_SERVICE");
        this.LiegenschaftskarteService = this.server + serviceProperties.getProperty("LIEGENSCHAFTSKARTE_SERVICE");
        this.srsGeom = serviceProperties.getProperty("SRS_GEOM");
        this.srsService = serviceProperties.getProperty("SRS_SERVICE");
        this.mapCallString = serviceProperties.getProperty("MAP_CALL_STRING") + this.srsService;
        this.geoBuffer = Double.parseDouble(serviceProperties.getProperty("GEO_BUFFER"));
        this.geoBufferMultiplier = Double.parseDouble(serviceProperties.getProperty("GEO_BUFFER_MULTIPLIER"));
        this.rasterfariUrl = serviceProperties.getProperty("RASTERFARI_URL");
        this.nivpHost = serviceProperties.getProperty("NIVP_HOST");
        this.nivpPrefix = serviceProperties.getProperty("NIVP_PREFIX");
        this.apmapsPrefix = serviceProperties.getProperty("APMAPS_PREFIX");
        this.vermessungHostBilder = serviceProperties.getProperty("VERMESSUNG_HOST_BILDER");
        this.vermessungHostGrenzniederschriften = serviceProperties.getProperty("VERMESSUNG_HOST_GRENZNIEDERSCHRIFTEN");
        this.vermessungHostErgaenzungskarten = serviceProperties.getProperty("VERMESSUNG_HOST_ERGAENZUNGSKARTEN");
        this.vermessungHostFlurbuecher = serviceProperties.getProperty("VERMESSUNG_HOST_FLURBUECHER");
        this.vermessungHostLiegenschaftsbuecher = serviceProperties.getProperty("VERMESSUNG_HOST_LIEGENSCHAFTSBUECHER");
        this.vermessungHostNamensverzeichnis = serviceProperties.getProperty("VERMESSUNG_HOST_NAMENSVERZEICHNIS");
        this.vermessungHostInselkarten = serviceProperties.getProperty("VERMESSUNG_HOST_INSELKARTEN");
        this.vermessungHostGewannen = serviceProperties.getProperty("VERMESSUNG_HOST_GEWANNEN");
        this.vermessungHostGebaeudebeschreibungen = serviceProperties.getProperty("VERMESSUNG_HOST_GEBAEUDEBESCHREIBUNGEN");
        this.apmapsHost = serviceProperties.getProperty("APMAPS_HOST");
        this.apmapsEtrsHost = serviceProperties.getProperty("APMAPS_ETRS_HOST");
        this.landparcelFeatureRendererColor = serviceProperties.getProperty("LANDPARCEL_FEATURE_RENDERER_COLOR");
    }

    public final URL getDownloadUrlForDocument(String document) throws Exception {
        return new URL(DOWNLOAD_TEMPLATE.replace("<rasterfari:url>", this.getRasterfariUrl()).replace("<rasterfari:document>", document));
    }

    public String getService() {
        return this.service;
    }

    public String getServer() {
        return this.server;
    }

    public String getSrsGeom() {
        return this.srsGeom;
    }

    public String getSrsService() {
        return this.srsService;
    }

    public String getMapCallString() {
        return this.mapCallString;
    }

    public double getGeoBuffer() {
        return this.geoBuffer;
    }

    public double getGeoBufferMultiplier() {
        return this.geoBufferMultiplier;
    }

    public String getEinzelNachweisService() {
        return this.einzelNachweisService;
    }

    public String getListenNachweisService() {
        return this.listenNachweisService;
    }

    public String getLiegenschaftskarteService() {
        return this.LiegenschaftskarteService;
    }

    public String getRasterfariUrl() {
        return this.rasterfariUrl;
    }

    public String getNivpHost() {
        return this.nivpHost;
    }

    public String getNivpPrefix() {
        return this.nivpPrefix;
    }

    public String getApmapsHost() {
        return this.apmapsHost;
    }

    public String getApmapsEtrsHost() {
        return this.apmapsEtrsHost;
    }

    public String getApmapsPrefix() {
        return this.apmapsPrefix;
    }

    public String getVermessungHostBilder() {
        return this.vermessungHostBilder;
    }

    public String getVermessungHostGrenzniederschriften() {
        return this.vermessungHostGrenzniederschriften;
    }

    public String getVermessungHostFlurbuecher() {
        return this.vermessungHostFlurbuecher;
    }

    public String getVermessungHostLiegenschaftsbuecher() {
        return this.vermessungHostLiegenschaftsbuecher;
    }

    public String getVermessungHostNamensverzeichnis() {
        return this.vermessungHostNamensverzeichnis;
    }

    public String getVermessungHostErgaenzungskarten() {
        return this.vermessungHostErgaenzungskarten;
    }

    public String getVermessungHostInselkarten() {
        return this.vermessungHostInselkarten;
    }

    public String getVermessungHostGewannen() {
        return this.vermessungHostGewannen;
    }

    public String getVermessungHostGebaeudebeschreibungen() {
        return this.vermessungHostGebaeudebeschreibungen;
    }

    public String getLandparcelFeatureRendererColor() {
        return this.landparcelFeatureRendererColor;
    }

    public String getDemoServiceUrl() {
        return this.demoServiceUrl;
    }
}

