/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.alkis;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.AsyncDownloadHelper;
import de.cismet.cids.custom.utils.alkis.AlkisProducts;
import de.cismet.cids.custom.utils.alkis.BaulastBescheinigungHelper;
import de.cismet.cids.custom.utils.alkis.ServerAlkisProducts;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisEinzelnachweisDownloadInfo;
import de.cismet.cids.custom.wunda_blau.search.actions.AlkisProductServerAction;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class LiegenschaftsbuchauszugHelper {
    private static final Logger LOG = Logger.getLogger(LiegenschaftsbuchauszugHelper.class);
    private static final Map<String, MetaClass> METACLASS_CACHE = new HashMap<String, MetaClass>();
    private final ConnectionContext connectionContext;
    private final MetaService metaService;
    private final User user;

    public LiegenschaftsbuchauszugHelper(User user, MetaService metaService, ConnectionContext connectionContext) {
        this.user = user;
        this.metaService = metaService;
        this.connectionContext = connectionContext;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public User getUser() {
        return this.user;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private void prepareFlurstuecke(List<CidsBean> flurstuecke, ProtocolBuffer protocolBuffer) throws Exception {
        protocolBuffer.appendLine("Liegenschaftsbuchauszugs-Protokoll f\u00fcr " + (flurstuecke.size() == 1 ? "folgendes Flurst\u00fcck" : "folgende Flurst\u00fccke") + ":");
        Collections.sort(flurstuecke, new Comparator<CidsBean>(){

            @Override
            public int compare(CidsBean o1, CidsBean o2) {
                String s1 = o1 == null ? "" : (String)o1.getProperty("alkis_id");
                String s2 = o2 == null ? "" : (String)o2.getProperty("alkis_id");
                return s1.compareTo(s2);
            }
        });
        for (CidsBean flurstueck : flurstuecke) {
            protocolBuffer.appendLine(" * " + flurstueck);
        }
    }

    public void writeProcotol(String protocol, ZipOutputStream zipOut) throws IOException {
        this.writeToZip("liegenschaftsbuch_protokoll.txt", IOUtils.toInputStream((String)protocol, (String)"UTF-8"), zipOut);
    }

    public File writeFullBescheinigung(BerechtigungspruefungAlkisEinzelnachweisDownloadInfo downloadInfo, File file, String transid) throws IOException {
        this.writeAlkisReports(downloadInfo.getAlkisCodes(), downloadInfo.getAuftragsnummer(), downloadInfo.getAlkisProdukt(), file);
        try {
            return BaulastBescheinigungHelper.handleLargeFileIfRequired(file, transid);
        }
        catch (Exception e) {
            LOG.fatal((Object)e, (Throwable)e);
            return null;
        }
    }

    private void writeToZip(String fileName, InputStream in, ZipOutputStream zipOut) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        zipOut.putNextEntry(new ZipEntry(fileName.replace("/", "--")));
        while ((len = in.read(buf)) > 0) {
            zipOut.write(buf, 0, len);
        }
        zipOut.flush();
    }

    private void writeAlkisReports(List<String> alkisCode, String jobNumber, String product, File file) throws IOException {
        block32: {
            if (alkisCode != null && alkisCode.size() == 1) {
                ServerActionParameter[] saps = new ServerActionParameter[]{new ServerActionParameter(AlkisProductServerAction.Parameter.PRODUKT.toString(), (Object)product), new ServerActionParameter(AlkisProductServerAction.Parameter.ALKIS_CODE.toString(), (Object)AlkisProducts.escapeHtmlSpaces(AlkisProducts.fixBuchungslattCode(alkisCode.get(0)))), new ServerActionParameter(AlkisProductServerAction.Parameter.AUFTRAGSNUMMER.toString(), (Object)jobNumber)};
                AlkisProductServerAction serverAction = new AlkisProductServerAction();
                serverAction.setMetaService(this.getMetaService());
                serverAction.setUser(this.getUser());
                serverAction.initWithConnectionContext(this.getConnectionContext());
                Object o = serverAction.execute((Object)AlkisProductServerAction.Body.EINZELNACHWEIS, saps);
                o = AsyncDownloadHelper.actionResultToByteArrayIfPossible(o);
                if (o instanceof Exception) {
                    throw new IOException((Exception)o);
                }
                try (FileOutputStream out = new FileOutputStream(file);){
                    out.write((byte[])o);
                    break block32;
                }
                catch (IOException ex) {
                    LOG.fatal((Object)ex, (Throwable)ex);
                    throw ex;
                }
            }
            try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(file));){
                for (String code : alkisCode) {
                    ServerActionParameter[] saps = new ServerActionParameter[]{new ServerActionParameter(AlkisProductServerAction.Parameter.PRODUKT.toString(), (Object)product), new ServerActionParameter(AlkisProductServerAction.Parameter.ALKIS_CODE.toString(), (Object)AlkisProducts.escapeHtmlSpaces(AlkisProducts.fixBuchungslattCode(code))), new ServerActionParameter(AlkisProductServerAction.Parameter.AUFTRAGSNUMMER.toString(), (Object)jobNumber)};
                    AlkisProductServerAction serverAction = new AlkisProductServerAction();
                    serverAction.setMetaService(this.getMetaService());
                    serverAction.setUser(this.getUser());
                    serverAction.initWithConnectionContext(this.getConnectionContext());
                    Object o = serverAction.execute((Object)AlkisProductServerAction.Body.EINZELNACHWEIS, saps);
                    o = AsyncDownloadHelper.actionResultToByteArrayIfPossible(o);
                    if (o instanceof Exception) {
                        throw new IOException((Exception)o);
                    }
                    this.writeToZip(product + "." + code + ".pdf", new ByteArrayInputStream((byte[])o), zipOut);
                }
            }
            catch (IOException ex) {
                LOG.fatal((Object)ex, (Throwable)ex);
                throw ex;
            }
        }
    }

    protected List<String> createFlurstuecksListFromBeans(List<CidsBean> flurstuecke) {
        ArrayList<String> flList = new ArrayList<String>();
        for (CidsBean bean : flurstuecke) {
            flList.add(bean.toString());
        }
        return flList;
    }

    protected String createStringFromList(List<String> list) {
        StringBuilder builder = new StringBuilder();
        boolean firstElement = true;
        for (String tmp : list) {
            if (firstElement) {
                firstElement = false;
            } else {
                builder.append(",");
            }
            builder.append(tmp);
        }
        return builder.toString();
    }

    protected List<String> createBuchungsblattListFromBeans(List<CidsBean> buchungsblaetter) {
        ArrayList<String> bbList = new ArrayList<String>();
        for (CidsBean bean : buchungsblaetter) {
            bbList.add(AlkisProducts.fixBuchungslattCode((String)bean.getProperty("buchungsblattcode")));
        }
        return bbList;
    }

    public BerechtigungspruefungAlkisEinzelnachweisDownloadInfo calculateDownloadInfo(String auftragsnummer, String produktBezeichnung, String fertigungsVermerk, List<CidsBean> flurstuecke, List<CidsBean> buchungsblaetter, String alkisProduct, ProtocolBuffer protocolBuffer, StatusHolder statusHolder) throws Exception {
        List<String> alkisCodes;
        BerechtigungspruefungAlkisDownloadInfo.AlkisObjektTyp alkisObjectTyp;
        Integer prodAmounts;
        String productType;
        statusHolder.setMessage("Bescheinigung wird vorbereitet...");
        this.prepareFlurstuecke(flurstuecke, protocolBuffer);
        statusHolder.setMessage("Geb\u00fchr wird berechnet...");
        ServerAlkisProducts alkisProducts = ServerAlkisProducts.getInstance();
        statusHolder.setMessage("Ben\u00f6tigte Daten identifizieren...");
        if (alkisProduct.startsWith("fsueKom")) {
            productType = alkisProducts.get(AlkisProducts.Type.FLURSTUECKS_UND_EIGENTUMSNACHWEIS_KOMMUNAL_PDF);
            prodAmounts = flurstuecke.size();
            alkisObjectTyp = BerechtigungspruefungAlkisDownloadInfo.AlkisObjektTyp.FLURSTUECKE;
            alkisCodes = this.createFlurstuecksListFromBeans(flurstuecke);
        } else {
            productType = alkisProducts.get(AlkisProducts.Type.BESTANDSNACHWEIS_KOMMUNAL_PDF);
            prodAmounts = buchungsblaetter.size();
            alkisObjectTyp = BerechtigungspruefungAlkisDownloadInfo.AlkisObjektTyp.BUCHUNGSBLAETTER;
            alkisCodes = this.createBuchungsblattListFromBeans(buchungsblaetter);
        }
        return new BerechtigungspruefungAlkisEinzelnachweisDownloadInfo(BerechtigungspruefungAlkisDownloadInfo.PRODUKT_TYP, auftragsnummer, produktBezeichnung, null, alkisObjectTyp, BerechtigungspruefungAlkisDownloadInfo.AlkisDownloadTyp.EINZELNACHWEIS, alkisCodes, productType, null, prodAmounts);
    }

    public static class ProtocolBuffer {
        private final StringBuffer buffer = new StringBuffer();

        public ProtocolBuffer appendLine(String string) {
            this.buffer.append(string).append("\n");
            return this;
        }

        public String toString() {
            return this.buffer.toString();
        }
    }

    public static class StatusHolder {
        private String message;

        public void setMessage(String message) {
            this.message = message;
            LOG.info((Object)message);
        }

        public String getMessage() {
            return this.message;
        }
    }
}

