/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.alkis;

import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.custom.utils.alkis.AlkisAccessProvider;
import de.cismet.cids.custom.utils.alkis.AlkisProducts;
import de.cismet.cids.custom.utils.alkis.AlkisRestConf;
import de.cismet.cids.custom.utils.alkis.ServerAlkisConf;
import de.cismet.cids.custom.wunda_blau.search.actions.AlkisProductServerAction;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.tools.StaticHtmlTools;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public final class ServerAlkisProducts
extends AlkisProducts {
    private static ServerAlkisProducts INSTANCE;
    private static final SimpleDateFormat STICHTAG_DATE_FORMAT;
    private final AlkisAccessProvider alkisAccessProvider;

    private ServerAlkisProducts(ServerAlkisConf alkisConf, AlkisRestConf alkisRestConf, Properties productProperties, Properties formats, String produktbeschreibungXml) throws Exception {
        super(alkisConf, productProperties, formats, produktbeschreibungXml);
        this.alkisAccessProvider = new AlkisAccessProvider(alkisRestConf);
    }

    public static ServerAlkisProducts getInstance() {
        if (INSTANCE == null) {
            try {
                INSTANCE = new ServerAlkisProducts(ServerAlkisConf.getInstance(), AlkisRestConf.getInstance(), ServerResourcesLoader.getInstance().loadProperties(WundaBlauServerResources.ALKIS_PRODUCTS_PROPERTIES.getValue()), ServerResourcesLoader.getInstance().loadProperties(WundaBlauServerResources.ALKIS_FORMATS_PROPERTIES.getValue()), ServerResourcesLoader.getInstance().loadText(WundaBlauServerResources.ALKIS_PRODUKTBESCHREIBUNG_XML.getValue()));
            }
            catch (Exception ex) {
                throw new RuntimeException("Error while parsing Alkis Product Description!", ex);
            }
        }
        return INSTANCE;
    }

    public URL productEinzelNachweisUrl(String objectID, String productCode, User user, String fertigungsVermerk) throws MalformedURLException {
        String fabricationNotice = this.generateFabricationNotice(fertigungsVermerk);
        StringBuilder urlBuilder = new StringBuilder(ServerAlkisConf.getInstance().getEinzelNachweisService()).append("?product=").append(productCode).append("&id=").append(objectID).append(this.getIdentification()).append(this.getMore());
        if (user != null) {
            try {
                urlBuilder.append("&ordernumber=").append(URLEncoder.encode(user.getName(), "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new MalformedURLException("error while encoding: " + user.getName());
            }
        }
        if (fabricationNotice != null) {
            urlBuilder.append("&fabricationNotice=").append(fabricationNotice);
        }
        return new URL(urlBuilder.toString());
    }

    public URL productEinzelnachweisStichtagsbezogenUrl(String objectID, String productCode, Date stichtag, User user, String fertigungsVermerk) throws MalformedURLException {
        String fabricationNotice = this.generateFabricationNotice(fertigungsVermerk);
        StringBuilder urlBuilder = new StringBuilder(ServerAlkisConf.getInstance().getEinzelNachweisService()).append("?reportingDate=").append(STICHTAG_DATE_FORMAT.format(stichtag)).append("&product=").append(productCode).append("&id=").append(objectID).append(this.getIdentification()).append(this.getMore());
        if (user != null) {
            try {
                urlBuilder.append("&ordernumber=").append(URLEncoder.encode(user.getName(), "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new MalformedURLException("error while encoding: " + user.getName());
            }
        }
        if (fabricationNotice != null) {
            urlBuilder.append("&fabricationNotice=").append(fabricationNotice);
        }
        return new URL(urlBuilder.toString());
    }

    private String generateFabricationNotices(String fertigungsVermerk) {
        if (fertigungsVermerk != null) {
            try {
                String notice1 = URLEncoder.encode("Gefertigt im Auftrag der Stadt Wuppertal durch: \u00d6ffentlich bestellter Vermessungsingenieur", "UTF-8");
                String notice3 = URLEncoder.encode(fertigungsVermerk, "UTF-8");
                return new StringBuffer("&fabricationNotice1=").append(notice1).append("&fabricationNotice2=&fabricationNotice3=").append(notice3).toString();
            }
            catch (UnsupportedEncodingException ex) {
                AlkisProductServerAction.LOG.error((Object)"error while encoding fabricationnotice", (Throwable)ex);
                return null;
            }
        }
        return "";
    }

    private String generateFabricationNotice(String fertigungsVermerk) {
        if (fertigungsVermerk != null) {
            try {
                String note = URLEncoder.encode("Gefertigt im Auftrag der Stadt Wuppertal durch: \u00d6ffentlich bestellter Vermessungsingenieur " + fertigungsVermerk, "UTF-8");
                return note;
            }
            catch (UnsupportedEncodingException ex) {
                AlkisProductServerAction.LOG.error((Object)"error while encoding fabricationnotice", (Throwable)ex);
                return null;
            }
        }
        return null;
    }

    public URL productKarteUrl(String parcelCode, String fertigungsVermerk) throws MalformedURLException {
        String fabricationNotices = this.generateFabricationNotices(fertigungsVermerk);
        return new URL(new StringBuffer(ServerAlkisConf.getInstance().getLiegenschaftskarteService()).append("?landparcel=").append(parcelCode).append(this.getIdentification()).append(this.getMore()).append(fabricationNotices != null ? fabricationNotices : "").toString());
    }

    public URL productKarteUrl(String parcelCode, String produkt, int winkel, int centerX, int centerY, String massstab, String massstabMin, String massstabMax, String zusText, String auftragsNr, boolean moreThanOneParcel, String fertigungsVermerk) throws MalformedURLException {
        boolean nachverarbeitung = !"WUP.KOM.FFF.01".equals(produkt) && !"WUP.KOM.FFF.02".equals(produkt) && !"WUP.KOM.FFS.01".equals(produkt) && !"WUP.KOM.FFS.02".equals(produkt);
        StringBuilder url = new StringBuilder(ServerAlkisConf.getInstance().getLiegenschaftskarteService());
        url.append("?landparcel=").append(parcelCode);
        url.append("&product=").append(produkt);
        url.append("&centerx=").append(centerX);
        url.append("&centery=").append(centerY);
        url.append("&angle=").append(winkel);
        if (zusText != null && zusText.length() > 0) {
            url.append("&text=").append(StaticHtmlTools.encodeURLParameter((String)zusText));
        }
        if (auftragsNr != null && auftragsNr.length() > 0) {
            url.append("&ordernumber=").append(StaticHtmlTools.encodeURLParameter((String)auftragsNr));
        }
        if (moreThanOneParcel) {
            url.append("&additionalLandparcel=true");
        }
        url.append(this.getIdentification()).append(nachverarbeitung ? this.getMore() : this.getLess());
        String fabricationNotices = this.generateFabricationNotices(fertigungsVermerk);
        if (massstabMin != null && massstabMax != null) {
            url.append("&scale=");
            url.append(massstab);
        }
        if (fabricationNotices != null) {
            url.append(fabricationNotices);
        }
        return new URL(url.toString());
    }

    public URL productListenNachweisUrl(String punktliste, String productCode) throws MalformedURLException {
        return new URL(new StringBuffer(ServerAlkisConf.getInstance().getListenNachweisService()).append("?product=").append(productCode).append("&ids=").append(punktliste).append(this.getIdentification()).append(this.getMore()).toString());
    }

    private AlkisAccessProvider getAlkisAccessProvider() {
        return this.alkisAccessProvider;
    }

    public String getIdentification() {
        String token = this.getAlkisAccessProvider().login();
        return new StringBuffer("&token=").append(token).toString();
    }

    public URL getCsvGetResultURL(String server, String id) throws MalformedURLException {
        return new URL(new StringBuffer(server).append("?action=stream&").append("streamid=").append(id).append(this.getIdentification()).toString());
    }

    private String getMore() {
        return new StringBuffer("&service=").append(ServerAlkisConf.getInstance().getService()).append("&script=").append(ServerAlkisProducts.getInstance().getNachverarbeitungScript()).toString();
    }

    private String getLess() {
        return new StringBuffer("&service=").append(ServerAlkisConf.getInstance().getService()).toString();
    }

    static {
        STICHTAG_DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    }
}

