/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.alkis;

public class StempelfeldInfo {
    float fromX;
    float fromY;
    float toX;
    float toY;

    public StempelfeldInfo(float fromX, float fromY, float toX, float toY) {
        if (fromX < toX) {
            this.fromX = fromX;
            this.toX = toX;
        } else {
            this.fromX = toX;
            this.toX = fromX;
        }
        if (fromY < toY) {
            this.fromY = fromY;
            this.toY = toY;
        } else {
            this.fromY = toY;
            this.toY = fromY;
        }
        this.fromX = this.transformToInnerBounds(this.fromX);
        this.fromY = this.transformToInnerBounds(this.fromY);
        this.toX = this.transformToInnerBounds(this.toX);
        this.toY = this.transformToInnerBounds(this.toY);
    }

    private float transformToInnerBounds(float f) {
        if (f > 0.0f && f < 1.0f) {
            return f;
        }
        if (f <= 0.0f) {
            return 1.0E-4f;
        }
        return 0.9999f;
    }

    public float getFromX() {
        return this.fromX;
    }

    public float getFromY() {
        return this.fromY;
    }

    public float getToX() {
        return this.toX;
    }

    public float getToY() {
        return this.toY;
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Float.floatToIntBits(this.fromX);
        hash = 23 * hash + Float.floatToIntBits(this.fromY);
        hash = 23 * hash + Float.floatToIntBits(this.toX);
        hash = 23 * hash + Float.floatToIntBits(this.toY);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StempelfeldInfo other = (StempelfeldInfo)obj;
        if (Float.floatToIntBits(this.fromX) != Float.floatToIntBits(other.fromX)) {
            return false;
        }
        if (Float.floatToIntBits(this.fromY) != Float.floatToIntBits(other.fromY)) {
            return false;
        }
        if (Float.floatToIntBits(this.toX) != Float.floatToIntBits(other.toX)) {
            return false;
        }
        return Float.floatToIntBits(this.toY) == Float.floatToIntBits(other.toY);
    }

    public String toString() {
        return "StempelfeldInfo{fromX=" + this.fromX + ", fromY=" + this.fromY + ", toX=" + this.toX + ", toY=" + this.toY + '}';
    }
}

