/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.utils.berechtigungspruefung;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import Sirius.server.newuser.UserServer;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungBillingDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.BerechtigungspruefungProperties;
import de.cismet.cids.custom.utils.berechtigungspruefung.baulastbescheinigung.BerechtigungspruefungBescheinigungDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisEinzelnachweisDownloadInfo;
import de.cismet.cids.custom.utils.berechtigungspruefung.katasterauszug.BerechtigungspruefungAlkisKarteDownloadInfo;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.messages.CidsServerMessageManagerImpl;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.rmi.Naming;
import java.rmi.Remote;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class BerechtigungspruefungHandler
implements ConnectionContextStore {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final transient Logger LOG = Logger.getLogger(BerechtigungspruefungHandler.class);
    private MetaService metaService;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final User user;

    private BerechtigungspruefungHandler() {
        User user = null;
        String[] stringArray = DomainServerImpl.getServerProperties().getRegistryIps();
        int n = stringArray.length;
        int n2 = 0;
        if (n2 < n) {
            String registryIP = stringArray[n2];
            try {
                Remote userServer = Naming.lookup("rmi://" + registryIP + "/userServer");
                user = ((UserServer)userServer).getUser(null, null, "WUNDA_BLAU", BerechtigungspruefungProperties.getInstance().getCidsLogin(), BerechtigungspruefungProperties.getInstance().getCidsPassword());
            }
            catch (Exception ex) {
                LOG.fatal((Object)ex, (Throwable)ex);
            }
        }
        this.user = user;
    }

    public static BerechtigungspruefungHandler getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public void deleteOldDateianhangFiles() {
        File directory = new File(BerechtigungspruefungProperties.getInstance().getAnhangAbsPath());
        Date thresholdDate = BerechtigungspruefungHandler.getThresholdAnhangDate();
        if (directory.listFiles() != null) {
            for (File file : directory.listFiles()) {
                if (!file.isFile()) continue;
                try {
                    Timestamp anfrageTs;
                    CidsBean anfrageBean;
                    String fileName = file.getName();
                    BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    Date creationDate = new Date(attr.creationTime().toMillis());
                    if (!creationDate.before(thresholdDate) || (anfrageBean = this.loadAnfrageBean(fileName)) == null || !(anfrageTs = (Timestamp)anfrageBean.getProperty("anfrage_timestamp")).before(thresholdDate)) continue;
                    LOG.info((Object)("deleting old Anhang file: " + file.getName() + " (date: " + creationDate.toString() + ")"));
                    file.delete();
                }
                catch (IOException ex) {
                    LOG.warn((Object)("could not delete Anhang file: " + file.getName()), (Throwable)ex);
                }
            }
        }
    }

    public void sendMessagesForAllOpenAnfragen() {
        List<CidsBean> allOpenPruefungen = this.loadOpenAnfrageBeans();
        this.sendAnfrageMessages(allOpenPruefungen);
    }

    public boolean pruefung(String schluessel, String pruefer, Boolean pruefStatus, String begruendung, boolean pruefungsAbschluss) throws Exception {
        CidsBean pruefungBean = this.loadAnfrageBean(schluessel);
        BerechtigungspruefungDownloadInfo downloadInfo = BerechtigungspruefungHandler.extractDownloadInfo((String)pruefungBean.getProperty("downloadinfo_json"));
        if (!Boolean.TRUE.equals(pruefungBean.getProperty("abgeholt")) && pruefungBean.getProperty("pruefstatus") != null) {
            return true;
        }
        String userKey = (String)pruefungBean.getProperty("benutzer");
        Timestamp now = new Timestamp(new Date().getTime());
        pruefungBean.setProperty("abgeholt", null);
        pruefungBean.setProperty("pruefer", (Object)pruefer);
        pruefungBean.setProperty("pruefstatus", (Object)pruefStatus);
        if (pruefungsAbschluss) {
            pruefungBean.setProperty("freigabe_timestamp", (Object)now);
            pruefungBean.setProperty("pruefkommentar", (Object)begruendung);
        } else {
            pruefungBean.setProperty("pruefung_timestamp", (Object)now);
        }
        this.getMetaService().updateMetaObject(this.getUser(), pruefungBean.getMetaObject(), this.getConnectionContext());
        if (pruefungsAbschluss) {
            BerechtigungspruefungBillingDownloadInfo billingDownloadinfo;
            Integer billingId;
            if (downloadInfo instanceof BerechtigungspruefungBillingDownloadInfo && (billingId = (billingDownloadinfo = (BerechtigungspruefungBillingDownloadInfo)downloadInfo).getBillingId()) != null) {
                if (pruefStatus.booleanValue()) {
                    try {
                        String json = (String)pruefungBean.getProperty("downloadinfo_json");
                        this.updateRequestInBillingBean(billingId, json);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"error while setting 'request' of billing", (Throwable)ex);
                    }
                } else {
                    try {
                        this.updateStornoInBillingBean(billingId);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Error while setting 'storniert' of billing", (Throwable)ex);
                    }
                }
            }
            this.sendFreigabeMessage(userKey, Arrays.asList(pruefungBean));
        } else {
            this.sendProcessingMessage(schluessel);
        }
        return false;
    }

    public void sendMessagesForAllOpenFreigaben(String userKey) {
        List<CidsBean> allOpenDownloads = this.loadOpenFreigabeBeans(userKey);
        this.sendFreigabeMessage(userKey, allOpenDownloads);
    }

    private void sendProcessingMessage(String schluessel) {
        CidsServerMessageManagerImpl.getInstance().publishMessage(BerechtigungspruefungProperties.getInstance().getCsmBearbeitung(), (Object)schluessel, true, this.getConnectionContext());
    }

    public void sendMessagesForAllOpenFreigaben() {
        List<CidsBean> allOpenDownloads = this.loadOpenFreigabeBeans();
        if (allOpenDownloads != null) {
            HashMap dm = new HashMap();
            for (CidsBean openDownload : allOpenDownloads) {
                String userKey = (String)openDownload.getProperty("benutzer");
                if (userKey == null) continue;
                if (!dm.containsKey(userKey)) {
                    dm.put(userKey, new ArrayList());
                }
                ((Collection)dm.get(userKey)).add(openDownload);
            }
            for (String userKey : dm.keySet()) {
                this.sendFreigabeMessage(userKey, (Collection)dm.get(userKey));
            }
        }
    }

    private void sendAnfrageMessages(Collection<CidsBean> anfrageBeans) {
        ArrayList<String> schluesselList = new ArrayList<String>();
        if (anfrageBeans != null) {
            for (CidsBean anfrageBean : anfrageBeans) {
                schluesselList.add((String)anfrageBean.getProperty("schluessel"));
            }
        }
        CidsServerMessageManagerImpl.getInstance().publishMessage(BerechtigungspruefungProperties.getInstance().getCsmAnfrage(), schluesselList, true, this.getConnectionContext());
    }

    private void sendFreigabeMessage(String userKey, Collection<CidsBean> pruefungBeans) {
        if (pruefungBeans != null) {
            try {
                ArrayList<String> schluesselList = new ArrayList<String>();
                for (CidsBean pruefungBean : pruefungBeans) {
                    schluesselList.add((String)pruefungBean.getProperty("schluessel"));
                }
                if (!schluesselList.isEmpty()) {
                    CidsServerMessageManagerImpl.getInstance().publishMessage(BerechtigungspruefungProperties.getInstance().getCsmBearbeitung(), schluesselList, true, this.getConnectionContext());
                    CidsServerMessageManagerImpl.getInstance().publishMessage(BerechtigungspruefungProperties.getInstance().getCsmFreigabe(), schluesselList, false, new HashSet<String>(Arrays.asList(userKey)), true, this.getConnectionContext());
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"error while producing or sending message", (Throwable)ex);
            }
        }
    }

    public void closeAnfrage(String schluessel) throws Exception {
        CidsBean pruefungBean = this.loadAnfrageBean(schluessel);
        pruefungBean.setProperty("abholung_timestamp", (Object)new Timestamp(new Date().getTime()));
        pruefungBean.setProperty("abgeholt", (Object)true);
        DomainServerImpl.getServerInstance().updateMetaObject(this.getUser(), pruefungBean.getMetaObject(), this.getConnectionContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createNewSchluessel(BerechtigungspruefungDownloadInfo downloadInfo) {
        BerechtigungspruefungHandler berechtigungspruefungHandler = this;
        synchronized (berechtigungspruefungHandler) {
            String group;
            Pattern pattern;
            Matcher matcher;
            String lastAnfrageSchluessel;
            String type = BerechtigungspruefungBescheinigungDownloadInfo.PRODUKT_TYP.equals(downloadInfo.getProduktTyp()) ? "BlaB" : (BerechtigungspruefungAlkisDownloadInfo.PRODUKT_TYP.equals(downloadInfo.getProduktTyp()) ? "LB" : "?");
            int year = Calendar.getInstance().get(1);
            CidsBean lastAnfrageBean = this.loadLastAnfrageBeanByTypeAndYear(type, year);
            String string = lastAnfrageSchluessel = lastAnfrageBean != null ? (String)lastAnfrageBean.getProperty("schluessel") : null;
            int lastNumber = lastAnfrageSchluessel != null ? ((matcher = (pattern = Pattern.compile("^" + type + "-" + year + "-(\\d{5})$")).matcher(lastAnfrageSchluessel)).matches() ? ((group = matcher.group(1)) != null ? Integer.parseInt(group) : 0) : 0) : 0;
            int newNumber = lastNumber + 1;
            NumberFormat format = NumberFormat.getIntegerInstance();
            format.setMinimumIntegerDigits(5);
            format.setGroupingUsed(false);
            String newAnfrageSchluessel = type + "-" + Integer.toString(year) + "-" + format.format(newNumber);
            return newAnfrageSchluessel;
        }
    }

    public CidsBean addNewAnfrage(String userKey, String schluessel, BerechtigungspruefungDownloadInfo downloadInfo, String berechtigungsgrund, String begruendung, String dateiname, byte[] data) throws Exception {
        if (data != null && dateiname != null) {
            File file = new File(BerechtigungspruefungProperties.getInstance().getAnhangAbsPath() + "/" + schluessel);
            try {
                FileUtils.writeByteArrayToFile((File)file, (byte[])data);
            }
            catch (IOException ex) {
                throw new Exception("Datei konnte nicht geschrieben werden.", ex);
            }
        }
        CidsBean newPruefungBean = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)"berechtigungspruefung", (ConnectionContext)this.getConnectionContext());
        newPruefungBean.setProperty("dateiname", (Object)dateiname);
        newPruefungBean.setProperty("schluessel", (Object)schluessel);
        newPruefungBean.setProperty("anfrage_timestamp", (Object)new Timestamp(new Date().getTime()));
        newPruefungBean.setProperty("berechtigungsgrund", (Object)berechtigungsgrund);
        newPruefungBean.setProperty("begruendung", (Object)begruendung);
        newPruefungBean.setProperty("benutzer", (Object)userKey);
        newPruefungBean.setProperty("abgeholt", (Object)false);
        newPruefungBean.setProperty("pruefstatus", null);
        newPruefungBean.setProperty("produkttyp", (Object)downloadInfo.getProduktTyp());
        newPruefungBean.setProperty("downloadinfo_json", (Object)new ObjectMapper().writeValueAsString((Object)downloadInfo));
        CidsBean insertedPruefungBean = DomainServerImpl.getServerInstance().insertMetaObject(this.getUser(), newPruefungBean.getMetaObject(), this.getConnectionContext()).getBean();
        this.sendAnfrageMessages(Arrays.asList(insertedPruefungBean));
        return insertedPruefungBean;
    }

    private List<CidsBean> loadOpenAnfrageBeans() {
        try {
            ArrayList<CidsBean> beans = new ArrayList<CidsBean>();
            MetaClass mcBerechtigungspruefung = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"berechtigungspruefung", (ConnectionContext)this.getConnectionContext());
            String pruefungQuery = "SELECT DISTINCT " + mcBerechtigungspruefung.getID() + ", " + mcBerechtigungspruefung.getTableName() + "." + mcBerechtigungspruefung.getPrimaryKey() + " FROM " + mcBerechtigungspruefung.getTableName() + " WHERE " + mcBerechtigungspruefung.getTableName() + ".pruefstatus IS NULL;";
            MetaObject[] mos = this.getMetaService().getMetaObject(this.getUser(), pruefungQuery, this.getConnectionContext());
            if (mos != null && mos.length > 0) {
                for (MetaObject mo : mos) {
                    beans.add(mo.getBean());
                }
            }
            return beans;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while loading openPruefung beans", (Throwable)ex);
            return null;
        }
    }

    public List<CidsBean> loadOpenFreigabeBeans(String userKey) {
        try {
            ArrayList<CidsBean> beans = new ArrayList<CidsBean>();
            MetaClass mcBerechtigungspruefung = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"berechtigungspruefung", (ConnectionContext)this.getConnectionContext());
            String pruefungQuery = "SELECT DISTINCT " + mcBerechtigungspruefung.getID() + ", " + mcBerechtigungspruefung.getTableName() + "." + mcBerechtigungspruefung.getPrimaryKey() + " FROM " + mcBerechtigungspruefung.getTableName() + " WHERE benutzer ILIKE '" + userKey + "' AND " + mcBerechtigungspruefung.getTableName() + ".pruefstatus IS NOT NULL AND (" + mcBerechtigungspruefung.getTableName() + ".abgeholt IS NULL OR " + mcBerechtigungspruefung.getTableName() + ".abgeholt IS FALSE);";
            MetaObject[] mos = this.getMetaService().getMetaObject(this.getUser(), pruefungQuery, this.getConnectionContext());
            if (mos != null && mos.length > 0) {
                for (MetaObject mo : mos) {
                    beans.add(mo.getBean());
                }
            }
            return beans;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while loading openDownload beans", (Throwable)ex);
            return null;
        }
    }

    private List<CidsBean> loadOpenFreigabeBeans() {
        try {
            ArrayList<CidsBean> beans = new ArrayList<CidsBean>();
            MetaClass mcBerechtigungspruefung = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"berechtigungspruefung", (ConnectionContext)this.getConnectionContext());
            String pruefungQuery = "SELECT DISTINCT " + mcBerechtigungspruefung.getID() + ", " + mcBerechtigungspruefung.getTableName() + "." + mcBerechtigungspruefung.getPrimaryKey() + " FROM " + mcBerechtigungspruefung.getTableName() + " WHERE " + mcBerechtigungspruefung.getTableName() + ".pruefstatus IS NOT NULL AND (" + mcBerechtigungspruefung.getTableName() + ".abgeholt IS NULL OR " + mcBerechtigungspruefung.getTableName() + ".abgeholt IS FALSE);";
            MetaObject[] mos = this.getMetaService().getMetaObject(this.getUser(), pruefungQuery, this.getConnectionContext());
            if (mos != null && mos.length > 0) {
                for (MetaObject mo : mos) {
                    beans.add(mo.getBean());
                }
            }
            return beans;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while loading openDownload beans", (Throwable)ex);
            return null;
        }
    }

    private CidsBean loadAnfrageBean(String schluessel) {
        try {
            MetaClass mcBerechtigungspruefung = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"berechtigungspruefung", (ConnectionContext)this.getConnectionContext());
            String pruefungQuery = "SELECT DISTINCT " + mcBerechtigungspruefung.getID() + ", " + mcBerechtigungspruefung.getTableName() + "." + mcBerechtigungspruefung.getPrimaryKey() + " FROM " + mcBerechtigungspruefung.getTableName() + " WHERE " + mcBerechtigungspruefung.getTableName() + ".schluessel LIKE '" + schluessel + "' LIMIT 1;";
            MetaObject[] mos = this.getMetaService().getMetaObject(this.getUser(), pruefungQuery, this.getConnectionContext());
            if (mos != null && mos.length > 0) {
                return mos[0].getBean();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"error while loading pruefung bean", (Throwable)ex);
        }
        return null;
    }

    private CidsBean loadBillingBean(int id) throws Exception {
        MetaClass mcBillingBilling = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"billing_billing", (ConnectionContext)this.getConnectionContext());
        MetaObject mo = this.getMetaService().getMetaObject(this.getUser(), id, mcBillingBilling.getID(), this.getConnectionContext());
        return mo.getBean();
    }

    private void updateRequestInBillingBean(int id, String json) throws Exception {
        CidsBean billingBean = this.loadBillingBean(id);
        billingBean.setProperty("request", (Object)json);
        this.getMetaService().updateMetaObject(this.getUser(), billingBean.getMetaObject(), this.getConnectionContext());
    }

    private void updateStornoInBillingBean(int id) throws Exception {
        CidsBean billingBean = this.loadBillingBean(id);
        CidsBean billingStornogrundBean = this.loadBillingStornogrundBean();
        billingBean.setProperty("storniert", (Object)Boolean.TRUE);
        billingBean.setProperty("stornogrund", (Object)billingStornogrundBean);
        billingBean.setProperty("storniert_durch", (Object)this.getUser().toString());
        this.getMetaService().updateMetaObject(this.getUser(), billingBean.getMetaObject(), this.getConnectionContext());
    }

    private CidsBean loadBillingStornogrundBean() {
        try {
            MetaClass mcBillingStornogrund = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"billing_stornogrund", (ConnectionContext)this.getConnectionContext());
            MetaObject mo = this.getMetaService().getMetaObject(this.getUser(), BerechtigungspruefungProperties.getInstance().getBillingStornogrundId().intValue(), mcBillingStornogrund.getID(), this.getConnectionContext());
            return mo.getBean();
        }
        catch (Exception ex) {
            LOG.error((Object)"error while loading billing_billing bean", (Throwable)ex);
            return null;
        }
    }

    public CidsBean loadLastAnfrageBeanByTypeAndYear(String type, int year) {
        try {
            MetaClass mcBerechtigungspruefung = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)"berechtigungspruefung", (ConnectionContext)this.getConnectionContext());
            String tester = "^" + type + "-" + Integer.toString(year) + "-\\\\d{5}$";
            String pruefungQuery = "SELECT " + mcBerechtigungspruefung.getID() + ", " + mcBerechtigungspruefung.getTableName() + "." + mcBerechtigungspruefung.getPrimaryKey() + " FROM " + mcBerechtigungspruefung.getTableName() + " WHERE " + mcBerechtigungspruefung.getTableName() + ".schluessel ~ E'" + tester + "' ORDER BY schluessel DESC LIMIT 1;";
            MetaObject[] mos = this.getMetaService().getMetaObject(this.getUser(), pruefungQuery, this.getConnectionContext());
            if (mos != null && mos.length > 0) {
                return mos[0].getBean();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"error while loading pruefung bean", (Throwable)ex);
        }
        return null;
    }

    public static BerechtigungspruefungDownloadInfo extractDownloadInfo(String downloadinfoJson) throws Exception {
        BerechtigungspruefungDownloadInfo berechtigungspruefungDownloadInfo = (BerechtigungspruefungDownloadInfo)MAPPER.readValue(downloadinfoJson, BerechtigungspruefungDownloadInfo.class);
        if (BerechtigungspruefungBescheinigungDownloadInfo.PRODUKT_TYP.equals(berechtigungspruefungDownloadInfo.getProduktTyp())) {
            return (BerechtigungspruefungDownloadInfo)MAPPER.readValue(downloadinfoJson, BerechtigungspruefungBescheinigungDownloadInfo.class);
        }
        if (BerechtigungspruefungAlkisDownloadInfo.PRODUKT_TYP.equals(berechtigungspruefungDownloadInfo.getProduktTyp())) {
            BerechtigungspruefungAlkisDownloadInfo alkisDownloadInfo = (BerechtigungspruefungAlkisDownloadInfo)MAPPER.readValue(downloadinfoJson, BerechtigungspruefungAlkisDownloadInfo.class);
            if (BerechtigungspruefungAlkisDownloadInfo.AlkisDownloadTyp.EINZELNACHWEIS.equals((Object)alkisDownloadInfo.getAlkisDownloadTyp())) {
                return (BerechtigungspruefungDownloadInfo)MAPPER.readValue(downloadinfoJson, BerechtigungspruefungAlkisEinzelnachweisDownloadInfo.class);
            }
            if (BerechtigungspruefungAlkisDownloadInfo.AlkisDownloadTyp.KARTE.equals((Object)alkisDownloadInfo.getAlkisDownloadTyp())) {
                return (BerechtigungspruefungDownloadInfo)MAPPER.readValue(downloadinfoJson, BerechtigungspruefungAlkisKarteDownloadInfo.class);
            }
        } else if (BerechtigungspruefungAlkisEinzelnachweisDownloadInfo.PRODUKT_TYP.equals(berechtigungspruefungDownloadInfo.getProduktTyp())) {
            return (BerechtigungspruefungDownloadInfo)MAPPER.readValue(downloadinfoJson, BerechtigungspruefungAlkisEinzelnachweisDownloadInfo.class);
        }
        throw new Exception("unbekannter Download-Typ");
    }

    public static Date getThresholdAnhangDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        Date threshold = new Date(calendar.getTimeInMillis());
        return threshold;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public User getUser() {
        return this.user;
    }

    private static final class LazyInitialiser {
        private static final BerechtigungspruefungHandler INSTANCE = new BerechtigungspruefungHandler();

        private LazyInitialiser() {
        }
    }
}

